/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;

@NodeInfo
public class DynamicNewInstanceNode
extends AbstractNewObjectNode
implements Canonicalizable {
    public static final NodeClass<DynamicNewInstanceNode> TYPE = NodeClass.create(DynamicNewInstanceNode.class);
    @Node.Input
    ValueNode clazz;
    @Node.OptionalInput
    ValueNode classClass;

    public DynamicNewInstanceNode(ValueNode clazz, boolean fillContents) {
        this(TYPE, clazz, fillContents, null);
    }

    protected DynamicNewInstanceNode(NodeClass<? extends DynamicNewInstanceNode> c, ValueNode clazz, boolean fillContents, FrameState stateBefore) {
        super(c, StampFactory.objectNonNull(), fillContents, stateBefore);
        this.clazz = clazz;
        assert (((ObjectStamp)clazz.stamp(NodeView.DEFAULT)).nonNull());
    }

    public ValueNode getInstanceType() {
        return this.clazz;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.clazz.isConstant()) {
            if (GraalOptions.GeneratePIC.getValue(tool.getOptions()).booleanValue()) {
                return this;
            }
            ResolvedJavaType type = tool.getConstantReflection().asJavaType(this.clazz.asConstant());
            if (type != null && !DynamicNewInstanceNode.throwsInstantiationException(type, tool.getMetaAccess()) && tool.getMetaAccessExtensionProvider().canConstantFoldDynamicAllocation(type)) {
                return new NewInstanceNode(type, this.fillContents(), this.stateBefore());
            }
        }
        return this;
    }

    public static boolean throwsInstantiationException(Class<?> type, Class<?> classClass) {
        return type.isPrimitive() || type.isArray() || type.isInterface() || Modifier.isAbstract(type.getModifiers()) || type == classClass;
    }

    public static boolean throwsInstantiationException(ResolvedJavaType type, MetaAccessProvider metaAccess) {
        return type.isPrimitive() || type.isArray() || type.isInterface() || Modifier.isAbstract(type.getModifiers()) || type.equals(metaAccess.lookupJavaType(Class.class));
    }

    public ValueNode getClassClass() {
        return this.classClass;
    }

    public void setClassClass(ValueNode newClassClass) {
        this.updateUsages(this.classClass, newClassClass);
        this.classClass = newClassClass;
    }
}

