/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.gc;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ArrayRangeWrite;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ReferentFieldReadBarrier;
import org.graalvm.compiler.nodes.java.AbstractCompareAndSwapNode;
import org.graalvm.compiler.nodes.java.LoweredAtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.type.StampTool;

public class G1BarrierSet
implements BarrierSet {
    private final ResolvedJavaType objectArrayType;
    private final ResolvedJavaField referentField;

    public G1BarrierSet(ResolvedJavaType objectArrayType, ResolvedJavaField referentField) {
        this.objectArrayType = objectArrayType;
        this.referentField = referentField;
    }

    @Override
    public OnHeapMemoryAccess.BarrierType readBarrierType(RawLoadNode load) {
        if (load.object().getStackKind() == JavaKind.Object && load.accessKind() == JavaKind.Object && !StampTool.isPointerAlwaysNull(load.object())) {
            long referentOffset = this.referentField.getOffset();
            assert (referentOffset > 0L);
            if (load.offset().isJavaConstant() && referentOffset != load.offset().asJavaConstant().asLong()) {
                return OnHeapMemoryAccess.BarrierType.NONE;
            }
            ResolvedJavaType referenceType = this.referentField.getDeclaringClass();
            ResolvedJavaType type = StampTool.typeOrNull(load.object());
            if (type != null && referenceType.isAssignableFrom(type)) {
                if (load.offset().isJavaConstant() && referentOffset == load.offset().asJavaConstant().asLong()) {
                    return OnHeapMemoryAccess.BarrierType.WEAK_FIELD;
                }
                return OnHeapMemoryAccess.BarrierType.MAYBE_WEAK_FIELD;
            }
            if (type == null || type.isAssignableFrom(referenceType)) {
                return OnHeapMemoryAccess.BarrierType.MAYBE_WEAK_FIELD;
            }
        }
        return OnHeapMemoryAccess.BarrierType.NONE;
    }

    @Override
    public OnHeapMemoryAccess.BarrierType storeBarrierType(RawStoreNode store) {
        return store.needsBarrier() ? this.guessStoreBarrierType(store.object(), store.value()) : OnHeapMemoryAccess.BarrierType.NONE;
    }

    @Override
    public OnHeapMemoryAccess.BarrierType fieldLoadBarrierType(ResolvedJavaField field, JavaKind storageKind) {
        if (field.getJavaKind() == JavaKind.Object && field.equals(this.referentField)) {
            return OnHeapMemoryAccess.BarrierType.WEAK_FIELD;
        }
        return OnHeapMemoryAccess.BarrierType.NONE;
    }

    @Override
    public OnHeapMemoryAccess.BarrierType fieldStoreBarrierType(ResolvedJavaField field, JavaKind storageKind) {
        return storageKind == JavaKind.Object ? OnHeapMemoryAccess.BarrierType.FIELD : OnHeapMemoryAccess.BarrierType.NONE;
    }

    @Override
    public OnHeapMemoryAccess.BarrierType arrayStoreBarrierType(JavaKind storageKind) {
        return storageKind == JavaKind.Object ? OnHeapMemoryAccess.BarrierType.ARRAY : OnHeapMemoryAccess.BarrierType.NONE;
    }

    @Override
    public OnHeapMemoryAccess.BarrierType guessStoreBarrierType(ValueNode object, ValueNode value) {
        if (value.getStackKind() == JavaKind.Object && object.getStackKind() == JavaKind.Object) {
            ResolvedJavaType type = StampTool.typeOrNull(object);
            if (type != null && type.isArray()) {
                return OnHeapMemoryAccess.BarrierType.ARRAY;
            }
            if (type == null || type.isAssignableFrom(this.objectArrayType)) {
                return OnHeapMemoryAccess.BarrierType.UNKNOWN;
            }
            return OnHeapMemoryAccess.BarrierType.FIELD;
        }
        return OnHeapMemoryAccess.BarrierType.NONE;
    }

    @Override
    public void addBarriers(FixedAccessNode n) {
        if (n instanceof ReadNode) {
            G1BarrierSet.addReadNodeBarriers((ReadNode)n);
        } else if (n instanceof WriteNode) {
            WriteNode write = (WriteNode)n;
            this.addWriteBarriers(write, write.value(), null, true, write.getNullCheck());
        } else if (n instanceof LoweredAtomicReadAndWriteNode) {
            LoweredAtomicReadAndWriteNode atomic = (LoweredAtomicReadAndWriteNode)n;
            this.addWriteBarriers(atomic, atomic.getNewValue(), null, true, atomic.getNullCheck());
        } else if (n instanceof AbstractCompareAndSwapNode) {
            AbstractCompareAndSwapNode cmpSwap = (AbstractCompareAndSwapNode)n;
            this.addWriteBarriers(cmpSwap, cmpSwap.getNewValue(), cmpSwap.getExpectedValue(), false, false);
        } else if (n instanceof ArrayRangeWrite) {
            G1BarrierSet.addArrayRangeBarriers((ArrayRangeWrite)((Object)n));
        } else {
            GraalError.guarantee(n.getBarrierType() == OnHeapMemoryAccess.BarrierType.NONE, "missed a node that requires a GC barrier: %s", n.getClass());
        }
    }

    private static void addReadNodeBarriers(ReadNode node) {
        if (node.getBarrierType() == OnHeapMemoryAccess.BarrierType.WEAK_FIELD || node.getBarrierType() == OnHeapMemoryAccess.BarrierType.MAYBE_WEAK_FIELD) {
            StructuredGraph graph = node.graph();
            G1ReferentFieldReadBarrier barrier = graph.add(new G1ReferentFieldReadBarrier(node.getAddress(), node, node.getBarrierType() == OnHeapMemoryAccess.BarrierType.MAYBE_WEAK_FIELD));
            graph.addAfterFixed(node, barrier);
        }
    }

    private void addWriteBarriers(FixedAccessNode node, ValueNode writtenValue, ValueNode expectedValue, boolean doLoad, boolean nullCheck) {
        OnHeapMemoryAccess.BarrierType barrierType = node.getBarrierType();
        switch (barrierType) {
            case NONE: {
                break;
            }
            case FIELD: 
            case ARRAY: 
            case UNKNOWN: {
                if (!G1BarrierSet.isObjectValue(writtenValue)) break;
                StructuredGraph graph = node.graph();
                boolean init = node.getLocationIdentity().isInit();
                if (!init) {
                    G1BarrierSet.addG1PreWriteBarrier(node, node.getAddress(), expectedValue, doLoad, nullCheck, graph);
                }
                if (!this.writeRequiresPostBarrier(node, writtenValue)) break;
                boolean precise = barrierType != OnHeapMemoryAccess.BarrierType.FIELD;
                G1BarrierSet.addG1PostWriteBarrier(node, node.getAddress(), writtenValue, precise, graph);
                break;
            }
            default: {
                throw new GraalError("unexpected barrier type: " + (Object)((Object)barrierType));
            }
        }
    }

    protected boolean writeRequiresPostBarrier(FixedAccessNode node, ValueNode writtenValue) {
        assert (G1BarrierSet.isObjectValue(writtenValue));
        return !StampTool.isPointerAlwaysNull(writtenValue);
    }

    private static void addArrayRangeBarriers(ArrayRangeWrite write) {
        if (write.writesObjectArray()) {
            StructuredGraph graph = write.asNode().graph();
            if (!write.isInitialization()) {
                G1ArrayRangePreWriteBarrier g1ArrayRangePreWriteBarrier = graph.add(new G1ArrayRangePreWriteBarrier(write.getAddress(), write.getLength(), write.getElementStride()));
                graph.addBeforeFixed(write.asNode(), g1ArrayRangePreWriteBarrier);
            }
            G1ArrayRangePostWriteBarrier g1ArrayRangePostWriteBarrier = graph.add(new G1ArrayRangePostWriteBarrier(write.getAddress(), write.getLength(), write.getElementStride()));
            graph.addAfterFixed(write.asNode(), g1ArrayRangePostWriteBarrier);
        }
    }

    private static void addG1PreWriteBarrier(FixedAccessNode node, AddressNode address, ValueNode value, boolean doLoad, boolean nullCheck, StructuredGraph graph) {
        G1PreWriteBarrier preBarrier = graph.add(new G1PreWriteBarrier(address, value, doLoad, nullCheck));
        preBarrier.setStateBefore(node.stateBefore());
        node.setNullCheck(false);
        node.setStateBefore(null);
        graph.addBeforeFixed(node, preBarrier);
    }

    private static void addG1PostWriteBarrier(FixedAccessNode node, AddressNode address, ValueNode value, boolean precise, StructuredGraph graph) {
        boolean alwaysNull = StampTool.isPointerAlwaysNull(value);
        graph.addAfterFixed(node, graph.add(new G1PostWriteBarrier(address, value, precise, alwaysNull)));
    }

    private static boolean isObjectValue(ValueNode value) {
        return value.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp;
    }
}

