/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodes.DeoptBciSupplier;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

public interface ForeignCall
extends LIRLowerable,
DeoptimizingNode.DeoptDuring,
MultiMemoryKill,
StateSplit,
DeoptBciSupplier {
    public NodeInputList<ValueNode> getArguments();

    @Override
    public void setBci(int var1);

    public ForeignCallDescriptor getDescriptor();

    @Override
    default public LocationIdentity[] getKilledLocationIdentities() {
        return this.getDescriptor().getKilledLocations();
    }

    default public Value[] operands(NodeLIRBuilderTool gen) {
        Value[] operands = new Value[this.getArguments().size()];
        for (int i = 0; i < operands.length; ++i) {
            operands[i] = gen.operand((Node)this.getArguments().get(i));
        }
        return operands;
    }

    @Override
    default public void computeStateDuring(FrameState currentStateAfter) {
        FrameState newStateDuring;
        if (!1.$assertionsDisabled && this.stateDuring() != null) {
            throw new AssertionError();
        }
        if (currentStateAfter.stackSize() > 0 && currentStateAfter.stackAt(currentStateAfter.stackSize() - 1) == this || currentStateAfter.stackSize() > 1 && currentStateAfter.stackAt(currentStateAfter.stackSize() - 2) == this) {
            if (!1.$assertionsDisabled && this.bci() == -5) {
                throw new AssertionError(this);
            }
            newStateDuring = currentStateAfter.duplicateModified(currentStateAfter.graph(), this.bci(), false, true, this.asNode().getStackKind(), null, null);
        } else {
            newStateDuring = currentStateAfter;
        }
        this.setStateDuring(newStateDuring);
    }

    @Override
    default public boolean canDeoptimize() {
        return this.getDescriptor().canDeoptimize();
    }

    default public boolean isGuaranteedSafepoint() {
        return this.getDescriptor().isGuaranteedSafepoint();
    }

    @Override
    default public void generate(NodeLIRBuilderTool gen) {
        gen.emitForeignCall(this);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

