/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo(shortName="==", cycles=NodeCycles.CYCLES_2)
public final class FloatEqualsNode
extends CompareNode
implements Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<FloatEqualsNode> TYPE = NodeClass.create(FloatEqualsNode.class);
    private static final FloatEqualsOp OP = new FloatEqualsOp();

    public FloatEqualsNode(ValueNode x, ValueNode y) {
        super(TYPE, CanonicalCondition.EQ, false, x, y);
        assert (!x.getStackKind().isNumericInteger() && x.getStackKind() != JavaKind.Object);
        assert (!y.getStackKind().isNumericInteger() && y.getStackKind() != JavaKind.Object);
        assert (x.stamp(NodeView.DEFAULT).isCompatible(y.stamp(NodeView.DEFAULT)));
    }

    public static LogicNode create(ValueNode x, ValueNode y, NodeView view) {
        LogicNode result = CompareNode.tryConstantFoldPrimitive(CanonicalCondition.EQ, x, y, false, view);
        if (result != null) {
            return result;
        }
        return new FloatEqualsNode(x, y).maybeCommuteInputs();
    }

    public static LogicNode create(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, ValueNode x, ValueNode y, NodeView view) {
        LogicNode value = OP.canonical(constantReflection, metaAccess, options, smallestCompareWidth, CanonicalCondition.EQ, false, x, y, view);
        if (value != null) {
            return value;
        }
        return FloatEqualsNode.create(x, y, view);
    }

    @Override
    public boolean isIdentityComparison() {
        Stamp xStamp = this.x.stamp(NodeView.DEFAULT);
        Stamp yStamp = this.y.stamp(NodeView.DEFAULT);
        if (xStamp instanceof FloatStamp && yStamp instanceof FloatStamp) {
            return !((FloatStamp)xStamp).contains(0.0) || !((FloatStamp)yStamp).contains(0.0);
        }
        return false;
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        LogicNode value = OP.canonical(tool.getConstantReflection(), tool.getMetaAccess(), tool.getOptions(), tool.smallestCompareWidth(), CanonicalCondition.EQ, this.unorderedIsTrue, forX, forY, view);
        if (value != null) {
            return value;
        }
        return this;
    }

    @Override
    public Stamp getSucceedingStampForX(boolean negated, Stamp xStamp, Stamp yStamp) {
        if (!negated) {
            return xStamp.join(yStamp);
        }
        return null;
    }

    @Override
    public Stamp getSucceedingStampForY(boolean negated, Stamp xStamp, Stamp yStamp) {
        if (!negated) {
            return xStamp.join(yStamp);
        }
        return null;
    }

    @Override
    public TriState tryFold(Stamp xStampGeneric, Stamp yStampGeneric) {
        if (xStampGeneric instanceof FloatStamp && yStampGeneric instanceof FloatStamp) {
            FloatStamp xStamp = (FloatStamp)xStampGeneric;
            FloatStamp yStamp = (FloatStamp)yStampGeneric;
            if (xStamp.alwaysDistinct(yStamp)) {
                return TriState.FALSE;
            }
            if (xStamp.neverDistinct(yStamp)) {
                return TriState.TRUE;
            }
        }
        return TriState.UNKNOWN;
    }

    public static class FloatEqualsOp
    extends CompareNode.CompareOp {
        @Override
        public LogicNode canonical(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, boolean unorderedIsTrue, ValueNode forX, ValueNode forY, NodeView view) {
            LogicNode result = super.canonical(constantReflection, metaAccess, options, smallestCompareWidth, condition, unorderedIsTrue, forX, forY, view);
            if (result != null) {
                return result;
            }
            Stamp xStampGeneric = forX.stamp(view);
            Stamp yStampGeneric = forY.stamp(view);
            if (xStampGeneric instanceof FloatStamp && yStampGeneric instanceof FloatStamp) {
                FloatStamp xStamp = (FloatStamp)xStampGeneric;
                FloatStamp yStamp = (FloatStamp)yStampGeneric;
                if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY) && xStamp.isNonNaN() && yStamp.isNonNaN()) {
                    return LogicConstantNode.tautology();
                }
                if (xStamp.alwaysDistinct(yStamp)) {
                    return LogicConstantNode.contradiction();
                }
            }
            return null;
        }

        @Override
        protected CompareNode duplicateModified(ValueNode newX, ValueNode newY, boolean unorderedIsTrue, NodeView view) {
            if (newX.stamp(view) instanceof FloatStamp && newY.stamp(view) instanceof FloatStamp) {
                return new FloatEqualsNode(newX, newY);
            }
            if (newX.stamp(view) instanceof IntegerStamp && newY.stamp(view) instanceof IntegerStamp) {
                return new IntegerEqualsNode(newX, newY);
            }
            throw GraalError.shouldNotReachHere();
        }
    }
}

