/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.IntegerTestNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_2)
public final class ConditionalNode
extends FloatingNode
implements Canonicalizable,
LIRLowerable {
    public static final NodeClass<ConditionalNode> TYPE = NodeClass.create(ConditionalNode.class);
    @Node.Input(value=InputType.Condition)
    LogicNode condition;
    @Node.Input(value=InputType.Value)
    ValueNode trueValue;
    @Node.Input(value=InputType.Value)
    ValueNode falseValue;

    public LogicNode condition() {
        return this.condition;
    }

    public ConditionalNode(LogicNode condition) {
        this(condition, ConstantNode.forInt(1, condition.graph()), ConstantNode.forInt(0, condition.graph()));
    }

    public ConditionalNode(LogicNode condition, ValueNode trueValue, ValueNode falseValue) {
        super((NodeClass<? extends FloatingNode>)TYPE, trueValue.stamp(NodeView.DEFAULT).meet(falseValue.stamp(NodeView.DEFAULT)));
        assert (trueValue.stamp(NodeView.DEFAULT).isCompatible(falseValue.stamp(NodeView.DEFAULT)));
        this.condition = condition;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    public static ValueNode create(LogicNode condition, NodeView view) {
        return ConditionalNode.create(condition, ConstantNode.forInt(1, condition.graph()), ConstantNode.forInt(0, condition.graph()), view);
    }

    public static ValueNode create(LogicNode condition, ValueNode trueValue, ValueNode falseValue, NodeView view) {
        ValueNode synonym = ConditionalNode.findSynonym(condition, trueValue, falseValue, view);
        if (synonym != null) {
            return synonym;
        }
        ValueNode result = ConditionalNode.canonicalizeConditional(condition, trueValue, falseValue, trueValue.stamp(view).meet(falseValue.stamp(view)), view);
        if (result != null) {
            return result;
        }
        return new ConditionalNode(condition, trueValue, falseValue);
    }

    @Override
    public boolean inferStamp() {
        Stamp valueStamp = this.trueValue.stamp(NodeView.DEFAULT).meet(this.falseValue.stamp(NodeView.DEFAULT));
        if (this.condition instanceof IntegerLessThanNode) {
            IntegerLessThanNode lessThan = (IntegerLessThanNode)this.condition;
            if (lessThan.getX() == this.trueValue && lessThan.getY() == this.falseValue) {
                JavaConstant constant = lessThan.getX().asJavaConstant();
                if (constant == null) {
                    constant = lessThan.getY().asJavaConstant();
                }
                if (constant != null) {
                    IntegerStamp bounds = StampFactory.forInteger(constant.getJavaKind(), constant.getJavaKind().getMinValue(), constant.asLong());
                    valueStamp = valueStamp.join(bounds);
                }
            } else if (lessThan.getX() == this.falseValue && lessThan.getY() == this.trueValue) {
                JavaConstant constant = lessThan.getX().asJavaConstant();
                if (constant == null) {
                    constant = lessThan.getY().asJavaConstant();
                }
                if (constant != null) {
                    IntegerStamp bounds = StampFactory.forInteger(constant.getJavaKind(), constant.asLong(), constant.getJavaKind().getMaxValue());
                    valueStamp = valueStamp.join(bounds);
                }
            }
        }
        return this.updateStamp(valueStamp);
    }

    public ValueNode trueValue() {
        return this.trueValue;
    }

    public ValueNode falseValue() {
        return this.falseValue;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        NodeView view = NodeView.from(tool);
        ValueNode synonym = ConditionalNode.findSynonym(this.condition, this.trueValue(), this.falseValue(), view);
        if (synonym != null) {
            return synonym;
        }
        ValueNode result = ConditionalNode.canonicalizeConditional(this.condition, this.trueValue(), this.falseValue(), this.stamp, view);
        if (result != null) {
            return result;
        }
        return this;
    }

    public static ValueNode canonicalizeConditional(LogicNode condition, ValueNode trueValue, ValueNode falseValue, Stamp stamp, NodeView view) {
        CompareNode compare;
        if (trueValue == falseValue) {
            return trueValue;
        }
        if (condition instanceof CompareNode && ((CompareNode)condition).isIdentityComparison() && ((compare = (CompareNode)condition).getX() == trueValue && compare.getY() == falseValue || compare.getX() == falseValue && compare.getY() == trueValue)) {
            return falseValue;
        }
        if (trueValue.stamp(view) instanceof IntegerStamp) {
            AddNode add;
            IntegerLessThanNode lt;
            if (condition instanceof IntegerLessThanNode) {
                IntegerLessThanNode lessThan = (IntegerLessThanNode)condition;
                IntegerStamp falseValueStamp = (IntegerStamp)falseValue.stamp(view);
                IntegerStamp trueValueStamp = (IntegerStamp)trueValue.stamp(view);
                if (lessThan.getX() == trueValue && lessThan.getY() == falseValue ? trueValueStamp.upperBound() <= falseValueStamp.lowerBound() : lessThan.getX() == falseValue && lessThan.getY() == trueValue && falseValueStamp.upperBound() <= trueValueStamp.lowerBound()) {
                    return trueValue;
                }
            }
            if (trueValue.isConstant() && falseValue.isConstant()) {
                long testY;
                IntegerTestNode integerTestNode;
                long constTrueValue = trueValue.asJavaConstant().asLong();
                long constFalseValue = falseValue.asJavaConstant().asLong();
                if (condition instanceof IntegerEqualsNode) {
                    IntegerStamp equalsXStamp;
                    IntegerEqualsNode equals = (IntegerEqualsNode)condition;
                    if (equals.getY().isConstant() && equals.getX().stamp(view) instanceof IntegerStamp && (equalsXStamp = (IntegerStamp)equals.getX().stamp(view)).upMask() == 1L) {
                        long equalsY = equals.getY().asJavaConstant().asLong();
                        if (equalsY == 0L) {
                            if (constTrueValue == 0L && constFalseValue == 1L) {
                                return IntegerConvertNode.convertUnsigned(equals.getX(), stamp, view);
                            }
                            if (constTrueValue == 1L && constFalseValue == 0L) {
                                return IntegerConvertNode.convertUnsigned(XorNode.create(equals.getX(), ConstantNode.forIntegerStamp(equals.getX().stamp(view), 1L), view), stamp, view);
                            }
                        } else if (equalsY == 1L) {
                            if (constTrueValue == 1L && constFalseValue == 0L) {
                                return IntegerConvertNode.convertUnsigned(equals.getX(), stamp, view);
                            }
                            if (constTrueValue == 0L && constFalseValue == 1L) {
                                return IntegerConvertNode.convertUnsigned(XorNode.create(equals.getX(), ConstantNode.forIntegerStamp(equals.getX().stamp(view), 1L), view), stamp, view);
                            }
                        }
                    }
                } else if (condition instanceof IntegerTestNode && (integerTestNode = (IntegerTestNode)condition).getY().isConstant() && integerTestNode.getX().stamp(view) instanceof IntegerStamp && (testY = integerTestNode.getY().asJavaConstant().asLong()) == 1L && constTrueValue == 0L && constFalseValue == 1L) {
                    return IntegerConvertNode.convertUnsigned(AndNode.create(integerTestNode.getX(), integerTestNode.getY(), view), stamp, view);
                }
            }
            if (condition instanceof IntegerLessThanNode && (lt = (IntegerLessThanNode)condition).getY().isDefaultConstant() && falseValue == lt.getX() && trueValue instanceof AddNode && (add = (AddNode)trueValue).getX() == falseValue) {
                int bits = ((IntegerStamp)trueValue.stamp(NodeView.DEFAULT)).getBits();
                RightShiftNode shift = new RightShiftNode(lt.getX(), ConstantNode.forIntegerBits(32, bits - 1));
                AndNode and = new AndNode(shift, add.getY());
                return new AddNode(add.getX(), and);
            }
        }
        return null;
    }

    private static ValueNode findSynonym(ValueNode condition, ValueNode trueValue, ValueNode falseValue, NodeView view) {
        if (condition instanceof LogicNegationNode) {
            LogicNegationNode negated = (LogicNegationNode)condition;
            return ConditionalNode.create(negated.getValue(), falseValue, trueValue, view);
        }
        if (condition instanceof LogicConstantNode) {
            LogicConstantNode c = (LogicConstantNode)condition;
            if (c.getValue()) {
                return trueValue;
            }
            return falseValue;
        }
        return null;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        generator.emitConditional(this);
    }

    public ConditionalNode(StructuredGraph graph, CanonicalCondition condition, ValueNode x, ValueNode y) {
        this(CompareNode.createCompareNode(graph, condition, x, y, null, NodeView.DEFAULT));
    }
}

