/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.KillingBeginNode;
import org.graalvm.compiler.nodes.MultiKillingBeginNode;
import org.graalvm.compiler.nodes.UnreachableBeginNode;
import org.graalvm.compiler.nodes.UnreachableControlSinkNode;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo
public abstract class WithExceptionNode
extends ControlSplitNode {
    public static final NodeClass<WithExceptionNode> TYPE = NodeClass.create(WithExceptionNode.class);
    private static final double EXCEPTION_PROBABILITY = 1.0E-5;
    @Node.Successor
    protected AbstractBeginNode next;
    @Node.Successor
    protected AbstractBeginNode exceptionEdge;

    protected WithExceptionNode(NodeClass<? extends WithExceptionNode> c, Stamp stamp) {
        super((NodeClass<? extends ControlSplitNode>)c, stamp);
    }

    public AbstractBeginNode next() {
        return this.next;
    }

    public void setNext(AbstractBeginNode x) {
        this.updatePredecessor(this.next, x);
        this.next = x;
    }

    @Override
    public AbstractBeginNode getPrimarySuccessor() {
        return this.next();
    }

    public AbstractBeginNode exceptionEdge() {
        return this.exceptionEdge;
    }

    public void setExceptionEdge(AbstractBeginNode x) {
        this.updatePredecessor(this.exceptionEdge, x);
        this.exceptionEdge = x;
    }

    public void killExceptionEdge() {
        AbstractBeginNode edge = this.exceptionEdge();
        this.setExceptionEdge(null);
        GraphUtil.killCFG(edge);
    }

    @Override
    public double probability(AbstractBeginNode successor) {
        return successor == this.next ? 0.99999 : 1.0E-5;
    }

    @Override
    public boolean setProbability(AbstractBeginNode successor, double value) {
        return false;
    }

    @Override
    public int getSuccessorCount() {
        return 2;
    }

    public FixedNode replaceWithNonThrowing() {
        this.killExceptionEdge();
        AbstractBeginNode newExceptionEdge = this.graph().add(new UnreachableBeginNode());
        newExceptionEdge.setNext(this.graph().add(new UnreachableControlSinkNode()));
        this.setExceptionEdge(newExceptionEdge);
        return this;
    }

    public AbstractBeginNode createNextBegin() {
        if (this instanceof SingleMemoryKill) {
            return KillingBeginNode.create(((SingleMemoryKill)((Object)this)).getKilledLocationIdentity());
        }
        if (this instanceof MultiMemoryKill) {
            return MultiKillingBeginNode.create(((MultiMemoryKill)((Object)this)).getKilledLocationIdentities());
        }
        return new BeginNode();
    }
}

