/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.graph.spi.Simplifiable;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.BeginStateSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(allowedUsageTypes={InputType.Association}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class LoopExitNode
extends BeginStateSplitNode
implements IterableNodeType,
Simplifiable {
    public static final NodeClass<LoopExitNode> TYPE = NodeClass.create(LoopExitNode.class);
    @Node.Input(value=InputType.Association)
    AbstractBeginNode loopBegin;

    public LoopExitNode(LoopBeginNode loop) {
        super((NodeClass<? extends BeginStateSplitNode>)TYPE);
        assert (loop != null);
        this.loopBegin = loop;
    }

    public LoopBeginNode loopBegin() {
        return (LoopBeginNode)this.loopBegin;
    }

    @Override
    public NodeIterable<Node> anchored() {
        return super.anchored().filter(n -> {
            if (n instanceof ProxyNode) {
                ProxyNode proxyNode = (ProxyNode)n;
                return proxyNode.proxyPoint() != this;
            }
            return true;
        });
    }

    @Override
    public void prepareDelete(FixedNode evacuateFrom) {
        this.removeProxies();
        super.prepareDelete(evacuateFrom);
    }

    public void removeProxies() {
        if (this.hasUsages()) {
            block0: while (true) {
                for (ProxyNode vpn : this.proxies().snapshot()) {
                    ValueNode value = vpn.value();
                    vpn.replaceAtUsagesAndDelete(value);
                    if (value != this) continue;
                    continue block0;
                }
                break;
            }
        }
    }

    public NodeIterable<ProxyNode> proxies() {
        return this.usages().filter(n -> {
            if (n instanceof ProxyNode) {
                ProxyNode proxyNode = (ProxyNode)n;
                return proxyNode.proxyPoint() == this;
            }
            return false;
        });
    }

    public void removeExit() {
        this.removeProxies();
        FrameState loopStateAfter = this.stateAfter();
        this.graph().replaceFixedWithFixed(this, this.graph().add(new BeginNode()));
        if (loopStateAfter != null) {
            GraphUtil.tryKillUnused(loopStateAfter);
        }
    }

    @Override
    public void simplify(SimplifierTool tool) {
        Node prev = this.predecessor();
        while (tool.allUsagesAvailable() && prev instanceof BeginNode && prev.hasNoUsages()) {
            AbstractBeginNode begin = (AbstractBeginNode)prev;
            this.setNodeSourcePosition(begin.getNodeSourcePosition());
            prev = prev.predecessor();
            this.graph().removeFixed(begin);
        }
    }

    @Override
    public boolean verify() {
        assert (!this.graph().getFrameStateVerification().implies(StructuredGraph.FrameStateVerificationFeature.LOOP_EXITS) || this.stateAfter != null) : "Loop exit must have a state until FSA " + this;
        return super.verify();
    }
}

