/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(nameTemplate="{p#value}", cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class LogicConstantNode
extends LogicNode
implements LIRLowerable {
    public static final NodeClass<LogicConstantNode> TYPE = NodeClass.create(LogicConstantNode.class);
    protected final boolean value;

    public LogicConstantNode(boolean value) {
        super((NodeClass<? extends LogicNode>)TYPE);
        this.value = value;
    }

    public static LogicConstantNode forBoolean(boolean v, Graph graph) {
        return graph.unique(new LogicConstantNode(v));
    }

    public static LogicConstantNode forBoolean(boolean v) {
        return new LogicConstantNode(v);
    }

    public static LogicConstantNode tautology(Graph graph) {
        return LogicConstantNode.forBoolean(true, graph);
    }

    public static LogicConstantNode contradiction(Graph graph) {
        return LogicConstantNode.forBoolean(false, graph);
    }

    public static LogicConstantNode tautology() {
        return LogicConstantNode.forBoolean(true);
    }

    public static LogicConstantNode contradiction() {
        return LogicConstantNode.forBoolean(false);
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
    }
}

