/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Map;
import jdk.vm.ci.code.BytecodeFrame;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.KillingBeginNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.UncheckedInterfaceProvider;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Invoke!#{p#targetMethod/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
public final class InvokeWithExceptionNode
extends WithExceptionNode
implements Invoke,
IterableNodeType,
SingleMemoryKill,
LIRLowerable,
UncheckedInterfaceProvider {
    public static final NodeClass<InvokeWithExceptionNode> TYPE = NodeClass.create(InvokeWithExceptionNode.class);
    @Node.OptionalInput
    ValueNode classInit;
    @Node.Input(value=InputType.Extension)
    CallTargetNode callTarget;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateDuring;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateAfter;
    protected int bci;
    protected boolean polymorphic;
    protected boolean useForInlining;

    public InvokeWithExceptionNode(CallTargetNode callTarget, AbstractBeginNode exceptionEdge, int bci) {
        super((NodeClass<? extends WithExceptionNode>)TYPE, callTarget.returnStamp().getTrustedStamp());
        this.exceptionEdge = exceptionEdge;
        this.bci = bci;
        this.callTarget = callTarget;
        this.polymorphic = false;
        this.useForInlining = true;
    }

    @Override
    protected void afterClone(Node other) {
        this.updateInliningLogAfterClone(other);
    }

    @Override
    public FixedNode asFixedNode() {
        return this;
    }

    @Override
    public CallTargetNode callTarget() {
        return this.callTarget;
    }

    void setCallTarget(CallTargetNode callTarget) {
        this.updateUsages(this.callTarget, callTarget);
        this.callTarget = callTarget;
    }

    public MethodCallTargetNode methodCallTarget() {
        return (MethodCallTargetNode)this.callTarget;
    }

    @Override
    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    @Override
    public void setPolymorphic(boolean value) {
        this.polymorphic = value;
    }

    @Override
    public boolean useForInlining() {
        return this.useForInlining;
    }

    @Override
    public void setUseForInlining(boolean value) {
        this.useForInlining = value;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Long) {
            return super.toString(Verbosity.Short) + "(bci=" + this.bci() + ")";
        }
        if (verbosity == Verbosity.Name) {
            return "Invoke#" + (this.callTarget == null ? "null" : this.callTarget().targetName());
        }
        return super.toString(verbosity);
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public void setNext(FixedNode x) {
        if (x != null) {
            this.setNext(KillingBeginNode.begin(x, this.getKilledLocationIdentity()));
        } else {
            this.setNext(null);
        }
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.emitInvoke(this);
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState stateAfter) {
        this.updateUsages(this.stateAfter, stateAfter);
        this.stateAfter = stateAfter;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> debugProperties = super.getDebugProperties(map);
        if (this.callTarget != null) {
            debugProperties.put("targetMethod", this.callTarget.targetName());
        }
        return debugProperties;
    }

    public AbstractBeginNode killKillingBegin() {
        FixedNode begin = this.next();
        if (begin instanceof KillingBeginNode) {
            try (DebugCloseable position = begin.withNodeSourcePosition();){
                BeginNode newBegin = new BeginNode();
                this.graph().addAfterFixed((FixedWithNextNode)begin, this.graph().add(newBegin));
                begin.replaceAtUsages(newBegin);
                this.graph().removeFixed((FixedWithNextNode)begin);
                BeginNode beginNode = newBegin;
                return beginNode;
            }
        }
        return begin;
    }

    @Override
    public void setBci(int newBci) {
        assert (BytecodeFrame.isPlaceholderBci((int)this.bci) && !BytecodeFrame.isPlaceholderBci((int)newBci)) : "can only replace placeholder with better bci";
        this.bci = newBci;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public FrameState stateDuring() {
        return this.stateDuring;
    }

    @Override
    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages(this.stateDuring, stateDuring);
        this.stateDuring = stateDuring;
    }

    @Override
    public Stamp uncheckedStamp() {
        return this.callTarget.returnStamp().getUncheckedStamp();
    }

    @Override
    public void setClassInit(ValueNode classInit) {
        this.classInit = classInit;
        this.updateUsages(null, classInit);
    }

    @Override
    public ValueNode classInit() {
        return this.classInit;
    }

    public InvokeNode replaceWithInvoke() {
        InvokeNode newInvoke = this.graph().add(new InvokeNode(this.callTarget, this.bci, this.stamp, this.getKilledLocationIdentity()));
        newInvoke.setStateAfter(this.stateAfter);
        newInvoke.setStateDuring(this.stateDuring);
        AbstractBeginNode oldException = this.exceptionEdge;
        this.graph().replaceSplitWithFixed(this, newInvoke, (AbstractBeginNode)this.next());
        GraphUtil.killCFG(oldException);
        return newInvoke;
    }

    @Override
    public InvokeNode replaceWithNonThrowing() {
        return this.replaceWithInvoke();
    }
}

