/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedNodeInterface;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.type.StampTool;

public interface Invoke
extends StateSplit,
Lowerable,
SingleMemoryKill,
DeoptimizingNode.DeoptDuring,
FixedNodeInterface,
Invokable {
    public FixedNode next();

    public void setNext(FixedNode var1);

    public CallTargetNode callTarget();

    public Node predecessor();

    public ValueNode classInit();

    public void setClassInit(ValueNode var1);

    public boolean useForInlining();

    public void setUseForInlining(boolean var1);

    public boolean isPolymorphic();

    public void setPolymorphic(boolean var1);

    @Override
    default public ResolvedJavaMethod getTargetMethod() {
        return this.callTarget() != null ? this.callTarget().targetMethod() : null;
    }

    @Override
    default public ResolvedJavaMethod getContextMethod() {
        FrameState state = this.stateAfter();
        if (state == null) {
            state = this.stateDuring();
        }
        return state.getMethod();
    }

    default public ResolvedJavaType getContextType() {
        ResolvedJavaMethod contextMethod = this.getContextMethod();
        if (contextMethod == null) {
            return null;
        }
        return contextMethod.getDeclaringClass();
    }

    @Override
    default public void computeStateDuring(FrameState stateAfter) {
        FrameState newStateDuring = stateAfter.duplicateModifiedDuringCall(this.bci(), this.asNode().getStackKind());
        this.setStateDuring(newStateDuring);
    }

    default public ValueNode getReceiver() {
        if (!1.$assertionsDisabled && !this.getInvokeKind().hasReceiver()) {
            throw new AssertionError();
        }
        return (ValueNode)this.callTarget().arguments().get(0);
    }

    default public ResolvedJavaType getReceiverType() {
        ResolvedJavaType receiverType = StampTool.typeOrNull(this.getReceiver());
        if (receiverType == null) {
            receiverType = ((MethodCallTargetNode)this.callTarget()).targetMethod().getDeclaringClass();
        }
        return receiverType;
    }

    default public CallTargetNode.InvokeKind getInvokeKind() {
        return this.callTarget().invokeKind();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

