/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(allowedUsageTypes={InputType.Guard, InputType.Anchor})
public abstract class AbstractBeginNode
extends FixedWithNextNode
implements LIRLowerable,
GuardingNode,
AnchoringNode,
IterableNodeType {
    public static final NodeClass<AbstractBeginNode> TYPE = NodeClass.create(AbstractBeginNode.class);
    private boolean withSpeculationFence;

    protected AbstractBeginNode(NodeClass<? extends AbstractBeginNode> c) {
        this(c, StampFactory.forVoid());
    }

    protected AbstractBeginNode(NodeClass<? extends AbstractBeginNode> c, Stamp stamp) {
        super((NodeClass<? extends FixedWithNextNode>)c, stamp);
    }

    public static AbstractBeginNode prevBegin(FixedNode from) {
        for (Node next = from; next != null; next = next.predecessor()) {
            if (!(next instanceof AbstractBeginNode)) continue;
            return (AbstractBeginNode)next;
        }
        return null;
    }

    private void evacuateAnchored(FixedNode evacuateFrom) {
        if (!this.hasNoUsages()) {
            AbstractBeginNode prevBegin = AbstractBeginNode.prevBegin(evacuateFrom);
            assert (prevBegin != null);
            this.replaceAtUsages((Node)prevBegin, InputType.Anchor);
            this.replaceAtUsages((Node)prevBegin, InputType.Guard);
            assert (this.anchored().isEmpty()) : this.anchored().snapshot();
        }
    }

    public void prepareDelete() {
        this.prepareDelete((FixedNode)this.predecessor());
    }

    public void prepareDelete(FixedNode evacuateFrom) {
        this.evacuateAnchored(evacuateFrom);
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.predecessor() != null || this == this.graph().start() || this instanceof AbstractMergeNode, "begin nodes must be connected", new Object[0]);
        return super.verify();
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        if (this.withSpeculationFence) {
            gen.getLIRGeneratorTool().emitSpeculationFence();
        }
    }

    public boolean isUsedAsGuardInput() {
        if (this.hasUsages()) {
            for (Node n : this.usages()) {
                for (Position inputPosition : n.inputPositions()) {
                    if (inputPosition.getInputType() != InputType.Guard || inputPosition.get(n) != this) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public NodeIterable<GuardNode> guards() {
        return this.usages().filter(GuardNode.class);
    }

    public NodeIterable<Node> anchored() {
        return this.usages();
    }

    public boolean hasAnchored() {
        return this.hasUsages();
    }

    public NodeIterable<FixedNode> getBlockNodes() {
        return new NodeIterable<FixedNode>(){

            @Override
            public Iterator<FixedNode> iterator() {
                return new BlockNodeIterator(AbstractBeginNode.this);
            }
        };
    }

    public void setWithSpeculationFence() {
        this.withSpeculationFence = true;
    }

    private static class BlockNodeIterator
    implements Iterator<FixedNode> {
        private FixedNode current;

        BlockNodeIterator(FixedNode next) {
            this.current = next;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public FixedNode next() {
            FixedNode ret = this.current;
            if (ret == null) {
                throw new NoSuchElementException();
            }
            if (this.current instanceof FixedWithNextNode) {
                this.current = ((FixedWithNextNode)this.current).next();
                if (this.current instanceof AbstractBeginNode) {
                    this.current = null;
                }
            } else {
                this.current = null;
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

