/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.loop.LoopEx;
import org.graalvm.compiler.loop.LoopsData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.Phase;

public class ReassociateInvariantPhase
extends Phase {
    @Override
    protected void run(StructuredGraph graph) {
        int iterations = 0;
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope("ReassociateInvariants");){
            boolean changed = true;
            while (changed) {
                changed = false;
                LoopsData dataReassociate = new LoopsData(graph);
                for (LoopEx loop : dataReassociate.loops()) {
                    changed |= loop.reassociateInvariants();
                }
                dataReassociate.deleteUnusedNodes();
                debug.dump(3, (Object)graph, "after iteration %d", ++iterations);
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }
}

