/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import org.graalvm.compiler.loop.LoopEx;
import org.graalvm.compiler.loop.LoopsData;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;

public class LoopSafepointEliminationPhase
extends BasePhase<MidTierContext> {
    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        LoopsData loops = new LoopsData(graph);
        loops.detectedCountedLoops();
        for (LoopEx loop : loops.countedLoops()) {
            if (!loop.loop().getChildren().isEmpty() || loop.counted().getStamp().getBits() > 32 && !loop.loopBegin().isPreLoop() && !loop.loopBegin().isPostLoop()) continue;
            boolean hasSafepoint = false;
            for (LoopEndNode loopEnd : loop.loopBegin().loopEnds()) {
                hasSafepoint |= loopEnd.canSafepoint();
            }
            if (!hasSafepoint) continue;
            if (!loop.counted().counterNeverOverflows()) {
                if (!context.getOptimisticOptimizations().useLoopLimitChecks(graph.getOptions()) || !graph.getGuardsStage().allowsFloatingGuards()) continue;
                loop.counted().createOverFlowGuard();
            }
            loop.loopBegin().disableSafepoint();
        }
        for (LoopEx loop : loops.loops()) {
            block3: for (LoopEndNode loopEnd : loop.loopBegin().loopEnds()) {
                for (Block b = loops.getCFG().blockFor(loopEnd); b != loop.loop().getHeader(); b = (Block)b.getDominator()) {
                    assert (b != null);
                    for (FixedNode node : b.getNodes()) {
                        if (!(node instanceof Invoke) && (!(node instanceof ForeignCallNode) || !((ForeignCallNode)node).isGuaranteedSafepoint())) continue;
                        loopEnd.disableSafepoint();
                        continue block3;
                    }
                }
            }
        }
        loops.deleteUnusedNodes();
    }
}

