/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.loop.LoopEx;
import org.graalvm.compiler.loop.LoopPolicies;
import org.graalvm.compiler.loop.LoopsData;
import org.graalvm.compiler.loop.phases.LoopPhase;
import org.graalvm.compiler.loop.phases.LoopTransformations;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.OpaqueNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;

public class LoopPartialUnrollPhase
extends LoopPhase<LoopPolicies> {
    private final CanonicalizerPhase canonicalizer;

    public LoopPartialUnrollPhase(LoopPolicies policies, CanonicalizerPhase canonicalizer) {
        super(policies);
        this.canonicalizer = canonicalizer;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (graph.hasLoops()) {
            Throwable throwable;
            Graph.NodeEventScope nes;
            EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
            boolean changed = true;
            EconomicMap opaqueUnrolledStrides = null;
            while (changed) {
                changed = false;
                nes = graph.trackNodeEvents(listener);
                throwable = null;
                try {
                    LoopsData dataCounted = new LoopsData(graph);
                    dataCounted.detectedCountedLoops();
                    Graph.Mark mark = graph.getMark();
                    boolean prePostInserted = false;
                    for (LoopEx loop : dataCounted.countedLoops()) {
                        if (!LoopTransformations.isUnrollableLoop(loop) || !this.getPolicies().shouldPartiallyUnroll(loop, context)) continue;
                        if (loop.loopBegin().isSimpleLoop()) {
                            LoopTransformations.insertPrePostLoops(loop);
                            prePostInserted = true;
                        } else {
                            if (opaqueUnrolledStrides == null) {
                                opaqueUnrolledStrides = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
                            }
                            LoopTransformations.partialUnroll(loop, (EconomicMap<LoopBeginNode, OpaqueNode>)opaqueUnrolledStrides);
                        }
                        changed = true;
                    }
                    dataCounted.deleteUnusedNodes();
                    if (!listener.getNodes().isEmpty()) {
                        this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)listener.getNodes());
                        listener.getNodes().clear();
                    }
                    assert (!prePostInserted || LoopPartialUnrollPhase.checkCounted(graph, mark));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (nes == null) continue;
                    if (throwable != null) {
                        try {
                            nes.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    nes.close();
                }
            }
            if (opaqueUnrolledStrides != null) {
                nes = graph.trackNodeEvents(listener);
                throwable = null;
                try {
                    for (OpaqueNode opaque : opaqueUnrolledStrides.getValues()) {
                        opaque.remove();
                    }
                    if (!listener.getNodes().isEmpty()) {
                        this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)listener.getNodes());
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (nes != null) {
                        if (throwable != null) {
                            try {
                                nes.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            nes.close();
                        }
                    }
                }
            }
        }
    }

    private static boolean checkCounted(StructuredGraph graph, Graph.Mark mark) {
        LoopsData dataCounted = new LoopsData(graph);
        dataCounted.detectedCountedLoops();
        for (LoopEx anyLoop : dataCounted.loops()) {
            if (graph.isNew(mark, anyLoop.loopBegin())) assert (anyLoop.isCounted()) : "pre/post transformation loses counted loop " + anyLoop.loopBegin();
        }
        return true;
    }

    @Override
    public boolean checkContract() {
        return false;
    }
}

