/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.loop.CountedLoopInfo;
import org.graalvm.compiler.loop.InductionVariable;
import org.graalvm.compiler.loop.LoopEx;
import org.graalvm.compiler.loop.LoopFragment;
import org.graalvm.compiler.loop.LoopFragmentWhole;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GuardPhiNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.extended.OpaqueNode;
import org.graalvm.compiler.nodes.memory.MemoryPhiNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.util.IntegerHelper;

public class LoopFragmentInside
extends LoopFragment {
    private EconomicMap<PhiNode, ValueNode> mergedInitializers;
    private final Graph.DuplicationReplacement dataFixBefore = new Graph.DuplicationReplacement(){

        @Override
        public Node replacement(Node oriInput) {
            if (!(oriInput instanceof ValueNode)) {
                return oriInput;
            }
            return LoopFragmentInside.this.prim((ValueNode)oriInput);
        }
    };
    private final Graph.DuplicationReplacement dataFixWithinAfter = new Graph.DuplicationReplacement(){

        @Override
        public Node replacement(Node oriInput) {
            if (!(oriInput instanceof ValueNode)) {
                return oriInput;
            }
            return LoopFragmentInside.this.primAfter((ValueNode)oriInput);
        }
    };

    public LoopFragmentInside(LoopEx loop) {
        super(loop);
    }

    public LoopFragmentInside(LoopFragmentInside original) {
        super(null, original);
    }

    @Override
    public LoopFragmentInside duplicate() {
        assert (!this.isDuplicate());
        return new LoopFragmentInside(this);
    }

    @Override
    public LoopFragmentInside original() {
        return (LoopFragmentInside)super.original();
    }

    public void appendInside(LoopEx loop) {
    }

    @Override
    public LoopEx loop() {
        assert (!this.isDuplicate());
        return super.loop();
    }

    @Override
    public void insertBefore(LoopEx loop) {
        assert (this.isDuplicate() && this.original().loop() == loop);
        this.patchNodes(this.dataFixBefore);
        AbstractBeginNode end = this.mergeEnds();
        this.mergeEarlyExits();
        this.original().patchPeeling(this);
        AbstractBeginNode entry = (AbstractBeginNode)this.getDuplicatedNode(loop.loopBegin());
        loop.entryPoint().replaceAtPredecessor(entry);
        end.setNext(loop.entryPoint());
    }

    public void insertWithinAfter(LoopEx loop, EconomicMap<LoopBeginNode, OpaqueNode> opaqueUnrolledStrides) {
        ValueNode duplicatedNode;
        assert (this.isDuplicate() && this.original().loop() == loop);
        this.patchNodes(this.dataFixWithinAfter);
        LoopBeginNode mainLoopBegin = loop.loopBegin();
        ArrayList<ValueNode> backedgeValues = new ArrayList<ValueNode>();
        for (PhiNode phiNode : mainLoopBegin.phis()) {
            ValueNode originalNode = phiNode.valueAt(1);
            duplicatedNode = (ValueNode)this.getDuplicatedNode(originalNode);
            if (duplicatedNode == null) {
                if (mainLoopBegin.isPhiAtMerge(originalNode)) {
                    duplicatedNode = ((PhiNode)originalNode).valueAt(1);
                } else assert (originalNode.isConstant() || loop.isOutsideLoop(originalNode)) : "Not duplicated node " + originalNode;
            }
            backedgeValues.add(duplicatedNode);
        }
        int index = 0;
        for (PhiNode mainPhiNode : mainLoopBegin.phis()) {
            if ((duplicatedNode = (ValueNode)backedgeValues.get(index++)) == null) continue;
            mainPhiNode.setValueAt(1, duplicatedNode);
        }
        this.placeNewSegmentAndCleanup(loop);
        assert (loop.whole().nodes().filter(SafepointNode.class).count() == this.nodes().filter(SafepointNode.class).count());
        for (SafepointNode safepoint : loop.whole().nodes().filter(SafepointNode.class)) {
            this.graph().removeFixed(safepoint);
        }
        StructuredGraph structuredGraph = mainLoopBegin.graph();
        if (opaqueUnrolledStrides != null) {
            OpaqueNode opaque = (OpaqueNode)opaqueUnrolledStrides.get((Object)loop.loopBegin());
            CountedLoopInfo counted = loop.counted();
            ValueNode counterStride = counted.getCounter().strideNode();
            if (opaque == null) {
                LogicNode overflowCheck;
                ConstantNode extremum;
                opaque = new OpaqueNode(AddNode.add(counterStride, counterStride, NodeView.DEFAULT));
                ValueNode limit = counted.getLimit();
                int bits = ((IntegerStamp)limit.stamp(NodeView.DEFAULT)).getBits();
                ValueNode newLimit = SubNode.create(limit, opaque, NodeView.DEFAULT);
                IntegerHelper helper = counted.getCounterIntegerHelper();
                if (counted.getDirection() == InductionVariable.Direction.Up) {
                    extremum = ConstantNode.forIntegerBits(bits, helper.minValue());
                    overflowCheck = IntegerBelowNode.create(SubNode.create(limit, extremum, NodeView.DEFAULT), opaque, NodeView.DEFAULT);
                } else {
                    assert (counted.getDirection() == InductionVariable.Direction.Down);
                    extremum = ConstantNode.forIntegerBits(bits, helper.maxValue());
                    overflowCheck = IntegerBelowNode.create(opaque, SubNode.create(limit, extremum, NodeView.DEFAULT), NodeView.DEFAULT);
                }
                newLimit = ConditionalNode.create(overflowCheck, extremum, newLimit, NodeView.DEFAULT);
                CompareNode compareNode = (CompareNode)counted.getLimitTest().condition();
                compareNode.replaceFirstInput(limit, structuredGraph.addOrUniqueWithInputs(newLimit));
                opaqueUnrolledStrides.put((Object)loop.loopBegin(), (Object)opaque);
            } else {
                assert (counted.getCounter().isConstantStride());
                assert (Math.addExact(counted.getCounter().constantStride(), counted.getCounter().constantStride()) == counted.getCounter().constantStride() * 2L);
                ValueNode previousValue = opaque.getValue();
                opaque.setValue(structuredGraph.addOrUniqueWithInputs(AddNode.add(counterStride, previousValue, NodeView.DEFAULT)));
                GraphUtil.tryKillUnused(previousValue);
            }
        }
        mainLoopBegin.setUnrollFactor(mainLoopBegin.getUnrollFactor() * 2);
        mainLoopBegin.setLoopFrequency(Math.max(1.0, mainLoopBegin.loopFrequency() / 2.0));
        structuredGraph.getDebug().dump(4, (Object)structuredGraph, "LoopPartialUnroll %s", loop);
        mainLoopBegin.getDebug().dump(3, (Object)mainLoopBegin.graph(), "After insertWithinAfter %s", mainLoopBegin);
    }

    private void placeNewSegmentAndCleanup(LoopEx loop) {
        CountedLoopInfo mainCounted = loop.counted();
        LoopBeginNode mainLoopBegin = loop.loopBegin();
        StructuredGraph graph = mainLoopBegin.graph();
        IfNode loopTest = mainCounted.getLimitTest();
        IfNode newSegmentLoopTest = (IfNode)this.getDuplicatedNode(loopTest);
        AbstractBeginNode falseSuccessor = newSegmentLoopTest.falseSuccessor();
        for (Node node : falseSuccessor.anchored().snapshot()) {
            node.replaceFirstInput(falseSuccessor, loopTest.falseSuccessor());
        }
        AbstractBeginNode trueSuccessor = newSegmentLoopTest.trueSuccessor();
        for (Node usage : trueSuccessor.anchored().snapshot()) {
            usage.replaceFirstInput(trueSuccessor, loopTest.trueSuccessor());
        }
        graph.removeSplitPropagate(newSegmentLoopTest, loopTest.trueSuccessor() == mainCounted.getBody() ? trueSuccessor : falseSuccessor);
        graph.getDebug().dump(4, graph, "Before placing segment");
        if (mainCounted.getBody().next() instanceof LoopEndNode) {
            GraphUtil.killCFG((FixedNode)this.getDuplicatedNode(mainLoopBegin));
        } else {
            AbstractBeginNode abstractBeginNode = (AbstractBeginNode)this.getDuplicatedNode(mainLoopBegin);
            FixedNode newSegmentFirstNode = abstractBeginNode.next();
            EndNode newSegmentEnd = LoopFragmentInside.getBlockEnd((FixedNode)this.getDuplicatedNode(mainLoopBegin.loopEnds().first().predecessor()));
            FixedWithNextNode newSegmentLastNode = (FixedWithNextNode)newSegmentEnd.predecessor();
            LoopEndNode loopEndNode = mainLoopBegin.getSingleLoopEnd();
            FixedWithNextNode lastCodeNode = (FixedWithNextNode)loopEndNode.predecessor();
            abstractBeginNode.clearSuccessors();
            lastCodeNode.replaceFirstSuccessor(loopEndNode, newSegmentFirstNode);
            newSegmentLastNode.replaceFirstSuccessor(newSegmentEnd, loopEndNode);
            abstractBeginNode.safeDelete();
            newSegmentEnd.safeDelete();
        }
        graph.getDebug().dump(4, graph, "After placing segment");
    }

    private static EndNode getBlockEnd(FixedNode node) {
        FixedNode curNode = node;
        while (curNode instanceof FixedWithNextNode) {
            curNode = ((FixedWithNextNode)curNode).next();
        }
        return (EndNode)curNode;
    }

    @Override
    public NodeBitMap nodes() {
        if (this.nodes == null) {
            LoopFragmentWhole whole = this.loop().whole();
            whole.nodes();
            this.nodes = whole.nodes.copy();
            LoopBeginNode loopBegin = this.loop().loopBegin();
            for (PhiNode phi : loopBegin.phis()) {
                this.nodes.clear(phi);
            }
            this.clearStateNodes(loopBegin);
            for (LoopExitNode exit : this.exits()) {
                this.clearStateNodes(exit);
                for (ProxyNode proxy : exit.proxies()) {
                    this.nodes.clear(proxy);
                }
            }
        }
        return this.nodes;
    }

    private void clearStateNodes(StateSplit stateSplit) {
        FrameState loopState = stateSplit.stateAfter();
        if (loopState != null) {
            loopState.applyToVirtual(v -> {
                if (v.usages().filter(n -> !this.nodes.isNew(n) && this.nodes.isMarked(n) && n != stateSplit).isEmpty()) {
                    this.nodes.clear(v);
                }
            });
        }
    }

    public NodeIterable<LoopExitNode> exits() {
        return this.loop().loopBegin().loopExits();
    }

    @Override
    protected Graph.DuplicationReplacement getDuplicationReplacement() {
        final LoopBeginNode loopBegin = this.loop().loopBegin();
        final StructuredGraph graph = this.graph();
        return new Graph.DuplicationReplacement(){
            private EconomicMap<Node, Node> seenNode = EconomicMap.create((Equivalence)Equivalence.IDENTITY);

            @Override
            public Node replacement(Node original) {
                try (DebugCloseable position = original.withNodeSourcePosition();){
                    Node value;
                    if (original == loopBegin) {
                        value = (Node)this.seenNode.get((Object)original);
                        if (value != null) {
                            Node node = value;
                            return node;
                        }
                        AbstractBeginNode newValue = graph.add(new BeginNode());
                        this.seenNode.put((Object)original, (Object)newValue);
                        AbstractBeginNode abstractBeginNode = newValue;
                        return abstractBeginNode;
                    }
                    if (original instanceof LoopExitNode && ((LoopExitNode)original).loopBegin() == loopBegin) {
                        value = (Node)this.seenNode.get((Object)original);
                        if (value != null) {
                            Node newValue = value;
                            return newValue;
                        }
                        AbstractBeginNode newValue = graph.add(new BeginNode());
                        this.seenNode.put((Object)original, (Object)newValue);
                        AbstractBeginNode abstractBeginNode = newValue;
                        return abstractBeginNode;
                    }
                    if (original instanceof LoopEndNode && ((LoopEndNode)original).loopBegin() == loopBegin) {
                        value = (Node)this.seenNode.get((Object)original);
                        if (value != null) {
                            Node newValue = value;
                            return newValue;
                        }
                        EndNode newValue = graph.add(new EndNode());
                        this.seenNode.put((Object)original, (Object)newValue);
                        EndNode endNode = newValue;
                        return endNode;
                    }
                    Node node = original;
                    return node;
                }
            }
        };
    }

    @Override
    protected void beforeDuplication() {
    }

    private static PhiNode patchPhi(StructuredGraph graph, PhiNode phi, AbstractMergeNode merge) {
        PhiNode ret;
        if (phi instanceof ValuePhiNode) {
            ret = new ValuePhiNode(phi.stamp(NodeView.DEFAULT), merge);
        } else if (phi instanceof GuardPhiNode) {
            ret = new GuardPhiNode(merge);
        } else if (phi instanceof MemoryPhiNode) {
            ret = new MemoryPhiNode(merge, ((MemoryPhiNode)phi).getLocationIdentity());
        } else {
            throw GraalError.shouldNotReachHere();
        }
        return graph.addWithoutUnique(ret);
    }

    private void patchPeeling(LoopFragmentInside peel) {
        boolean bl;
        LoopBeginNode loopBegin = this.loop().loopBegin();
        StructuredGraph graph = loopBegin.graph();
        LinkedList<PhiNode> newPhis = new LinkedList<PhiNode>();
        NodeBitMap usagesToPatch = this.nodes.copy();
        for (LoopExitNode loopExitNode : this.exits()) {
            LoopFragmentInside.markStateNodes(loopExitNode, usagesToPatch);
            for (ProxyNode proxy : loopExitNode.proxies()) {
                usagesToPatch.markAndGrow(proxy);
            }
        }
        LoopFragmentInside.markStateNodes(loopBegin, usagesToPatch);
        List<PhiNode> oldPhis = loopBegin.phis().snapshot();
        for (PhiNode phi : oldPhis) {
            ValueNode first;
            if (phi.hasNoUsages()) continue;
            if (loopBegin.loopEnds().count() == 1) {
                ValueNode b = phi.valueAt(loopBegin.loopEnds().first());
                first = peel.prim(b);
            } else {
                first = (ValueNode)peel.mergedInitializers.get((Object)phi);
            }
            PhiNode newPhi = LoopFragmentInside.patchPhi(graph, phi, loopBegin);
            newPhi.addInput(first);
            for (LoopEndNode end : loopBegin.orderedLoopEnds()) {
                newPhi.addInput(phi.valueAt(end));
            }
            peel.putDuplicatedNode(phi, newPhi);
            newPhis.add(newPhi);
            for (Node usage : phi.usages().snapshot()) {
                if (!usagesToPatch.isMarkedAndGrow(usage)) continue;
                usage.replaceFirstInput(phi, newPhi);
            }
        }
        for (PhiNode phi : newPhis) {
            for (int i = 0; i < phi.valueCount(); ++i) {
                PhiNode newV;
                ValueNode v = phi.valueAt(i);
                if (!loopBegin.isPhiAtMerge(v) || (newV = (PhiNode)peel.getDuplicatedNode((PhiNode)v)) == null) continue;
                phi.setValueAt(i, (ValueNode)newV);
            }
        }
        boolean bl2 = true;
        while (bl) {
            bl = false;
            int i = 0;
            block8: while (i < oldPhis.size()) {
                PhiNode oldPhi = oldPhis.get(i);
                for (Node usage : oldPhi.usages()) {
                    if (usage instanceof PhiNode && oldPhis.contains(usage)) continue;
                    oldPhis.remove(i);
                    bl = true;
                    continue block8;
                }
                ++i;
            }
        }
        for (PhiNode deadPhi : oldPhis) {
            deadPhi.clearInputs();
        }
        for (PhiNode deadPhi : oldPhis) {
            if (!deadPhi.isAlive()) continue;
            GraphUtil.killWithUnusedFloatingInputs(deadPhi);
        }
    }

    private static void markStateNodes(StateSplit stateSplit, NodeBitMap marks) {
        FrameState exitState = stateSplit.stateAfter();
        if (exitState != null) {
            exitState.applyToVirtual(v -> marks.markAndGrow(v));
        }
    }

    @Override
    protected ValueNode prim(ValueNode b) {
        assert (this.isDuplicate());
        LoopBeginNode loopBegin = this.original().loop().loopBegin();
        if (loopBegin.isPhiAtMerge(b)) {
            PhiNode phi = (PhiNode)b;
            return phi.valueAt(loopBegin.forwardEnd());
        }
        if (this.nodesReady) {
            ValueNode v = (ValueNode)this.getDuplicatedNode(b);
            if (v == null) {
                return b;
            }
            return v;
        }
        return b;
    }

    protected ValueNode primAfter(ValueNode b) {
        assert (this.isDuplicate());
        LoopBeginNode loopBegin = this.original().loop().loopBegin();
        if (loopBegin.isPhiAtMerge(b)) {
            PhiNode phi = (PhiNode)b;
            assert (phi.valueCount() == 2);
            return phi.valueAt(1);
        }
        if (this.nodesReady) {
            ValueNode v = (ValueNode)this.getDuplicatedNode(b);
            if (v == null) {
                return b;
            }
            return v;
        }
        return b;
    }

    private AbstractBeginNode mergeEnds() {
        AbstractBeginNode newExit;
        assert (this.isDuplicate());
        LinkedList<EndNode> endsToMerge = new LinkedList<EndNode>();
        EconomicMap reverseEnds = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        LoopBeginNode loopBegin = this.original().loop().loopBegin();
        for (LoopEndNode le : loopBegin.loopEnds()) {
            AbstractEndNode duplicate = (AbstractEndNode)this.getDuplicatedNode(le);
            if (duplicate == null) continue;
            endsToMerge.add((EndNode)duplicate);
            reverseEnds.put((Object)duplicate, (Object)le);
        }
        this.mergedInitializers = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        StructuredGraph graph = this.graph();
        if (endsToMerge.size() == 1) {
            AbstractEndNode end = (AbstractEndNode)endsToMerge.get(0);
            assert (end.hasNoUsages());
            try (DebugCloseable position = end.withNodeSourcePosition();){
                newExit = graph.add(new BeginNode());
                end.replaceAtPredecessor(newExit);
                end.safeDelete();
            }
        } else {
            AbstractMergeNode newExitMerge;
            assert (endsToMerge.size() > 1);
            newExit = newExitMerge = (AbstractMergeNode)graph.add(new MergeNode());
            FrameState state = loopBegin.stateAfter();
            FrameState duplicateState = null;
            if (state != null) {
                duplicateState = state.duplicateWithVirtualState();
                newExitMerge.setStateAfter(duplicateState);
            }
            for (EndNode end : endsToMerge) {
                newExitMerge.addForwardEnd(end);
            }
            for (final PhiNode phi : loopBegin.phis().snapshot()) {
                if (phi.hasNoUsages()) continue;
                final PhiNode firstPhi = LoopFragmentInside.patchPhi(graph, phi, newExitMerge);
                for (AbstractEndNode abstractEndNode : newExitMerge.forwardEnds()) {
                    LoopEndNode loopEnd = (LoopEndNode)reverseEnds.get((Object)abstractEndNode);
                    ValueNode prim = this.prim(phi.valueAt(loopEnd));
                    assert (prim != null);
                    firstPhi.addInput(prim);
                }
                PhiNode initializer = firstPhi;
                if (duplicateState != null) {
                    duplicateState.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(){

                        @Override
                        public void apply(Node from, Position p) {
                            if (p.get(from) == phi) {
                                p.set(from, firstPhi);
                            }
                        }
                    });
                }
                this.mergedInitializers.put((Object)phi, (Object)initializer);
            }
        }
        return newExit;
    }
}

