/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.loop.DerivedInductionVariable;
import org.graalvm.compiler.loop.InductionVariable;
import org.graalvm.compiler.loop.LoopEx;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;

public class DerivedConvertedInductionVariable
extends DerivedInductionVariable {
    private final Stamp stamp;
    private final ValueNode value;

    public DerivedConvertedInductionVariable(LoopEx loop, InductionVariable base, Stamp stamp, ValueNode value) {
        super(loop, base);
        this.stamp = stamp;
        this.value = value;
    }

    @Override
    public ValueNode valueNode() {
        return this.value;
    }

    @Override
    public InductionVariable.Direction direction() {
        return this.base.direction();
    }

    @Override
    public ValueNode initNode() {
        return IntegerConvertNode.convert(this.base.initNode(), this.stamp, this.graph(), NodeView.DEFAULT);
    }

    @Override
    public ValueNode strideNode() {
        return IntegerConvertNode.convert(this.base.strideNode(), this.stamp, this.graph(), NodeView.DEFAULT);
    }

    @Override
    public boolean isConstantInit() {
        return this.base.isConstantInit();
    }

    @Override
    public boolean isConstantStride() {
        return this.base.isConstantStride();
    }

    @Override
    public long constantInit() {
        return this.base.constantInit();
    }

    @Override
    public long constantStride() {
        return this.base.constantStride();
    }

    @Override
    public ValueNode extremumNode(boolean assumeLoopEntered, Stamp s) {
        return this.base.extremumNode(assumeLoopEntered, s);
    }

    @Override
    public ValueNode exitValueNode() {
        return IntegerConvertNode.convert(this.base.exitValueNode(), this.stamp, this.graph(), NodeView.DEFAULT);
    }

    @Override
    public boolean isConstantExtremum() {
        return this.base.isConstantExtremum();
    }

    @Override
    public long constantExtremum() {
        return this.base.constantExtremum();
    }

    @Override
    public void deleteUnusedNodes() {
    }

    public String toString() {
        return String.format("DerivedConvertedInductionVariable base (%s) %s %s", this.base, this.value.getNodeClass().shortName(), this.stamp);
    }
}

