/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop;

import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.util.UnsignedLong;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.loop.InductionVariable;
import org.graalvm.compiler.loop.LoopEx;
import org.graalvm.compiler.loop.MathUtil;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.calc.SubNode;

public class BasicInductionVariable
extends InductionVariable {
    private final ValuePhiNode phi;
    private final ValueNode init;
    private ValueNode rawStride;
    private BinaryArithmeticNode<?> op;

    public BasicInductionVariable(LoopEx loop, ValuePhiNode phi, ValueNode init, ValueNode rawStride, BinaryArithmeticNode<?> op) {
        super(loop);
        this.phi = phi;
        this.init = init;
        this.rawStride = rawStride;
        this.op = op;
    }

    @Override
    public StructuredGraph graph() {
        return this.phi.graph();
    }

    public BinaryArithmeticNode<?> getOp() {
        return this.op;
    }

    public void setOP(BinaryArithmeticNode<?> newOp) {
        this.rawStride = newOp.getY();
        this.op = newOp;
    }

    @Override
    public InductionVariable.Direction direction() {
        Stamp stamp = this.rawStride.stamp(NodeView.DEFAULT);
        if (stamp instanceof IntegerStamp) {
            IntegerStamp integerStamp = (IntegerStamp)stamp;
            InductionVariable.Direction dir = null;
            if (integerStamp.isStrictlyPositive()) {
                dir = InductionVariable.Direction.Up;
            } else if (integerStamp.isStrictlyNegative()) {
                dir = InductionVariable.Direction.Down;
            }
            if (dir != null) {
                if (this.op instanceof AddNode) {
                    return dir;
                }
                assert (this.op instanceof SubNode);
                return dir.opposite();
            }
        }
        return null;
    }

    @Override
    public ValuePhiNode valueNode() {
        return this.phi;
    }

    @Override
    public ValueNode initNode() {
        return this.init;
    }

    @Override
    public ValueNode strideNode() {
        if (this.op instanceof AddNode) {
            return this.rawStride;
        }
        if (this.op instanceof SubNode) {
            return this.graph().unique(new NegateNode(this.rawStride));
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public boolean isConstantInit() {
        return this.init.isConstant();
    }

    @Override
    public boolean isConstantStride() {
        return this.rawStride.isConstant();
    }

    @Override
    public long constantInit() {
        return this.init.asJavaConstant().asLong();
    }

    @Override
    public long constantStride() {
        if (this.op instanceof AddNode) {
            return this.rawStride.asJavaConstant().asLong();
        }
        if (this.op instanceof SubNode) {
            return -this.rawStride.asJavaConstant().asLong();
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public ValueNode extremumNode(boolean assumeLoopEntered, Stamp stamp) {
        ValueNode maxTripCount;
        Stamp fromStamp = this.phi.stamp(NodeView.DEFAULT);
        StructuredGraph graph = this.graph();
        ValueNode stride = this.strideNode();
        ValueNode initNode = this.initNode();
        if (!fromStamp.isCompatible(stamp)) {
            stride = IntegerConvertNode.convert(stride, stamp, this.graph(), NodeView.DEFAULT);
            initNode = IntegerConvertNode.convert(initNode, stamp, this.graph(), NodeView.DEFAULT);
        }
        if (!(maxTripCount = this.loop.counted().maxTripCountNode(assumeLoopEntered)).stamp(NodeView.DEFAULT).isCompatible(stamp)) {
            maxTripCount = IntegerConvertNode.convert(maxTripCount, stamp, this.graph(), NodeView.DEFAULT);
        }
        return MathUtil.add(graph, MathUtil.mul(graph, stride, MathUtil.sub(graph, maxTripCount, ConstantNode.forIntegerStamp(stamp, 1L, graph))), initNode);
    }

    @Override
    public ValueNode exitValueNode() {
        Stamp stamp = this.phi.stamp(NodeView.DEFAULT);
        ValueNode maxTripCount = this.loop.counted().maxTripCountNode();
        if (!maxTripCount.stamp(NodeView.DEFAULT).isCompatible(stamp)) {
            maxTripCount = IntegerConvertNode.convert(maxTripCount, stamp, this.graph(), NodeView.DEFAULT);
        }
        return MathUtil.add(this.graph(), MathUtil.mul(this.graph(), this.strideNode(), maxTripCount), this.initNode());
    }

    @Override
    public boolean isConstantExtremum() {
        return this.isConstantInit() && this.isConstantStride() && this.loop.counted().isConstantMaxTripCount();
    }

    @Override
    public long constantExtremum() {
        UnsignedLong tripCount = this.loop.counted().constantMaxTripCount();
        if (tripCount.isLessThan(1L)) {
            return this.constantInit();
        }
        return tripCount.minus(1L).wrappingTimes(this.constantStride()).wrappingPlus(this.constantInit()).asLong();
    }

    @Override
    public void deleteUnusedNodes() {
    }

    public String toString() {
        return String.format("BasicInductionVariable %s %s %s %s", this.initNode(), this.phi, this.op.getNodeClass().shortName(), this.strideNode());
    }
}

