/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCDelayedControlTransfer;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;

public final class SPARCJumpOp
extends StandardOp.JumpOp
implements SPARCDelayedControlTransfer,
SPARCLIRInstructionMixin {
    public static final LIRInstructionClass<SPARCJumpOp> TYPE = LIRInstructionClass.create(SPARCJumpOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(2);
    private boolean emitDone = false;
    private int delaySlotPosition = -1;
    private final SPARCLIRInstructionMixin.SPARCLIRInstructionMixinStore store = new SPARCLIRInstructionMixin.SPARCLIRInstructionMixinStore(SIZE);

    public SPARCJumpOp(LabelRef destination) {
        super(TYPE, destination);
    }

    @Override
    public void emitControlTransfer(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        assert (!this.emitDone);
        if (!crb.isSuccessorEdge(this.destination())) {
            SPARCAssembler.BPCC.emit(masm, SPARCAssembler.CC.Xcc, SPARCAssembler.ConditionFlag.Always, SPARCAssembler.Annul.NOT_ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, this.destination().label());
            this.delaySlotPosition = masm.position();
        }
        this.emitDone = true;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb) {
        if (!crb.isSuccessorEdge(this.destination())) {
            if (!this.emitDone) {
                SPARCMacroAssembler masm = (SPARCMacroAssembler)crb.asm;
                masm.jmp(this.destination().label());
            } else {
                int disp = crb.asm.position() - this.delaySlotPosition;
                assert (disp == 4) : disp;
            }
        }
    }

    @Override
    public void resetState() {
        this.delaySlotPosition = -1;
        this.emitDone = false;
    }

    @Override
    public SPARCLIRInstructionMixin.SPARCLIRInstructionMixinStore getSPARCLIRInstructionStore() {
        return this.store;
    }
}

