/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;

public final class SPARCBitManipulationOp
extends SPARCLIRInstruction {
    public static final LIRInstructionClass<SPARCBitManipulationOp> TYPE = LIRInstructionClass.create(SPARCBitManipulationOp.class);
    @Opcode
    private final IntrinsicOpcode opcode;
    @LIRInstruction.Def
    protected AllocatableValue result;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue scratch;

    public SPARCBitManipulationOp(IntrinsicOpcode opcode, AllocatableValue result, AllocatableValue input, LIRGeneratorTool gen) {
        super(TYPE, opcode.size);
        this.opcode = opcode;
        this.result = result;
        this.input = input;
        this.scratch = gen.newVariable(LIRKind.combine(new Value[]{input}));
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD);
        if (ValueUtil.isRegister((Value)this.input)) {
            Register src = ValueUtil.asRegister((Value)this.input);
            switch (this.opcode) {
                case BSF: {
                    PlatformKind tkind = this.input.getPlatformKind();
                    if (tkind == SPARCKind.WORD) {
                        masm.sub(src, 1, dst);
                        masm.andn(dst, src, dst);
                        masm.srl(dst, SPARC.g0, dst);
                        masm.popc(dst, dst);
                        break;
                    }
                    if (tkind == SPARCKind.XWORD) {
                        masm.sub(src, 1, dst);
                        masm.andn(dst, src, dst);
                        masm.popc(dst, dst);
                        break;
                    }
                    throw GraalError.shouldNotReachHere("missing: " + tkind);
                }
                case IBSR: {
                    PlatformKind ikind = this.input.getPlatformKind();
                    assert (ikind == SPARCKind.WORD);
                    Register tmp = ValueUtil.asRegister((Value)this.scratch);
                    assert (!tmp.equals((Object)dst));
                    masm.srl(src, 1, tmp);
                    masm.srl(src, 0, dst);
                    masm.or(dst, tmp, dst);
                    masm.srl(dst, 2, tmp);
                    masm.or(dst, tmp, dst);
                    masm.srl(dst, 4, tmp);
                    masm.or(dst, tmp, dst);
                    masm.srl(dst, 8, tmp);
                    masm.or(dst, tmp, dst);
                    masm.srl(dst, 16, tmp);
                    masm.or(dst, tmp, dst);
                    masm.popc(dst, dst);
                    masm.sub(dst, 1, dst);
                    break;
                }
                case LBSR: {
                    PlatformKind lkind = this.input.getPlatformKind();
                    assert (lkind == SPARCKind.XWORD);
                    Register tmp = ValueUtil.asRegister((Value)this.scratch);
                    assert (!tmp.equals((Object)dst));
                    masm.srlx(src, 1, tmp);
                    masm.or(src, tmp, dst);
                    masm.srlx(dst, 2, tmp);
                    masm.or(dst, tmp, dst);
                    masm.srlx(dst, 4, tmp);
                    masm.or(dst, tmp, dst);
                    masm.srlx(dst, 8, tmp);
                    masm.or(dst, tmp, dst);
                    masm.srlx(dst, 16, tmp);
                    masm.or(dst, tmp, dst);
                    masm.srlx(dst, 32, tmp);
                    masm.or(dst, tmp, dst);
                    masm.popc(dst, dst);
                    masm.sub(dst, 1, dst);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        } else {
            throw GraalError.shouldNotReachHere();
        }
    }

    public static enum IntrinsicOpcode {
        IBSR(SPARCLIRInstructionMixin.SizeEstimate.create(13)),
        LBSR(SPARCLIRInstructionMixin.SizeEstimate.create(14)),
        BSF(SPARCLIRInstructionMixin.SizeEstimate.create(4));

        final SPARCLIRInstructionMixin.SizeEstimate size;

        private IntrinsicOpcode(SPARCLIRInstructionMixin.SizeEstimate size) {
            this.size = size;
        }
    }
}

