/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.framemap;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.lir.framemap.ReferenceMapBuilder;

public abstract class FrameMap {
    private final TargetDescription target;
    private final RegisterConfig registerConfig;
    private final ReferenceMapBuilderFactory referenceMapFactory;
    private int frameSize;
    protected int initialSpillSize;
    protected int spillSize;
    protected int outgoingSize;
    protected boolean hasOutgoingStackArguments;
    private boolean accessesCallerFrame;

    public FrameMap(CodeCacheProvider codeCache, RegisterConfig registerConfig, ReferenceMapBuilderFactory referenceMapFactory) {
        this.target = codeCache.getTarget();
        this.registerConfig = registerConfig == null ? codeCache.getRegisterConfig() : registerConfig;
        this.frameSize = -1;
        this.outgoingSize = codeCache.getMinimumOutgoingSize();
        this.referenceMapFactory = referenceMapFactory;
    }

    public RegisterConfig getRegisterConfig() {
        return this.registerConfig;
    }

    public TargetDescription getTarget() {
        return this.target;
    }

    protected int returnAddressSize() {
        return this.getTarget().arch.getReturnAddressSize();
    }

    public boolean accessesCallerFrame() {
        return this.accessesCallerFrame;
    }

    public int frameSize() {
        assert (this.frameSize != -1) : "frame size not computed yet";
        return this.frameSize;
    }

    public int outgoingSize() {
        return this.outgoingSize;
    }

    public boolean frameNeedsAllocating() {
        int unalignedFrameSize = this.spillSize - this.returnAddressSize();
        return this.hasOutgoingStackArguments || unalignedFrameSize != 0;
    }

    public abstract int totalFrameSize();

    public abstract int currentFrameSize();

    protected int alignFrameSize(int size) {
        return NumUtil.roundUp(size, this.getTarget().stackAlignment);
    }

    public void finish() {
        this.frameSize = this.currentFrameSize();
        if (this.frameSize > this.getRegisterConfig().getMaximumFrameSize()) {
            throw new PermanentBailoutException("Frame size (%d) exceeded maximum allowed frame size (%d).", this.frameSize, this.getRegisterConfig().getMaximumFrameSize());
        }
    }

    public int offsetForStackSlot(StackSlot slot) {
        if (slot.isInCallerFrame()) {
            this.accessesCallerFrame = true;
        }
        return slot.getOffset(this.totalFrameSize());
    }

    public void callsMethod(CallingConvention cc) {
        this.reserveOutgoing(cc.getStackSize());
    }

    public void reserveOutgoing(int argsSize) {
        assert (this.frameSize == -1) : "frame size must not yet be fixed";
        this.outgoingSize = Math.max(this.outgoingSize, argsSize);
        this.hasOutgoingStackArguments = this.hasOutgoingStackArguments || argsSize > 0;
    }

    public int spillSlotSize(ValueKind<?> kind) {
        return kind.getPlatformKind().getSizeInBytes();
    }

    public StackSlot allocateSpillSlot(ValueKind<?> kind) {
        assert (this.frameSize == -1) : "frame size must not yet be fixed";
        int size = this.spillSlotSize(kind);
        this.spillSize = NumUtil.roundUp(this.spillSize + size, size);
        return this.newStackSlot(kind);
    }

    private StackSlot newStackSlot(ValueKind<?> kind) {
        return StackSlot.get(kind, (int)(-this.spillSize), (boolean)true);
    }

    public int spillSlotRangeSize(int slots) {
        return slots * this.getTarget().wordSize;
    }

    public StackSlot allocateStackSlots(int slots) {
        assert (this.frameSize == -1) : "frame size must not yet be fixed";
        if (slots == 0) {
            return null;
        }
        this.spillSize = NumUtil.roundUp(this.spillSize + this.spillSlotRangeSize(slots), this.getTarget().wordSize);
        return this.newStackSlot(LIRKind.value(this.getTarget().arch.getWordKind()));
    }

    public ReferenceMapBuilder newReferenceMapBuilder() {
        return this.referenceMapFactory.newReferenceMapBuilder(this.totalFrameSize());
    }

    public static interface ReferenceMapBuilderFactory {
        public ReferenceMapBuilder newReferenceMapBuilder(int var1);
    }
}

