/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.constopt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.cfg.PrintableDominatorOptimizationProblem;
import org.graalvm.compiler.core.common.cfg.PropertyConsumable;
import org.graalvm.compiler.lir.constopt.DefUseTree;
import org.graalvm.compiler.lir.constopt.UseEntry;

public class ConstantTree
extends PrintableDominatorOptimizationProblem<Flags, NodeCost> {
    private final BlockMap<List<UseEntry>> blockMap;

    public ConstantTree(AbstractControlFlowGraph<?> cfg, DefUseTree tree) {
        super(Flags.class, cfg);
        this.blockMap = new BlockMap(cfg);
        tree.forEach(u -> this.getOrInitList(u.getBlock()).add((UseEntry)u));
    }

    private List<UseEntry> getOrInitList(AbstractBlockBase<?> block) {
        List<UseEntry> list = this.blockMap.get(block);
        if (list == null) {
            list = new ArrayList<UseEntry>();
            this.blockMap.put(block, list);
        }
        return list;
    }

    public List<UseEntry> getUsages(AbstractBlockBase<?> block) {
        List<UseEntry> list = this.blockMap.get(block);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    NodeCost getOrInitCost(AbstractBlockBase<?> block) {
        NodeCost cost = (NodeCost)this.getCost(block);
        if (cost == null) {
            cost = new NodeCost(block.getRelativeFrequency(), this.blockMap.get(block), 1);
            this.setCost(block, cost);
        }
        return cost;
    }

    @Override
    public String getName(Flags type) {
        switch (type) {
            case USAGE: {
                return "hasUsage";
            }
            case SUBTREE: {
                return "inSubtree";
            }
            case MATERIALIZE: {
                return "materialize";
            }
            case CANDIDATE: {
                return "candidate";
            }
        }
        return super.getName(type);
    }

    @Override
    public void forEachPropertyPair(AbstractBlockBase<?> block, BiConsumer<String, String> action) {
        if (this.get(Flags.SUBTREE, block) && (block.getDominator() == null || !this.get(Flags.SUBTREE, (AbstractBlockBase<?>)block.getDominator()))) {
            action.accept("hasDefinition", "true");
        }
        super.forEachPropertyPair(block, action);
    }

    public long subTreeSize() {
        return this.stream(Flags.SUBTREE).count();
    }

    public AbstractBlockBase<?> getStartBlock() {
        return this.stream(Flags.SUBTREE).findFirst().get();
    }

    public void markBlocks() {
        for (AbstractBlockBase<?> block : this.getBlocks()) {
            if (!this.get(Flags.USAGE, block)) continue;
            this.setDominatorPath(Flags.SUBTREE, block);
        }
    }

    public boolean isMarked(AbstractBlockBase<?> block) {
        return this.get(Flags.SUBTREE, block);
    }

    public boolean isLeafBlock(AbstractBlockBase<?> block) {
        for (Object dom = block.getFirstDominated(); dom != null; dom = ((AbstractBlockBase)dom).getDominatedSibling()) {
            if (!this.isMarked((AbstractBlockBase<?>)dom)) continue;
            return false;
        }
        return true;
    }

    public void setSolution(AbstractBlockBase<?> block) {
        this.set(Flags.MATERIALIZE, block);
    }

    public int size() {
        return this.getBlocks().length;
    }

    public void traverseTreeWhileTrue(AbstractBlockBase<?> block, Predicate<AbstractBlockBase<?>> action) {
        assert (block != null) : "block must not be null!";
        if (action.test(block)) {
            for (Object dom = block.getFirstDominated(); dom != null; dom = ((AbstractBlockBase)dom).getDominatedSibling()) {
                if (!this.isMarked((AbstractBlockBase<?>)dom)) continue;
                this.traverseTreeWhileTrue((AbstractBlockBase<?>)dom, action);
            }
        }
    }

    public static class NodeCost
    implements PropertyConsumable {
        private List<UseEntry> usages;
        private double bestCost;
        private int numMat;

        public NodeCost(double bestCost, List<UseEntry> usages, int numMat) {
            this.bestCost = bestCost;
            this.usages = usages;
            this.numMat = numMat;
        }

        @Override
        public void forEachProperty(BiConsumer<String, String> action) {
            action.accept("bestCost", Double.toString(this.getBestCost()));
            action.accept("numMat", Integer.toString(this.getNumMaterializations()));
            action.accept("numUsages", Integer.toString(this.usages.size()));
        }

        public void addUsage(UseEntry usage) {
            if (this.usages == null) {
                this.usages = new ArrayList<UseEntry>();
            }
            this.usages.add(usage);
        }

        public List<UseEntry> getUsages() {
            if (this.usages == null) {
                return Collections.emptyList();
            }
            return this.usages;
        }

        public double getBestCost() {
            return this.bestCost;
        }

        public int getNumMaterializations() {
            return this.numMat;
        }

        public void setBestCost(double cost) {
            this.bestCost = cost;
        }

        public String toString() {
            return "NodeCost [bestCost=" + this.bestCost + ", numUsages=" + this.usages.size() + ", numMat=" + this.numMat + "]";
        }
    }

    public static enum Flags {
        SUBTREE,
        USAGE,
        MATERIALIZE,
        CANDIDATE;

    }
}

