/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64.vector;

import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64VectorGatherOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64VectorGatherOp> TYPE = LIRInstructionClass.create(AMD64VectorGatherOp.class);
    @Opcode
    private final AMD64Assembler.VexGatherOp opcode;
    private final AVXKind.AVXSize size;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue base;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue index;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue mask;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue maskTemp;

    public AMD64VectorGatherOp(AMD64Assembler.VexGatherOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue base, AllocatableValue index, AllocatableValue mask) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.opcode = opcode;
        this.size = size;
        this.result = result;
        this.base = base;
        this.index = index;
        this.mask = mask;
        this.maskTemp = mask;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        AMD64Address address = new AMD64Address(ValueUtil.asRegister((Value)this.base), ValueUtil.asRegister((Value)this.index), AMD64Address.Scale.Times1);
        this.opcode.emit(masm, this.size, ValueUtil.asRegister((Value)this.result), address, ValueUtil.asRegister((Value)this.mask));
    }
}

