/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import java.util.EnumSet;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.lir.CompositeValue;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIRInstruction;

public final class AMD64AddressValue
extends CompositeValue {
    @CompositeValue.Component(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected AllocatableValue base;
    @CompositeValue.Component(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected AllocatableValue index;
    protected final AMD64Address.Scale scale;
    protected final int displacement;
    private static final EnumSet<LIRInstruction.OperandFlag> flags = EnumSet.of(LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL);

    public AMD64AddressValue(ValueKind<?> kind, AllocatableValue base, int displacement) {
        this(kind, base, Value.ILLEGAL, AMD64Address.Scale.Times1, displacement);
    }

    public AMD64AddressValue(ValueKind<?> kind, AllocatableValue base, AllocatableValue index, AMD64Address.Scale scale, int displacement) {
        super(kind);
        this.base = base;
        this.index = index;
        this.scale = scale;
        this.displacement = displacement;
        assert (scale != null);
    }

    public AllocatableValue getBase() {
        return this.base;
    }

    public AllocatableValue getIndex() {
        return this.index;
    }

    @Override
    public CompositeValue forEachComponent(LIRInstruction inst, LIRInstruction.OperandMode mode, InstructionValueProcedure proc) {
        AllocatableValue newBase = (AllocatableValue)proc.doValue(inst, (Value)this.base, mode, flags);
        AllocatableValue newIndex = (AllocatableValue)proc.doValue(inst, (Value)this.index, mode, flags);
        if (!this.base.identityEquals((Value)newBase) || !this.index.identityEquals((Value)newIndex)) {
            return new AMD64AddressValue(this.getValueKind(), newBase, newIndex, this.scale, this.displacement);
        }
        return this;
    }

    @Override
    protected void visitEachComponent(LIRInstruction inst, LIRInstruction.OperandMode mode, InstructionValueConsumer proc) {
        proc.visitValue(inst, (Value)this.base, mode, flags);
        proc.visitValue(inst, (Value)this.index, mode, flags);
    }

    public AMD64AddressValue withKind(ValueKind<?> newKind) {
        return new AMD64AddressValue(newKind, this.base, this.index, this.scale, this.displacement);
    }

    private static Register toRegister(AllocatableValue value) {
        if (value.equals((Object)Value.ILLEGAL)) {
            return Register.None;
        }
        RegisterValue reg = (RegisterValue)value;
        return reg.getRegister();
    }

    public AMD64Address toAddress() {
        return new AMD64Address(AMD64AddressValue.toRegister(this.base), AMD64AddressValue.toRegister(this.index), this.scale, this.displacement);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[");
        String sep = "";
        if (ValueUtil.isLegal((Value)this.base)) {
            s.append(this.base);
            sep = " + ";
        }
        if (ValueUtil.isLegal((Value)this.index)) {
            s.append(sep).append(this.index).append(" * ").append(this.scale.value);
            sep = " + ";
        }
        if (this.displacement < 0) {
            s.append(" - ").append(-this.displacement);
        } else if (this.displacement > 0) {
            s.append(sep).append(this.displacement);
        }
        s.append("]");
        return s.toString();
    }

    public boolean isValidImplicitNullCheckFor(Value value, int implicitNullCheckLimit) {
        return value.equals((Object)this.base) && this.index.equals((Object)Value.ILLEGAL) && this.displacement >= 0 && this.displacement < implicitNullCheckLimit;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AMD64AddressValue) {
            AMD64AddressValue addr = (AMD64AddressValue)((Object)obj);
            return this.getValueKind().equals(addr.getValueKind()) && this.displacement == addr.displacement && this.base.equals((Object)addr.base) && this.scale == addr.scale && this.index.equals((Object)addr.index);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.base.hashCode() ^ this.index.hashCode() ^ this.displacement << 4 ^ this.scale.value << 8 ^ this.getValueKind().hashCode();
    }
}

