/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.ValueConsumer;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;

public final class RedundantMoveElimination
extends PostAllocationOptimizationPhase {
    private static final CounterKey deletedMoves = DebugContext.counter("RedundantMovesEliminated");

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        Optimization redundantMoveElimination = new Optimization(lirGenRes.getFrameMap());
        redundantMoveElimination.doOptimize(lirGenRes.getLIR());
    }

    private static final class Optimization {
        EconomicMap<AbstractBlockBase<?>, BlockData> blockData = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        RegisterArray callerSaveRegs;
        int[] eligibleRegs;
        EconomicMap<Integer, Integer> stackIndices = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        int numRegs;
        private final FrameMap frameMap;
        static final int INIT_VALUE = 0;
        private static final int COMPLEXITY_LIMIT = 30000;

        Optimization(FrameMap frameMap) {
            this.frameMap = frameMap;
        }

        private void doOptimize(LIR lir) {
            DebugContext debug = lir.getDebug();
            try (Indent indent = debug.logAndIndent("eliminate redundant moves");){
                RegisterConfig registerConfig = this.frameMap.getRegisterConfig();
                this.callerSaveRegs = registerConfig.getCallerSaveRegisters();
                this.initBlockData(lir);
                this.eligibleRegs = new int[this.numRegs];
                Arrays.fill(this.eligibleRegs, -1);
                for (Register reg : registerConfig.getAllocatableRegisters()) {
                    if (reg.number >= this.numRegs) continue;
                    this.eligibleRegs[reg.number] = reg.number;
                }
                if (!this.solveDataFlow(lir)) {
                    return;
                }
                this.eliminateMoves(lir);
            }
        }

        private void initBlockData(LIR lir) {
            DebugContext debug = lir.getDebug();
            AbstractBlockBase<?>[] blocks = lir.linearScanOrder();
            this.numRegs = 0;
            int maxStackLocations = 30000 / blocks.length;
            for (AbstractBlockBase<?> block : blocks) {
                ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(block);
                for (LIRInstruction op : instructions) {
                    StackSlot stackSlot;
                    Integer offset;
                    if (!Optimization.isEligibleMove(op)) continue;
                    AllocatableValue dest = StandardOp.MoveOp.asMoveOp(op).getResult();
                    if (ValueUtil.isRegister((Value)dest)) {
                        int regNum = ((RegisterValue)dest).getRegister().number;
                        if (regNum < this.numRegs) continue;
                        this.numRegs = regNum + 1;
                        continue;
                    }
                    if (!ValueUtil.isStackSlot((Value)dest) || this.stackIndices.containsKey((Object)(offset = Integer.valueOf(this.getOffset(stackSlot = (StackSlot)dest)))) || this.stackIndices.size() >= maxStackLocations) continue;
                    this.stackIndices.put((Object)offset, (Object)this.stackIndices.size());
                }
            }
            int numLocations = this.numRegs + this.stackIndices.size();
            debug.log("num locations = %d (regs = %d, stack = %d)", numLocations, this.numRegs, this.stackIndices.size());
            for (AbstractBlockBase<?> block : blocks) {
                BlockData data = new BlockData(numLocations);
                this.blockData.put(block, (Object)data);
            }
        }

        private int getOffset(StackSlot stackSlot) {
            return stackSlot.getOffset(this.frameMap.totalFrameSize());
        }

        private boolean solveDataFlow(LIR lir) {
            DebugContext debug = lir.getDebug();
            try (Indent indent = debug.logAndIndent("solve data flow");){
                boolean changed;
                AbstractBlockBase<?>[] blocks = lir.linearScanOrder();
                int numIter = 0;
                int currentValueNum = 1;
                boolean firstRound = true;
                do {
                    changed = false;
                    try (Indent indent2 = debug.logAndIndent("new iteration");){
                        for (AbstractBlockBase<?> block : blocks) {
                            BlockData data = (BlockData)this.blockData.get(block);
                            if (firstRound) {
                                data.entryValueNum = currentValueNum;
                            }
                            int valueNum = data.entryValueNum;
                            assert (valueNum > 0);
                            boolean newState = false;
                            if (block == blocks[0] || block.isExceptionEntry()) {
                                debug.log("kill all values at entry of block %d", block.getId());
                                Optimization.clearValues(data.entryState, valueNum);
                            } else {
                                for (AbstractBlockBase predecessor : block.getPredecessors()) {
                                    BlockData predData = (BlockData)this.blockData.get((Object)predecessor);
                                    newState |= Optimization.mergeState(data.entryState, predData.exitState, valueNum);
                                }
                            }
                            valueNum += data.entryState.length;
                            if (newState || firstRound) {
                                try (Indent indent3 = debug.logAndIndent("update block %d", block.getId());){
                                    int[] iterState = data.exitState;
                                    Optimization.copyState(iterState, data.entryState);
                                    ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(block);
                                    for (LIRInstruction op : instructions) {
                                        valueNum = this.updateState(debug, iterState, op, valueNum);
                                    }
                                    changed = true;
                                }
                            }
                            if (!firstRound) continue;
                            currentValueNum = valueNum;
                        }
                        firstRound = false;
                    }
                    if (++numIter <= 5) continue;
                    boolean bl = false;
                    return bl;
                } while (changed);
            }
            return true;
        }

        private void eliminateMoves(LIR lir) {
            DebugContext debug = lir.getDebug();
            try (Indent indent = debug.logAndIndent("eliminate moves");){
                AbstractBlockBase<?>[] blocks;
                for (AbstractBlockBase<?> block : blocks = lir.linearScanOrder()) {
                    try (Indent indent2 = debug.logAndIndent("eliminate moves in block %d", block.getId());){
                        ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(block);
                        BlockData data = (BlockData)this.blockData.get(block);
                        boolean hasDead = false;
                        int[] iterState = data.entryState;
                        int valueNum = data.entryValueNum + data.entryState.length;
                        int numInsts = instructions.size();
                        for (int idx = 0; idx < numInsts; ++idx) {
                            LIRInstruction op = instructions.get(idx);
                            if (Optimization.isEligibleMove(op)) {
                                StandardOp.ValueMoveOp moveOp = StandardOp.ValueMoveOp.asValueMoveOp(op);
                                int sourceIdx = this.getStateIdx((Value)moveOp.getInput());
                                int destIdx = this.getStateIdx((Value)moveOp.getResult());
                                if (sourceIdx >= 0 && destIdx >= 0 && iterState[sourceIdx] == iterState[destIdx]) {
                                    assert (iterState[sourceIdx] != 0);
                                    debug.log("delete move %s", op);
                                    instructions.set(idx, null);
                                    hasDead = true;
                                    deletedMoves.increment(debug);
                                }
                            }
                            valueNum = this.updateState(debug, iterState, op, valueNum);
                        }
                        if (!hasDead) continue;
                        instructions.removeAll(Collections.singleton(null));
                    }
                }
            }
        }

        private int updateState(final DebugContext debug, final int[] state, LIRInstruction op, int initValueNum) {
            try (Indent indent = debug.logAndIndent("update state for op %s, initial value num = %d", (Object)op, initValueNum);){
                if (Optimization.isEligibleMove(op)) {
                    StandardOp.ValueMoveOp moveOp = StandardOp.ValueMoveOp.asValueMoveOp(op);
                    int sourceIdx = this.getStateIdx((Value)moveOp.getInput());
                    int destIdx = this.getStateIdx((Value)moveOp.getResult());
                    if (sourceIdx >= 0 && destIdx >= 0) {
                        assert (Optimization.isObjectValue(state[sourceIdx]) || LIRKind.isValue((Value)moveOp.getInput())) : "move op moves object but input is not defined as object " + moveOp;
                        state[destIdx] = state[sourceIdx];
                        debug.log("move value %d from %d to %d", state[sourceIdx], sourceIdx, destIdx);
                        int n = initValueNum;
                        return n;
                    }
                }
                int valueNum = initValueNum;
                if (op.destroysCallerSavedRegisters()) {
                    debug.log("kill all caller save regs");
                    for (Register reg : this.callerSaveRegs) {
                        if (reg.number >= this.numRegs) continue;
                        state[reg.number] = Optimization.encodeValueNum(valueNum++, true);
                    }
                }
                class OutputValueConsumer
                implements ValueConsumer {
                    int opValueNum;

                    OutputValueConsumer(int opValueNum) {
                        this.opValueNum = opValueNum;
                    }

                    @Override
                    public void visitValue(Value operand, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
                        int stateIdx = Optimization.this.getStateIdx(operand);
                        if (stateIdx >= 0) {
                            state[stateIdx] = Optimization.encodeValueNum(this.opValueNum++, !LIRKind.isValue(operand));
                            debug.log("set def %d for register %s(%d): %d", this.opValueNum, (Object)operand, (Object)stateIdx, (Object)state[stateIdx]);
                        }
                    }
                }
                OutputValueConsumer outputValueConsumer = new OutputValueConsumer(valueNum);
                op.visitEachTemp(outputValueConsumer);
                op.visitEachOutput(outputValueConsumer);
                valueNum = outputValueConsumer.opValueNum;
                if (op.hasState()) {
                    debug.log("kill all object values");
                    Optimization.clearValuesOfKindObject(state, valueNum);
                    valueNum += state.length;
                }
                int n = valueNum;
                return n;
            }
        }

        private static boolean mergeState(int[] dest, int[] source, int defNum) {
            assert (dest.length == source.length);
            boolean changed = false;
            for (int idx = 0; idx < source.length; ++idx) {
                int phiNum = defNum + idx;
                int dst = dest[idx];
                int src = source[idx];
                if (dst == src || src == 0 || dst == Optimization.encodeValueNum(phiNum, Optimization.isObjectValue(dst))) continue;
                dst = dst != 0 ? Optimization.encodeValueNum(phiNum, Optimization.isObjectValue(dst) || Optimization.isObjectValue(src)) : src;
                dest[idx] = dst;
                changed = true;
            }
            return changed;
        }

        private static void copyState(int[] dest, int[] source) {
            assert (dest.length == source.length);
            for (int idx = 0; idx < source.length; ++idx) {
                dest[idx] = source[idx];
            }
        }

        private static void clearValues(int[] state, int defNum) {
            for (int idx = 0; idx < state.length; ++idx) {
                int phiNum = defNum + idx;
                state[idx] = Optimization.encodeValueNum(phiNum, true);
            }
        }

        private static void clearValuesOfKindObject(int[] state, int defNum) {
            for (int idx = 0; idx < state.length; ++idx) {
                int phiNum = defNum + idx;
                if (!Optimization.isObjectValue(state[idx])) continue;
                state[idx] = Optimization.encodeValueNum(phiNum, true);
            }
        }

        private int getStateIdx(Value location) {
            StackSlot slot;
            Integer index;
            if (ValueUtil.isRegister((Value)location)) {
                int regNum = ((RegisterValue)location).getRegister().number;
                if (regNum < this.numRegs) {
                    return this.eligibleRegs[regNum];
                }
                return -1;
            }
            if (ValueUtil.isStackSlot((Value)location) && (index = (Integer)this.stackIndices.get((Object)this.getOffset(slot = (StackSlot)location))) != null) {
                return index + this.numRegs;
            }
            return -1;
        }

        private static int encodeValueNum(int valueNum, boolean isObjectKind) {
            assert (valueNum > 0);
            if (isObjectKind) {
                return -valueNum;
            }
            return valueNum;
        }

        private static boolean isObjectValue(int encodedValueNum) {
            return encodedValueNum < 0;
        }

        private static boolean isEligibleMove(LIRInstruction op) {
            if (StandardOp.ValueMoveOp.isValueMoveOp(op)) {
                StandardOp.ValueMoveOp moveOp = StandardOp.ValueMoveOp.asValueMoveOp(op);
                AllocatableValue source = moveOp.getInput();
                AllocatableValue dest = moveOp.getResult();
                return source.getValueKind().equals(dest.getValueKind());
            }
            return false;
        }
    }

    private static final class BlockData {
        int[] entryState;
        int[] exitState;
        int entryValueNum;

        BlockData(int stateSize) {
            this.entryState = new int[stateSize];
            this.exitState = new int[stateSize];
        }
    }
}

