/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.java;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.ToIntFunction;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeLookupSwitch;
import org.graalvm.compiler.bytecode.BytecodeStream;
import org.graalvm.compiler.bytecode.BytecodeSwitch;
import org.graalvm.compiler.bytecode.BytecodeTableSwitch;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.JavaMethodContext;
import org.graalvm.compiler.java.JsrNotSupportedBailout;
import org.graalvm.compiler.java.JsrScope;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;

public final class BciBlockMapping
implements JavaMethodContext {
    private static final int UNASSIGNED_ID = -1;
    private BciBlock[] blocks;
    public final Bytecode code;
    public boolean hasJsrBytecodes;
    private final ExceptionHandler[] exceptionHandlers;
    private BciBlock startBlock;
    private BciBlock[] loopHeaders;
    private static final int LOOP_HEADER_MAX_CAPACITY = 64;
    private static final int LOOP_HEADER_INITIAL_CAPACITY = 4;
    private int blocksNotYetAssignedId;
    private final DebugContext debug;
    private int postJsrBlockCount;
    private int newDuplicateBlocks;
    private int duplicateBlocks;
    private final ArrayList<BciBlock> jsrVisited = new ArrayList();
    private int nextLoop;

    private BciBlockMapping(Bytecode code, DebugContext debug) {
        this.code = code;
        this.debug = debug;
        this.exceptionHandlers = code.getExceptionHandlers();
    }

    public BciBlock[] getBlocks() {
        return this.blocks;
    }

    public void build(BytecodeStream stream, OptionValues options) {
        int codeSize = this.code.getCodeSize();
        BciBlock[] blockMap = new BciBlock[codeSize];
        this.makeExceptionEntries(blockMap);
        this.iterateOverBytecodes(blockMap, stream);
        this.startBlock = blockMap[0];
        if (this.debug.isDumpEnabled(2)) {
            this.debug.dump(2, this, this.code.getMethod().format("After iterateOverBytecodes %f %R %H.%n(%P)"));
        }
        if (this.hasJsrBytecodes) {
            if (!GraalOptions.SupportJsrBytecodes.getValue(options).booleanValue()) {
                throw new JsrNotSupportedBailout("jsr/ret parsing disabled");
            }
            this.createJsrAlternatives(blockMap, this.startBlock);
            if (this.debug.isDumpEnabled(2)) {
                this.debug.dump(2, this, this.code.getMethod().format("After createJsrAlternatives %f %R %H.%n(%P)"));
            }
        }
        this.postJsrBlockCount = this.blocksNotYetAssignedId;
        if (this.debug.isLogEnabled()) {
            this.log(blockMap, "Before BlockOrder");
        }
        this.computeBlockOrder(blockMap);
        if (this.debug.isDumpEnabled(2)) {
            this.debug.dump(2, this, this.code.getMethod().format("After computeBlockOrder %f %R %H.%n(%P)"));
        }
        assert (this.verify());
        if (this.debug.isLogEnabled()) {
            this.log(blockMap, "Before LivenessAnalysis");
        }
    }

    private boolean verify() {
        for (BciBlock block : this.blocks) {
            assert (this.blocks[block.getId()] == block);
            for (int i = 0; i < block.getSuccessorCount(); ++i) {
                BciBlock sux = block.getSuccessor(i);
                if (sux instanceof ExceptionDispatchBlock) assert (i == block.getSuccessorCount() - 1) : "Only one exception handler allowed, and it must be last in successors list";
            }
        }
        return true;
    }

    private void makeExceptionEntries(BciBlock[] blockMap) {
        for (ExceptionHandler h : this.exceptionHandlers) {
            BciBlock xhandler = this.makeBlock(blockMap, h.getHandlerBCI());
            xhandler.isExceptionEntry = true;
        }
    }

    private void iterateOverBytecodes(BciBlock[] blockMap, BytecodeStream stream) {
        BciBlock current = null;
        stream.setBCI(0);
        while (stream.currentBC() != 256) {
            int bci = stream.currentBCI();
            if (current == null || blockMap[bci] != null) {
                BciBlock b = this.makeBlock(blockMap, bci);
                if (current != null) {
                    BciBlockMapping.addSuccessor(blockMap, current.endBci, b);
                }
                current = b;
            }
            blockMap[bci] = current;
            current.endBci = bci;
            switch (stream.currentBC()) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    current = null;
                    break;
                }
                case 191: {
                    current = null;
                    ExceptionDispatchBlock handler = this.handleExceptions(blockMap, bci);
                    if (handler == null) break;
                    BciBlockMapping.addSuccessor(blockMap, bci, handler);
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    current = null;
                    BciBlockMapping.addSuccessor(blockMap, bci, this.makeBlock(blockMap, stream.readBranchDest()));
                    BciBlockMapping.addSuccessor(blockMap, bci, this.makeBlock(blockMap, stream.nextBCI()));
                    break;
                }
                case 167: 
                case 200: {
                    current = null;
                    BciBlockMapping.addSuccessor(blockMap, bci, this.makeBlock(blockMap, stream.readBranchDest()));
                    break;
                }
                case 170: {
                    current = null;
                    this.addSwitchSuccessors(blockMap, bci, new BytecodeTableSwitch(stream, bci));
                    break;
                }
                case 171: {
                    current = null;
                    this.addSwitchSuccessors(blockMap, bci, new BytecodeLookupSwitch(stream, bci));
                    break;
                }
                case 168: 
                case 201: {
                    this.hasJsrBytecodes = true;
                    int target = stream.readBranchDest();
                    if (target == 0) {
                        throw new JsrNotSupportedBailout("jsr target bci 0 not allowed");
                    }
                    BciBlock b1 = this.makeBlock(blockMap, target);
                    current.setJsrSuccessor(b1);
                    current.setJsrReturnBci(stream.nextBCI());
                    current = null;
                    BciBlockMapping.addSuccessor(blockMap, bci, b1);
                    break;
                }
                case 169: {
                    current.setEndsWithRet();
                    current = null;
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: {
                    current = null;
                    BciBlockMapping.addSuccessor(blockMap, bci, this.makeBlock(blockMap, stream.nextBCI()));
                    ExceptionDispatchBlock handler = this.handleExceptions(blockMap, bci);
                    if (handler == null) break;
                    BciBlockMapping.addSuccessor(blockMap, bci, handler);
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 108: 
                case 109: 
                case 112: 
                case 113: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 192: 
                case 193: 
                case 194: 
                case 197: {
                    ExceptionDispatchBlock handler = this.handleExceptions(blockMap, bci);
                    if (handler == null) break;
                    current = null;
                    BciBlockMapping.addSuccessor(blockMap, bci, this.makeBlock(blockMap, stream.nextBCI()));
                    BciBlockMapping.addSuccessor(blockMap, bci, handler);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 110: 
                case 111: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 195: {
                    break;
                }
                default: {
                    throw new GraalError("Unhandled bytecode");
                }
            }
            stream.next();
        }
    }

    private BciBlock makeBlock(BciBlock[] blockMap, int startBci) {
        BciBlock oldBlock = blockMap[startBci];
        if (oldBlock == null) {
            BciBlock newBlock = new BciBlock(startBci);
            ++this.blocksNotYetAssignedId;
            blockMap[startBci] = newBlock;
            return newBlock;
        }
        if (oldBlock.startBci != startBci) {
            BciBlock newBlock = new BciBlock(startBci);
            ++this.blocksNotYetAssignedId;
            newBlock.endBci = oldBlock.endBci;
            for (BciBlock oldSuccessor : oldBlock.getSuccessors()) {
                newBlock.addSuccessor(oldSuccessor);
            }
            oldBlock.endBci = startBci - 1;
            oldBlock.clearSucccessors();
            oldBlock.addSuccessor(newBlock);
            for (int i = startBci; i <= newBlock.endBci; ++i) {
                blockMap[i] = newBlock;
            }
            return newBlock;
        }
        return oldBlock;
    }

    private void addSwitchSuccessors(BciBlock[] blockMap, int predBci, BytecodeSwitch bswitch) {
        TreeSet<Integer> targets = new TreeSet<Integer>();
        for (int i = 0; i < bswitch.numberOfCases(); ++i) {
            targets.add(bswitch.targetAt(i));
        }
        targets.add(bswitch.defaultTarget());
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            int targetBci = (Integer)iterator.next();
            BciBlockMapping.addSuccessor(blockMap, predBci, this.makeBlock(blockMap, targetBci));
        }
    }

    private static void addSuccessor(BciBlock[] blockMap, int predBci, BciBlock sux) {
        BciBlock predecessor = blockMap[predBci];
        if (sux.isExceptionEntry) {
            throw new PermanentBailoutException("Exception handler can be reached by both normal and exceptional control flow");
        }
        predecessor.addSuccessor(sux);
    }

    private void createJsrAlternatives(BciBlock[] blockMap, BciBlock block) {
        this.jsrVisited.add(block);
        JsrScope scope = block.getJsrScope();
        if (block.endsWithRet()) {
            block.setRetSuccessor(blockMap[scope.nextReturnAddress()]);
            block.addSuccessor(block.getRetSuccessor());
            assert (block.getRetSuccessor() != block.getJsrSuccessor());
        }
        this.debug.log("JSR alternatives block %s  sux %s  jsrSux %s  retSux %s  jsrScope %s", block, block.getSuccessors(), (Object)block.getJsrSuccessor(), (Object)block.getRetSuccessor(), (Object)block.getJsrScope());
        if (block.getJsrSuccessor() != null || !scope.isEmpty()) {
            for (int i = 0; i < block.getSuccessorCount(); ++i) {
                BciBlock clone;
                BciBlock successor = block.getSuccessor(i);
                JsrScope nextScope = scope;
                if (successor == block.getJsrSuccessor()) {
                    nextScope = scope.push(block.getJsrReturnBci(), successor);
                }
                if (successor == block.getRetSuccessor()) {
                    nextScope = scope.pop();
                }
                if (!successor.getJsrScope().isPrefixOf(nextScope)) {
                    throw new JsrNotSupportedBailout("unstructured control flow  (" + successor.getJsrScope() + " " + nextScope + ")");
                }
                if (nextScope.isEmpty()) continue;
                if (successor.getJsrAlternatives() != null && successor.getJsrAlternatives().containsKey((Object)nextScope)) {
                    clone = (BciBlock)successor.getJsrAlternatives().get((Object)nextScope);
                } else {
                    successor.initJsrAlternatives();
                    clone = successor.copy();
                    ++this.blocksNotYetAssignedId;
                    clone.setJsrScope(nextScope);
                    successor.getJsrAlternatives().put((Object)nextScope, (Object)clone);
                }
                block.getSuccessors().set(i, clone);
                if (successor == block.getJsrSuccessor()) {
                    block.setJsrSuccessor(clone);
                }
                if (successor != block.getRetSuccessor()) continue;
                block.setRetSuccessor(clone);
            }
        }
        for (BciBlock successor : block.getSuccessors()) {
            if (this.jsrVisited.contains(successor) || !BciBlockMapping.shouldFollowEdge(successor, scope)) continue;
            this.createJsrAlternatives(blockMap, successor);
        }
    }

    private static boolean shouldFollowEdge(BciBlock successor, JsrScope scope) {
        if (successor instanceof ExceptionDispatchBlock && scope.getJsrEntryBlock() != null) {
            ExceptionDispatchBlock exceptionDispatchBlock = (ExceptionDispatchBlock)successor;
            int bci = scope.getJsrEntryBlock().startBci;
            if (exceptionDispatchBlock.handler.getStartBCI() < bci && bci < exceptionDispatchBlock.handler.getEndBCI()) {
                return false;
            }
        }
        return true;
    }

    private ExceptionDispatchBlock handleExceptions(BciBlock[] blockMap, int bci) {
        ExceptionDispatchBlock lastHandler = null;
        int dispatchBlocks = 0;
        for (int i = this.exceptionHandlers.length - 1; i >= 0; --i) {
            ExceptionHandler h = this.exceptionHandlers[i];
            if (h.getStartBCI() > bci || bci >= h.getEndBCI()) continue;
            if (h.isCatchAll()) {
                dispatchBlocks = 0;
                lastHandler = null;
            }
            ExceptionDispatchBlock curHandler = new ExceptionDispatchBlock(h, bci);
            ++dispatchBlocks;
            curHandler.addSuccessor(blockMap[h.getHandlerBCI()]);
            if (lastHandler != null) {
                curHandler.addSuccessor(lastHandler);
            }
            lastHandler = curHandler;
        }
        this.blocksNotYetAssignedId += dispatchBlocks;
        return lastHandler;
    }

    private void computeBlockOrder(BciBlock[] blockMap) {
        int maxBlocks = this.blocksNotYetAssignedId;
        this.blocks = new BciBlock[this.blocksNotYetAssignedId];
        this.computeBlockOrder(blockMap[0]);
        int duplicatedBlocks = this.newDuplicateBlocks + this.duplicateBlocks;
        if (duplicatedBlocks > 0) {
            this.debug.log(2, "Duplicated %d blocks. Original block count: %d", duplicatedBlocks, this.postJsrBlockCount);
        }
        int blockCount = maxBlocks - this.blocksNotYetAssignedId + 1 + this.duplicateBlocks;
        BciBlock[] newBlocks = new BciBlock[blockCount];
        int next = 0;
        for (int i = 0; i < this.blocks.length; ++i) {
            BciBlock b = this.blocks[i];
            if (b == null) continue;
            b.setId(next);
            newBlocks[next++] = b;
            if (!b.isLoopHeader) continue;
            next = this.handleLoopHeader(newBlocks, next, i, b);
        }
        assert (next == newBlocks.length - 1);
        ExceptionDispatchBlock unwindBlock = new ExceptionDispatchBlock(-4);
        unwindBlock.setId(newBlocks.length - 1);
        newBlocks[newBlocks.length - 1] = unwindBlock;
        this.blocks = newBlocks;
    }

    private int handleLoopHeader(BciBlock[] newBlocks, int nextStart, int i, BciBlock loopHeader) {
        int next = nextStart;
        for (int j = i + 1; j < this.blocks.length; ++j) {
            BciBlock other = this.blocks[j];
            if (other == null || (other.loops & 1L << loopHeader.loopId) == 0L) continue;
            other.setId(next);
            newBlocks[next++] = other;
            this.blocks[j] = null;
            if (!other.isLoopHeader) continue;
            next = this.handleLoopHeader(newBlocks, next, j, other);
        }
        return next;
    }

    public void log(BciBlock[] blockMap, String name) {
        if (this.debug.isLogEnabled()) {
            this.debug.log("%sBlockMap %s: %n%s", (Object)this.debug.getCurrentScopeName(), (Object)name, (Object)BciBlockMapping.toString(blockMap, this.loopHeaders));
        }
    }

    public static String toString(BciBlock[] blockMap, BciBlock[] loopHeadersMap) {
        if (blockMap == null) {
            return "no blockmap";
        }
        StringBuilder sb = new StringBuilder();
        HashMap debugIds = new HashMap();
        int[] nextDebugId = new int[]{-2};
        ToIntFunction<BciBlock> getId = b -> {
            int id = b.getId();
            if (id < 0) {
                id = debugIds.computeIfAbsent(b, bb -> {
                    int n = nextDebugId[0];
                    nextDebugId[0] = n - 1;
                    return n;
                });
            }
            return id;
        };
        for (BciBlock b2 : blockMap) {
            if (b2 == null) continue;
            sb.append("B").append(getId.applyAsInt(b2)).append("[").append(b2.startBci).append("..").append(b2.endBci).append("]");
            if (b2.isLoopHeader) {
                sb.append(" LoopHeader");
            }
            if (b2.isExceptionEntry) {
                sb.append(" ExceptionEntry");
            }
            if (b2 instanceof ExceptionDispatchBlock) {
                sb.append(" ExceptionDispatch");
            }
            if (!b2.successors.isEmpty()) {
                sb.append(" Successors=[");
                for (BciBlock s : b2.getSuccessors()) {
                    if (sb.charAt(sb.length() - 1) != '[') {
                        sb.append(", ");
                    }
                    sb.append("B").append(getId.applyAsInt(s));
                }
                sb.append("]");
            }
            if (b2.loops != 0L && loopHeadersMap != null) {
                sb.append(" Loops=[");
                long loops = b2.loops;
                do {
                    int pos = Long.numberOfTrailingZeros(loops);
                    if (sb.charAt(sb.length() - 1) != '[') {
                        sb.append(", ");
                    }
                    sb.append("B").append(getId.applyAsInt(loopHeadersMap[pos]));
                } while ((loops ^= loops & -loops) != 0L);
                sb.append("]");
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String toString() {
        return BciBlockMapping.toString(this.blocks, this.loopHeaders);
    }

    public BciBlock getLoopHeader(int index) {
        return this.loopHeaders[index];
    }

    private void makeLoopHeader(BciBlock block) {
        assert (!block.isLoopHeader);
        block.isLoopHeader = true;
        if (block.isExceptionEntry) {
            throw new PermanentBailoutException("Loop formed by an exception handler");
        }
        if (this.nextLoop >= 64) {
            throw new PermanentBailoutException("Too many loops in method");
        }
        block.loops |= 1L << this.nextLoop;
        this.debug.log("makeLoopHeader(%s) -> %x", (Object)block, (Object)block.loops);
        if (this.loopHeaders == null) {
            this.loopHeaders = new BciBlock[4];
        } else if (this.nextLoop >= this.loopHeaders.length) {
            this.loopHeaders = Arrays.copyOf(this.loopHeaders, 64);
        }
        this.loopHeaders[this.nextLoop] = block;
        block.loopId = this.nextLoop++;
    }

    private void propagateLoopBits(TraversalStep step, long loopBits) {
        TraversalStep s = step;
        while (s != null && (((TraversalStep)s).block.loops & loopBits) != loopBits) {
            ((TraversalStep)s).block.loops |= loopBits;
            if (((TraversalStep)s).block.loopIdChain != null) {
                for (TraversalStep chain : ((TraversalStep)s).block.loopIdChain) {
                    this.propagateLoopBits(chain, loopBits);
                }
            }
            s = s.pred;
        }
    }

    private void computeBlockOrder(BciBlock initialBlock) {
        ArrayDeque<TraversalStep> workStack = new ArrayDeque<TraversalStep>();
        workStack.push(new TraversalStep(initialBlock));
        while (!workStack.isEmpty()) {
            TraversalStep step = (TraversalStep)workStack.peek();
            BciBlock block = step.block;
            if (step.currentSuccessorIndex == 0) {
                block.visited = true;
                block.active = true;
            }
            if (step.currentSuccessorIndex < block.successors.size()) {
                BciBlock successor = block.getSuccessors().get(step.currentSuccessorIndex);
                if (step instanceof DuplicationTraversalStep) {
                    DuplicationTraversalStep duplicationStep = (DuplicationTraversalStep)step;
                    BciBlock targetHeader = duplicationStep.loopHeader;
                    if (successor != targetHeader && (successor.loops & (long)(1 << targetHeader.loopId)) != 0L) {
                        BciBlock duplicate = (BciBlock)duplicationStep.duplicationMap.get((Object)successor);
                        if (duplicate == null) {
                            duplicate = successor.duplicate();
                            ++this.newDuplicateBlocks;
                            duplicationStep.duplicationMap.put((Object)successor, (Object)duplicate);
                        }
                        successor = duplicate;
                        successor.predecessorCount++;
                        block.successors.set(step.currentSuccessorIndex, successor);
                    } else {
                        this.debug.dump(4, (Object)this, "Exiting duplication @ %s", successor);
                        this.debug.log("Exiting duplication @ %s", successor);
                        successor.predecessorCount++;
                    }
                }
                if (successor.visited) {
                    long loopBits;
                    boolean duplicationStarted = false;
                    if (successor.active) {
                        if (!successor.isLoopHeader) {
                            this.makeLoopHeader(successor);
                        }
                        loopBits = successor.loops;
                    } else {
                        int id;
                        loopBits = successor.loops;
                        if (successor.isLoopHeader) {
                            loopBits &= 1L << successor.loopId ^ 0xFFFFFFFFFFFFFFFFL;
                        }
                        int outermostInactiveLoopId = -1;
                        for (long checkBits = loopBits; checkBits != 0L; checkBits &= 1L << id ^ 0xFFFFFFFFFFFFFFFFL) {
                            id = Long.numberOfTrailingZeros(checkBits);
                            if (this.loopHeaders[id].active) continue;
                            if (!Options.DuplicateIrreducibleLoops.getValue(this.debug.getOptions()).booleanValue()) {
                                throw new PermanentBailoutException("Irreducible");
                            }
                            if (outermostInactiveLoopId != -1 && (this.loopHeaders[id].loops & 1L << outermostInactiveLoopId) != 0L) continue;
                            outermostInactiveLoopId = id;
                        }
                        if (outermostInactiveLoopId != -1) {
                            assert (!(step instanceof DuplicationTraversalStep));
                            successor.predecessorCount--;
                            BciBlock duplicate = successor.duplicate();
                            duplicate.predecessorCount++;
                            block.successors.set(step.currentSuccessorIndex, duplicate);
                            DuplicationTraversalStep duplicationStep = new DuplicationTraversalStep(step, duplicate, this.loopHeaders[outermostInactiveLoopId]);
                            workStack.push(duplicationStep);
                            this.debug.log("Starting duplication @ %s", duplicate);
                            this.debug.dump(4, (Object)this, "Starting duplication @ %s", duplicate);
                            duplicationStep.duplicationMap.put((Object)successor, (Object)duplicate);
                            ++this.newDuplicateBlocks;
                            duplicationStarted = true;
                        }
                    }
                    if (!duplicationStarted) {
                        this.propagateLoopBits(step, loopBits);
                        if (successor.loopIdChain == null) {
                            successor.loopIdChain = new ArrayList<TraversalStep>(2);
                        }
                        successor.loopIdChain.add(step);
                        this.debug.dump(4, (Object)this, "After re-reaching %s", successor);
                    }
                } else if (step instanceof DuplicationTraversalStep) {
                    workStack.push(new DuplicationTraversalStep((DuplicationTraversalStep)step, successor));
                } else {
                    workStack.push(new TraversalStep(step, successor));
                }
                step.currentSuccessorIndex++;
                continue;
            }
            block.active = false;
            assert (this.checkBlocks(this.blocksNotYetAssignedId, block));
            --this.blocksNotYetAssignedId;
            if (this.blocksNotYetAssignedId < 0) {
                assert (Options.DuplicateIrreducibleLoops.getValue(this.debug.getOptions()).booleanValue());
                this.duplicateBlocks += this.newDuplicateBlocks;
                if ((double)this.duplicateBlocks > (double)this.postJsrBlockCount * Options.MaxDuplicationFactor.getValue(this.debug.getOptions())) {
                    throw new PermanentBailoutException("Non-reducible loop requires too much duplication");
                }
                this.debug.log(2, "Re-numbering blocks to make room for duplicates (old length: %d; new blocks: %d)", this.blocks.length, this.newDuplicateBlocks);
                BciBlock[] newBlocks = new BciBlock[this.blocks.length + this.newDuplicateBlocks];
                for (int i = 0; i < this.blocks.length; ++i) {
                    newBlocks[i + this.newDuplicateBlocks] = this.blocks[i];
                    assert (this.blocks[i].id == -1);
                }
                this.blocksNotYetAssignedId += this.newDuplicateBlocks;
                assert (this.blocksNotYetAssignedId >= 0);
                this.newDuplicateBlocks = 0;
                this.blocks = newBlocks;
            }
            this.blocks[this.blocksNotYetAssignedId] = block;
            this.debug.log("computeBlockOrder(%s) -> %x", (Object)block, (Object)block.loops);
            this.debug.dump(4, (Object)this, "After adding %s", block);
            workStack.pop();
        }
        long loops = initialBlock.loops;
        if (initialBlock.isLoopHeader) {
            loops &= 1L << initialBlock.loopId ^ 0xFFFFFFFFFFFFFFFFL;
        }
        GraalError.guarantee(loops == 0L, "Irreducible loops should already have been detected to duplicated");
    }

    private boolean checkBlocks(int start, BciBlock inserting) {
        for (int i = 0; i < start; ++i) {
            assert (this.blocks[i] == null);
        }
        EconomicSet seen = EconomicSet.create((int)(this.blocks.length - start));
        for (int i = start; i < this.blocks.length; ++i) {
            assert (this.blocks[i] != null);
            assert (seen.add((Object)this.blocks[i]));
        }
        assert (!seen.contains((Object)inserting)) : "Trying to add " + inserting + " again";
        return true;
    }

    public static BciBlockMapping create(BytecodeStream stream, Bytecode code, OptionValues options, DebugContext debug) {
        BciBlockMapping map = new BciBlockMapping(code, debug);
        try (DebugContext.Scope scope = debug.scope((Object)"BciBlockMapping", map);){
            map.build(stream, options);
            if (debug.isDumpEnabled(2)) {
                debug.dump(2, map, code.getMethod().format("After block building %f %R %H.%n(%P)"));
            }
        }
        catch (Throwable t) {
            throw debug.handle(t);
        }
        return map;
    }

    public BciBlock[] getLoopHeaders() {
        return this.loopHeaders;
    }

    public BciBlock getStartBlock() {
        return this.startBlock;
    }

    public ExceptionDispatchBlock getUnwindBlock() {
        return (ExceptionDispatchBlock)this.blocks[this.blocks.length - 1];
    }

    public int getLoopCount() {
        return this.nextLoop;
    }

    public int getBlockCount() {
        return this.blocks.length;
    }

    @Override
    public JavaMethod asJavaMethod() {
        return this.code.getMethod();
    }

    private static final class DuplicationTraversalStep
    extends TraversalStep {
        private final BciBlock loopHeader;
        private final EconomicMap<BciBlock, BciBlock> duplicationMap;

        DuplicationTraversalStep(TraversalStep pred, BciBlock block, BciBlock loopHeader) {
            super(pred, block);
            this.loopHeader = loopHeader;
            this.duplicationMap = EconomicMap.create();
        }

        DuplicationTraversalStep(DuplicationTraversalStep pred, BciBlock block) {
            super(pred, block);
            this.loopHeader = pred.loopHeader;
            this.duplicationMap = pred.duplicationMap;
        }

        @Override
        public String toString() {
            return super.toString() + " (duplicating " + this.loopHeader + ")";
        }
    }

    private static class TraversalStep {
        private final TraversalStep pred;
        private final BciBlock block;
        private int currentSuccessorIndex;
        private long loops;

        TraversalStep(TraversalStep pred, BciBlock block) {
            this.pred = pred;
            this.block = block;
            this.currentSuccessorIndex = 0;
            this.loops = 0L;
        }

        TraversalStep(BciBlock block) {
            this(null, block);
        }

        public String toString() {
            if (this.pred == null) {
                return "TraversalStep{block=" + this.block + ", currentSuccessorIndex=" + this.currentSuccessorIndex + ", loops=" + Long.toBinaryString(this.loops) + '}';
            }
            return "TraversalStep{pred=" + this.pred + ", block=" + this.block + ", currentSuccessorIndex=" + this.currentSuccessorIndex + ", loops=" + Long.toBinaryString(this.loops) + '}';
        }
    }

    public static class ExceptionDispatchBlock
    extends BciBlock {
        public final ExceptionHandler handler;
        public final int deoptBci;

        ExceptionDispatchBlock(ExceptionHandler handler, int deoptBci) {
            super(handler.getHandlerBCI());
            this.endBci = this.startBci;
            this.deoptBci = deoptBci;
            this.handler = handler;
        }

        ExceptionDispatchBlock(int deoptBci) {
            super(deoptBci);
            this.endBci = deoptBci;
            this.deoptBci = deoptBci;
            this.handler = null;
        }

        @Override
        public boolean isExceptionDispatch() {
            return true;
        }

        @Override
        public void getDebugProperties(Map<String, ? super Object> properties) {
            super.getDebugProperties(properties);
            properties.put("deoptBci", (Object)this.deoptBci);
            if (this.handler != null) {
                properties.put("catch type", this.handler.getCatchType());
            }
        }
    }

    public static class BciBlock
    implements Cloneable {
        int id = -1;
        final int startBci;
        int endBci;
        private boolean isExceptionEntry;
        private boolean isLoopHeader;
        int loopId;
        List<BciBlock> successors;
        private int predecessorCount;
        private boolean visited;
        private boolean active;
        long loops;
        JSRData jsrData;
        List<TraversalStep> loopIdChain;
        boolean duplicate;

        BciBlock(int startBci) {
            this.startBci = startBci;
            this.successors = new ArrayList<BciBlock>();
        }

        public int getStartBci() {
            return this.startBci;
        }

        public int getEndBci() {
            return this.endBci;
        }

        public long getLoops() {
            return this.loops;
        }

        public BciBlock exceptionDispatchBlock() {
            if (this.successors.size() > 0 && this.successors.get(this.successors.size() - 1) instanceof ExceptionDispatchBlock) {
                return this.successors.get(this.successors.size() - 1);
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public int getPredecessorCount() {
            return this.predecessorCount;
        }

        public int numNormalSuccessors() {
            if (this.exceptionDispatchBlock() != null) {
                return this.successors.size() - 1;
            }
            return this.successors.size();
        }

        public BciBlock copy() {
            try {
                BciBlock block = (BciBlock)super.clone();
                if (block.jsrData != null) {
                    block.jsrData = block.jsrData.copy();
                }
                block.successors = new ArrayList<BciBlock>(this.successors);
                return block;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public BciBlock duplicate() {
            try {
                BciBlock block = (BciBlock)super.clone();
                if (block.jsrData != null) {
                    throw new PermanentBailoutException("Can not duplicate block with JSR data");
                }
                block.successors = new ArrayList<BciBlock>(this.successors);
                block.loops = 0L;
                block.loopId = 0;
                block.id = -1;
                block.isLoopHeader = false;
                block.visited = false;
                block.active = false;
                block.predecessorCount = 0;
                block.loopIdChain = null;
                block.duplicate = true;
                return block;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("B").append(this.getId());
            sb.append('[').append(this.startBci).append("..").append(this.endBci);
            if (this.isLoopHeader || this.isExceptionEntry || this instanceof ExceptionDispatchBlock) {
                sb.append(' ');
                if (this.isLoopHeader) {
                    sb.append('L');
                }
                if (this.isExceptionEntry) {
                    sb.append('!');
                } else if (this instanceof ExceptionDispatchBlock) {
                    sb.append("<!>");
                }
            }
            sb.append(']');
            if (this.duplicate) {
                sb.append(" (duplicate)");
            }
            return sb.toString();
        }

        public boolean isLoopHeader() {
            return this.isLoopHeader;
        }

        public boolean isExceptionEntry() {
            return this.isExceptionEntry;
        }

        public BciBlock getSuccessor(int index) {
            return this.successors.get(index);
        }

        public int getLoopId() {
            return this.loopId;
        }

        private JSRData getOrCreateJSRData() {
            if (this.jsrData == null) {
                this.jsrData = new JSRData();
            }
            return this.jsrData;
        }

        void setEndsWithRet() {
            this.getOrCreateJSRData().endsWithRet = true;
        }

        public JsrScope getJsrScope() {
            if (this.jsrData == null) {
                return JsrScope.EMPTY_SCOPE;
            }
            return this.jsrData.jsrScope;
        }

        public boolean endsWithRet() {
            if (this.jsrData == null) {
                return false;
            }
            return this.jsrData.endsWithRet;
        }

        void setRetSuccessor(BciBlock bciBlock) {
            this.getOrCreateJSRData().retSuccessor = bciBlock;
        }

        public BciBlock getRetSuccessor() {
            if (this.jsrData == null) {
                return null;
            }
            return this.jsrData.retSuccessor;
        }

        public BciBlock getJsrSuccessor() {
            if (this.jsrData == null) {
                return null;
            }
            return this.jsrData.jsrSuccessor;
        }

        public int getJsrReturnBci() {
            if (this.jsrData == null) {
                return -1;
            }
            return this.jsrData.jsrReturnBci;
        }

        public EconomicMap<JsrScope, BciBlock> getJsrAlternatives() {
            if (this.jsrData == null) {
                return null;
            }
            return this.jsrData.jsrAlternatives;
        }

        public void initJsrAlternatives() {
            JSRData data = this.getOrCreateJSRData();
            if (data.jsrAlternatives == null) {
                data.jsrAlternatives = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            }
        }

        void setJsrScope(JsrScope nextScope) {
            this.getOrCreateJSRData().jsrScope = nextScope;
        }

        void setJsrSuccessor(BciBlock clone) {
            this.getOrCreateJSRData().jsrSuccessor = clone;
        }

        void setJsrReturnBci(int bci) {
            this.getOrCreateJSRData().jsrReturnBci = bci;
        }

        public int getSuccessorCount() {
            return this.successors.size();
        }

        public List<BciBlock> getSuccessors() {
            return this.successors;
        }

        void setId(int i) {
            this.id = i;
        }

        public void addSuccessor(BciBlock sux) {
            this.successors.add(sux);
            ++sux.predecessorCount;
        }

        public void clearSucccessors() {
            for (BciBlock sux : this.successors) {
                --sux.predecessorCount;
            }
            this.successors.clear();
        }

        public boolean isExceptionDispatch() {
            return false;
        }

        public void getDebugProperties(Map<String, ? super Object> properties) {
            properties.put("assignedId", (Object)this.getId());
            properties.put("startBci", (Object)this.getStartBci());
            properties.put("endBci", (Object)this.getEndBci());
            properties.put("isExceptionEntry", (Object)this.isExceptionEntry());
            properties.put("isLoopHeader", (Object)this.isLoopHeader());
            properties.put("loopId", (Object)this.getLoopId());
            properties.put("loops", Long.toBinaryString(this.getLoops()));
            properties.put("predecessorCount", (Object)this.getPredecessorCount());
            properties.put("active", (Object)this.active);
            properties.put("visited", (Object)this.visited);
            properties.put("duplicate", (Object)this.duplicate);
        }

        public static class JSRData
        implements Cloneable {
            public EconomicMap<JsrScope, BciBlock> jsrAlternatives;
            public JsrScope jsrScope = JsrScope.EMPTY_SCOPE;
            public BciBlock jsrSuccessor;
            public int jsrReturnBci;
            public BciBlock retSuccessor;
            public boolean endsWithRet = false;

            public JSRData copy() {
                try {
                    return (JSRData)this.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }
        }
    }

    public static class Options {
        @Option(help={"When enabled, some limited amount of duplication will be performed in order compile code containing irreducible loops."})
        public static final OptionKey<Boolean> DuplicateIrreducibleLoops = new OptionKey<Boolean>(true);
        @Option(help={"How much duplication can happen because of irreducible loops before bailing out."}, type=OptionType.Expert)
        public static final OptionKey<Double> MaxDuplicationFactor = new OptionKey<Double>(2.0);
    }
}

