/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import java.util.ArrayList;
import java.util.BitSet;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;

public class SPARCHotSpotRegisterAllocationConfig
extends RegisterAllocationConfig {
    static final Register[] registerAllocationOrder = new Register[]{SPARC.l0, SPARC.l1, SPARC.l2, SPARC.l3, SPARC.l4, SPARC.l5, SPARC.l6, SPARC.l7, SPARC.i0, SPARC.i1, SPARC.i2, SPARC.i3, SPARC.i4, SPARC.i5, SPARC.o0, SPARC.o1, SPARC.o2, SPARC.o3, SPARC.o4, SPARC.o5, SPARC.g1, SPARC.g4, SPARC.g5, SPARC.f8, SPARC.f9, SPARC.f10, SPARC.f11, SPARC.f12, SPARC.f13, SPARC.f14, SPARC.f15, SPARC.f16, SPARC.f17, SPARC.f18, SPARC.f19, SPARC.f20, SPARC.f21, SPARC.f22, SPARC.f23, SPARC.f24, SPARC.f25, SPARC.f26, SPARC.f27, SPARC.f28, SPARC.f29, SPARC.f30, SPARC.f31, SPARC.d32, SPARC.d34, SPARC.d36, SPARC.d38, SPARC.d40, SPARC.d42, SPARC.d44, SPARC.d46, SPARC.d48, SPARC.d50, SPARC.d52, SPARC.d54, SPARC.d56, SPARC.d58, SPARC.d60, SPARC.d62};

    public SPARCHotSpotRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
        super(registerConfig, allocationRestrictedTo);
    }

    @Override
    protected RegisterArray initAllocatable(RegisterArray registers) {
        BitSet regMap = new BitSet(this.registerConfig.getAllocatableRegisters().size());
        for (Register reg : registers) {
            regMap.set(reg.number);
        }
        ArrayList<Register> allocatableRegisters = new ArrayList<Register>(registers.size());
        for (Register reg : registerAllocationOrder) {
            if (!regMap.get(reg.number)) continue;
            allocatableRegisters.add(reg);
        }
        return super.initAllocatable(new RegisterArray(allocatableRegisters));
    }
}

