/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCDelayedControlTransfer;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;
import org.graalvm.compiler.lir.sparc.SPARCMove;
import org.graalvm.compiler.lir.sparc.SPARCTailDelayedLIRInstruction;

public class SPARCHotSpotMove {

    public static final class UncompressPointer
    extends SPARCLIRInstruction {
        public static final LIRInstructionClass<UncompressPointer> TYPE = LIRInstructionClass.create(UncompressPointer.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(4);
        private final CompressEncoding encoding;
        private final boolean nonNull;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected AllocatableValue baseRegister;

        public UncompressPointer(AllocatableValue result, AllocatableValue input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull) {
            super(TYPE, SIZE);
            this.result = result;
            this.input = input;
            this.baseRegister = baseRegister;
            this.encoding = encoding;
            this.nonNull = nonNull;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            Register inputRegister = ValueUtil.asRegister((Value)this.input);
            Register resReg = ValueUtil.asRegister((Value)this.result);
            Register baseReg = this.encoding.hasBase() ? ValueUtil.asRegister((Value)this.baseRegister) : null;
            UncompressPointer.emitUncompressCode(masm, inputRegister, resReg, baseReg, this.encoding.getShift(), this.nonNull);
        }

        public static void emitUncompressCode(SPARCMacroAssembler masm, Register inputRegister, Register resReg, Register baseReg, int shift, boolean nonNull) {
            Register secondaryInput;
            if (shift != 0) {
                masm.sllx(inputRegister, shift, resReg);
                secondaryInput = resReg;
            } else {
                secondaryInput = inputRegister;
            }
            if (baseReg != null) {
                if (nonNull) {
                    masm.add(secondaryInput, baseReg, resReg);
                } else {
                    Label done = new Label();
                    SPARCAssembler.BPR.emit(masm, SPARCAssembler.RCondition.Rc_nz, SPARCAssembler.Annul.ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, secondaryInput, done);
                    masm.add(baseReg, secondaryInput, resReg);
                    masm.bind(done);
                }
            }
        }
    }

    public static final class CompressPointer
    extends SPARCLIRInstruction {
        public static final LIRInstructionClass<CompressPointer> TYPE = LIRInstructionClass.create(CompressPointer.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(5);
        private final CompressEncoding encoding;
        private final boolean nonNull;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected AllocatableValue baseRegister;

        public CompressPointer(AllocatableValue result, AllocatableValue input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull) {
            super(TYPE, SIZE);
            this.result = result;
            this.input = input;
            this.baseRegister = baseRegister;
            this.encoding = encoding;
            this.nonNull = nonNull;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            Register inputRegister = ValueUtil.asRegister((Value)this.input);
            Register resReg = ValueUtil.asRegister((Value)this.result);
            if (this.encoding.hasBase()) {
                Register baseReg = ValueUtil.asRegister((Value)this.baseRegister);
                if (!this.nonNull) {
                    Label done = new Label();
                    if (inputRegister.equals((Object)resReg)) {
                        SPARCAssembler.BPR.emit(masm, SPARCAssembler.RCondition.Rc_nz, SPARCAssembler.Annul.ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, inputRegister, done);
                        masm.sub(inputRegister, baseReg, resReg);
                        masm.bind(done);
                        if (this.encoding.getShift() != 0) {
                            masm.srlx(resReg, this.encoding.getShift(), resReg);
                        }
                    } else {
                        SPARCAssembler.BPR.emit(masm, SPARCAssembler.RCondition.Rc_z, SPARCAssembler.Annul.NOT_ANNUL, SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN, inputRegister, done);
                        masm.mov(SPARC.g0, resReg);
                        masm.sub(inputRegister, baseReg, resReg);
                        if (this.encoding.getShift() != 0) {
                            masm.srlx(resReg, this.encoding.getShift(), resReg);
                        }
                        masm.bind(done);
                    }
                } else {
                    masm.sub(inputRegister, baseReg, resReg);
                    if (this.encoding.getShift() != 0) {
                        masm.srlx(resReg, this.encoding.getShift(), resReg);
                    }
                }
            } else if (this.encoding.getShift() != 0) {
                masm.srlx(inputRegister, this.encoding.getShift(), resReg);
            }
        }
    }

    public static class LoadHotSpotObjectConstantFromTable
    extends SPARCLIRInstruction
    implements SPARCTailDelayedLIRInstruction {
        public static final LIRInstructionClass<LoadHotSpotObjectConstantFromTable> TYPE = LIRInstructionClass.create(LoadHotSpotObjectConstantFromTable.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(2, 8);
        private final HotSpotConstant constant;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        private AllocatableValue constantTableBase;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        AllocatableValue result;

        public LoadHotSpotObjectConstantFromTable(HotSpotConstant constant, AllocatableValue result, AllocatableValue constantTableBase) {
            super(TYPE, SIZE);
            this.constant = constant;
            this.result = result;
            this.constantTableBase = constantTableBase;
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            try (SPARCMacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                boolean isStack = ValueUtil.isStackSlot((Value)this.result);
                Register register = isStack ? scratch.getRegister() : ValueUtil.asRegister((Value)this.result);
                int bytes = SPARCMove.loadFromConstantTable(crb, masm, ValueUtil.asRegister((Value)this.constantTableBase), (Constant)this.constant, register, SPARCDelayedControlTransfer.DUMMY);
                if (isStack) {
                    masm.st(register, (SPARCAddress)crb.asAddress((Value)this.result), bytes);
                }
            }
        }
    }

    public static class LoadHotSpotObjectConstantInline
    extends SPARCLIRInstruction
    implements SPARCTailDelayedLIRInstruction,
    StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<LoadHotSpotObjectConstantInline> TYPE = LIRInstructionClass.create(LoadHotSpotObjectConstantInline.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(8);
        private HotSpotConstant constant;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        AllocatableValue result;

        public LoadHotSpotObjectConstantInline(HotSpotConstant constant, AllocatableValue result) {
            super(TYPE, SIZE);
            this.constant = constant;
            this.result = result;
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            crb.recordInlineDataInCode((Constant)this.constant);
            if (this.constant.isCompressed()) {
                masm.setw(0, ValueUtil.asRegister((Value)this.result), true);
            } else {
                masm.setx(0L, ValueUtil.asRegister((Value)this.result), true);
            }
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }

        @Override
        public Constant getConstant() {
            return this.constant;
        }
    }
}

