/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotHostBackend;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotEpilogueOp;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCCall;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;

@Opcode(value="DEOPT_WITH_EXCEPTION_IN_CALLER")
final class SPARCHotSpotDeoptimizeWithExceptionCallerOp
extends SPARCHotSpotEpilogueOp {
    public static final LIRInstructionClass<SPARCHotSpotDeoptimizeWithExceptionCallerOp> TYPE = LIRInstructionClass.create(SPARCHotSpotDeoptimizeWithExceptionCallerOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(32);
    private final GraalHotSpotVMConfig config;
    private final Register thread;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value exception;

    protected SPARCHotSpotDeoptimizeWithExceptionCallerOp(GraalHotSpotVMConfig config, Value exception, Register thread) {
        super((LIRInstructionClass<? extends SPARCHotSpotEpilogueOp>)TYPE, SIZE);
        this.config = config;
        this.exception = exception;
        this.thread = thread;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        Register exc = ValueUtil.asRegister((Value)this.exception);
        masm.stx(exc, new SPARCAddress(this.thread, this.config.threadExceptionOopOffset));
        masm.stx(SPARC.i7, new SPARCAddress(this.thread, this.config.threadExceptionPcOffset));
        this.leaveFrame(crb);
        try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            Register scratch = sc.getRegister();
            SPARCCall.indirectJmp(crb, masm, scratch, crb.foreignCalls.lookupForeignCall(HotSpotHostBackend.DEOPT_BLOB_UNPACK_WITH_EXCEPTION_IN_TLS));
        }
    }
}

