/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements.profiling;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.aot.LoadMethodCountersNode;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileBranchNode;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileInvokeNode;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.word.MethodCountersPointer;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public class ProfileSnippets
implements Snippets {
    public static final LocationIdentity METHOD_COUNTERS = NamedLocationIdentity.mutable("MethodCounters");

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void methodInvocationEvent(@Node.ConstantNodeParameter ForeignCallDescriptor var0, MethodCountersPointer var1);

    @Snippet
    protected static int notificationMask(int freqLog, int stepLog) {
        int stepMask = (1 << stepLog) - 1;
        int frequencyMask = (1 << freqLog) - 1;
        return frequencyMask & ~stepMask;
    }

    @Snippet
    public static void profileMethodEntry(MethodCountersPointer counters, int step, int stepLog, @Snippet.ConstantParameter int freqLog) {
        int mask;
        int counterValue = counters.readInt(HotSpotReplacementsUtil.invocationCounterOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), METHOD_COUNTERS) + HotSpotReplacementsUtil.invocationCounterIncrement(GraalHotSpotVMConfig.INJECTED_VMCONFIG) * step;
        counters.writeIntSideEffectFree(HotSpotReplacementsUtil.invocationCounterOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), counterValue, METHOD_COUNTERS);
        if (freqLog >= 0 && BranchProbabilityNode.probability(0.010000000000000009, (counterValue & (mask = ProfileSnippets.notificationMask(freqLog, stepLog)) << HotSpotReplacementsUtil.invocationCounterShift(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) == 0)) {
            ProfileSnippets.methodInvocationEvent(HotSpotBackend.INVOCATION_EVENT, counters);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void methodBackedgeEvent(@Node.ConstantNodeParameter ForeignCallDescriptor var0, MethodCountersPointer var1, int var2, int var3);

    @Snippet
    public static void profileBackedge(MethodCountersPointer counters, int step, int stepLog, @Snippet.ConstantParameter int freqLog, int bci, int targetBci) {
        int counterValue = counters.readInt(HotSpotReplacementsUtil.backedgeCounterOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), METHOD_COUNTERS) + HotSpotReplacementsUtil.invocationCounterIncrement(GraalHotSpotVMConfig.INJECTED_VMCONFIG) * step;
        counters.writeIntSideEffectFree(HotSpotReplacementsUtil.backedgeCounterOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), counterValue, METHOD_COUNTERS);
        int mask = ProfileSnippets.notificationMask(freqLog, stepLog);
        if (BranchProbabilityNode.probability(0.010000000000000009, (counterValue & mask << HotSpotReplacementsUtil.invocationCounterShift(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) == 0)) {
            ProfileSnippets.methodBackedgeEvent(HotSpotBackend.BACKEDGE_EVENT, counters, bci, targetBci);
        }
    }

    @Snippet
    public static void profileConditionalBackedge(MethodCountersPointer counters, int step, int stepLog, @Snippet.ConstantParameter int freqLog, boolean branchCondition, int bci, int targetBci) {
        if (branchCondition) {
            ProfileSnippets.profileBackedge(counters, step, stepLog, freqLog, bci, targetBci);
        }
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo profileMethodEntry = this.snippet(ProfileSnippets.class, "profileMethodEntry", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo profileBackedge = this.snippet(ProfileSnippets.class, "profileBackedge", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo profileConditionalBackedge = this.snippet(ProfileSnippets.class, "profileConditionalBackedge", new LocationIdentity[0]);

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, TargetDescription target) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
        }

        public void lower(ProfileNode profileNode, LoweringTool tool) {
            StructuredGraph graph = profileNode.graph();
            LoadMethodCountersNode counters = graph.unique(new LoadMethodCountersNode(profileNode.getProfiledMethod()));
            ConstantNode step = ConstantNode.forInt(profileNode.getStep(), graph);
            ConstantNode stepLog = ConstantNode.forInt(CodeUtil.log2((int)profileNode.getStep()), graph);
            if (profileNode instanceof ProfileBranchNode) {
                ProfileBranchNode profileBranchNode = (ProfileBranchNode)profileNode;
                SnippetTemplate.SnippetInfo snippet = profileBranchNode.hasCondition() ? this.profileConditionalBackedge : this.profileBackedge;
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, graph.getGuardsStage(), tool.getLoweringStage());
                ConstantNode bci = ConstantNode.forInt(profileBranchNode.bci(), graph);
                ConstantNode targetBci = ConstantNode.forInt(profileBranchNode.targetBci(), graph);
                args.add("counters", counters);
                args.add("step", step);
                args.add("stepLog", stepLog);
                args.addConst("freqLog", profileBranchNode.getNotificationFreqLog());
                if (profileBranchNode.hasCondition()) {
                    args.add("branchCondition", profileBranchNode.branchCondition());
                }
                args.add("bci", bci);
                args.add("targetBci", targetBci);
                SnippetTemplate template = this.template(profileNode, args);
                template.instantiate(this.providers.getMetaAccess(), profileNode, SnippetTemplate.DEFAULT_REPLACER, args);
            } else if (profileNode instanceof ProfileInvokeNode) {
                ProfileInvokeNode profileInvokeNode = (ProfileInvokeNode)profileNode;
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.profileMethodEntry, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("counters", counters);
                args.add("step", step);
                args.add("stepLog", stepLog);
                args.addConst("freqLog", profileInvokeNode.getNotificationFreqLog());
                SnippetTemplate template = this.template(profileNode, args);
                template.instantiate(this.providers.getMetaAccess(), profileNode, SnippetTemplate.DEFAULT_REPLACER, args);
            } else {
                throw new GraalError("Unsupported profile node type: " + profileNode);
            }
            assert (profileNode.hasNoUsages());
            if (!profileNode.isDeleted()) {
                GraphUtil.killWithUnusedFloatingInputs(profileNode);
            }
        }
    }
}

