/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptBciSupplier;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public class IdentityHashCodeNode
extends AbstractStateSplit
implements Canonicalizable,
Lowerable,
SingleMemoryKill,
DeoptBciSupplier {
    public static final NodeClass<IdentityHashCodeNode> TYPE = NodeClass.create(IdentityHashCodeNode.class);
    @Node.Input
    ValueNode object;
    private int bci;

    public IdentityHashCodeNode(ValueNode object, int bci) {
        super((NodeClass<? extends AbstractStateSplit>)TYPE, (Stamp)StampFactory.forInteger(32));
        this.object = object;
        this.bci = bci;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return HotSpotReplacementsUtil.MARK_WORD_LOCATION;
    }

    public ValueNode object() {
        return this.object;
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public void setBci(int bci) {
        this.bci = bci;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.object.isConstant()) {
            assert (this.object.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp);
            JavaConstant c = (JavaConstant)this.object.asConstant();
            if (GraalOptions.ImmutableCode.getValue(tool.getOptions()).booleanValue()) {
                return this;
            }
            PrimitiveConstant identityHashCode = null;
            identityHashCode = c.isNull() ? JavaConstant.forInt((int)0) : JavaConstant.forInt((int)((HotSpotObjectConstant)c).getIdentityHashCode());
            return new ConstantNode((Constant)identityHashCode, StampFactory.forConstant((JavaConstant)identityHashCode));
        }
        return this;
    }
}

