/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.nodes.GraalHotSpotVMConfigNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotCompressionNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.Log;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ReferentFieldReadBarrier;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.gc.G1WriteBarrierSnippets;
import org.graalvm.compiler.replacements.gc.WriteBarrierSnippets;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public final class HotSpotG1WriteBarrierSnippets
extends G1WriteBarrierSnippets {
    public static final HotSpotForeignCallDescriptor G1WBPRECALL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "write_barrier_pre", Void.TYPE, Object.class);
    public static final HotSpotForeignCallDescriptor G1WBPOSTCALL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "write_barrier_post", Void.TYPE, Word.class);
    public static final HotSpotForeignCallDescriptor VALIDATE_OBJECT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "validate_object", Boolean.TYPE, Word.class, Word.class);
    private final Register threadRegister;

    public HotSpotG1WriteBarrierSnippets(HotSpotRegistersProvider registers) {
        this.threadRegister = registers.getThreadRegister();
    }

    @Override
    protected Word getThread() {
        return HotSpotReplacementsUtil.registerAsWord(this.threadRegister);
    }

    @Override
    protected int wordSize() {
        return HotSpotReplacementsUtil.wordSize();
    }

    @Override
    protected int objectArrayIndexScale() {
        return ReplacementsUtil.arrayIndexScale(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Object);
    }

    @Override
    protected int satbQueueMarkingOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueMarkingOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected int satbQueueBufferOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueBufferOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected int satbQueueIndexOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueIndexOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected int cardQueueBufferOffset() {
        return HotSpotReplacementsUtil.g1CardQueueBufferOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected int cardQueueIndexOffset() {
        return HotSpotReplacementsUtil.g1CardQueueIndexOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected byte dirtyCardValue() {
        return HotSpotReplacementsUtil.dirtyCardValue(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected byte youngCardValue() {
        return HotSpotReplacementsUtil.g1YoungCardValue(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected Word cardTableAddress(Pointer oop) {
        Word cardTable = (Word)WordFactory.unsigned((long)GraalHotSpotVMConfigNode.cardTableAddress());
        int cardTableShift = HotSpotReplacementsUtil.cardTableShift(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        return cardTable.add(oop.unsignedShiftRight(cardTableShift));
    }

    @Override
    protected int logOfHeapRegionGrainBytes() {
        return GraalHotSpotVMConfigNode.logOfHeapRegionGrainBytes();
    }

    @Override
    protected ForeignCallDescriptor preWriteBarrierCallDescriptor() {
        return G1WBPRECALL;
    }

    @Override
    protected ForeignCallDescriptor postWriteBarrierCallDescriptor() {
        return G1WBPOSTCALL;
    }

    @Override
    protected boolean verifyOops() {
        return HotSpotReplacementsUtil.verifyOops(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected boolean verifyBarrier() {
        return ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED || HotSpotReplacementsUtil.verifyBeforeOrAfterGC(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected long gcTotalCollectionsAddress() {
        return HotSpotReplacementsUtil.gcTotalCollectionsAddress(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected ForeignCallDescriptor verifyOopCallDescriptor() {
        return HotSpotForeignCallsProviderImpl.VERIFY_OOP;
    }

    @Override
    protected ForeignCallDescriptor validateObjectCallDescriptor() {
        return VALIDATE_OBJECT;
    }

    @Override
    protected ForeignCallDescriptor printfCallDescriptor() {
        return Log.LOG_PRINTF;
    }

    @Override
    protected ResolvedJavaType referenceType() {
        return HotSpotReplacementsUtil.referenceType(GraalHotSpotVMConfig.INJECTED_METAACCESS);
    }

    @Override
    protected long referentOffset() {
        return HotSpotReplacementsUtil.referentOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS);
    }

    static final class HotspotG1WriteBarrierLowerer
    extends G1WriteBarrierSnippets.G1WriteBarrierLowerer {
        private final CompressEncoding oopEncoding;

        HotspotG1WriteBarrierLowerer(GraalHotSpotVMConfig config, SnippetCounter.Group.Factory factory) {
            super(factory);
            this.oopEncoding = config.useCompressedOops ? config.getOopEncoding() : null;
        }

        @Override
        public ValueNode uncompress(ValueNode expected) {
            assert (this.oopEncoding != null);
            return HotSpotCompressionNode.uncompress(expected, this.oopEncoding);
        }
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo g1PreWriteBarrier;
        private final SnippetTemplate.SnippetInfo g1ReferentReadBarrier;
        private final SnippetTemplate.SnippetInfo g1PostWriteBarrier;
        private final SnippetTemplate.SnippetInfo g1ArrayRangePreWriteBarrier;
        private final SnippetTemplate.SnippetInfo g1ArrayRangePostWriteBarrier;
        private final G1WriteBarrierSnippets.G1WriteBarrierLowerer lowerer;

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, SnippetCounter.Group.Factory factory, HotSpotProviders providers, TargetDescription target, GraalHotSpotVMConfig config) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
            this.lowerer = new HotspotG1WriteBarrierLowerer(config, factory);
            HotSpotG1WriteBarrierSnippets receiver = new HotSpotG1WriteBarrierSnippets(providers.getRegisters());
            this.g1PreWriteBarrier = this.snippet(G1WriteBarrierSnippets.class, "g1PreWriteBarrier", null, receiver, G1WriteBarrierSnippets.GC_INDEX_LOCATION, G1WriteBarrierSnippets.GC_LOG_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_MARKING_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_BUFFER_LOCATION);
            this.g1ReferentReadBarrier = this.snippet(G1WriteBarrierSnippets.class, "g1ReferentReadBarrier", null, receiver, G1WriteBarrierSnippets.GC_INDEX_LOCATION, G1WriteBarrierSnippets.GC_LOG_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_MARKING_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_BUFFER_LOCATION);
            this.g1PostWriteBarrier = this.snippet(G1WriteBarrierSnippets.class, "g1PostWriteBarrier", null, receiver, WriteBarrierSnippets.GC_CARD_LOCATION, G1WriteBarrierSnippets.GC_INDEX_LOCATION, G1WriteBarrierSnippets.GC_LOG_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_BUFFER_LOCATION);
            this.g1ArrayRangePreWriteBarrier = this.snippet(G1WriteBarrierSnippets.class, "g1ArrayRangePreWriteBarrier", null, receiver, G1WriteBarrierSnippets.GC_INDEX_LOCATION, G1WriteBarrierSnippets.GC_LOG_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_MARKING_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_BUFFER_LOCATION);
            this.g1ArrayRangePostWriteBarrier = this.snippet(G1WriteBarrierSnippets.class, "g1ArrayRangePostWriteBarrier", null, receiver, WriteBarrierSnippets.GC_CARD_LOCATION, G1WriteBarrierSnippets.GC_INDEX_LOCATION, G1WriteBarrierSnippets.GC_LOG_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_BUFFER_LOCATION);
        }

        public void lower(G1PreWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1PreWriteBarrier, barrier, tool);
        }

        public void lower(G1ReferentFieldReadBarrier barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1ReferentReadBarrier, barrier, tool);
        }

        public void lower(G1PostWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1PostWriteBarrier, barrier, tool);
        }

        public void lower(G1ArrayRangePreWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1ArrayRangePreWriteBarrier, barrier, tool);
        }

        public void lower(G1ArrayRangePostWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1ArrayRangePostWriteBarrier, barrier, tool);
        }
    }
}

