/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.replacements.ClassGetHubNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.HubGetClassNode;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;

@ClassSubstitution(value=Class.class)
public class HotSpotClassSubstitutions {
    @MethodSubstitution(isStatic=false)
    public static int getModifiers(Class<?> thisObj) {
        KlassPointer klass = ClassGetHubNode.readClass(thisObj);
        if (klass.isNull()) {
            return 1041;
        }
        return klass.readInt(HotSpotReplacementsUtil.klassModifierFlagsOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_MODIFIER_FLAGS_LOCATION);
    }

    @MethodSubstitution(isStatic=false)
    public static boolean isInterface(Class<?> thisObj) {
        KlassPointer klass = ClassGetHubNode.readClass(thisObj);
        if (klass.isNull()) {
            return false;
        }
        int accessFlags = klass.readInt(HotSpotReplacementsUtil.klassAccessFlagsOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_ACCESS_FLAGS_LOCATION);
        return (accessFlags & 0x200) != 0;
    }

    @MethodSubstitution(isStatic=false, optional=true)
    public static boolean isHidden(Class<?> thisObj) {
        KlassPointer klass = ClassGetHubNode.readClass(thisObj);
        if (klass.isNull()) {
            return false;
        }
        int accessFlags = klass.readInt(HotSpotReplacementsUtil.klassAccessFlagsOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_ACCESS_FLAGS_LOCATION);
        return (accessFlags & HotSpotReplacementsUtil.jvmAccIsHiddenClass(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) != 0;
    }

    @MethodSubstitution(isStatic=false)
    public static boolean isArray(Class<?> thisObj) {
        KlassPointer klass = ClassGetHubNode.readClass(thisObj);
        if (klass.isNull()) {
            return false;
        }
        KlassPointer klassNonNull = ClassGetHubNode.piCastNonNull(klass, SnippetAnchorNode.anchor());
        return HotSpotReplacementsUtil.klassIsArray(klassNonNull);
    }

    @Fold
    public static ResolvedJavaType getObjectType(@Fold.InjectedParameter MetaAccessProvider metaAccesss) {
        return metaAccesss.lookupJavaType(Object.class);
    }

    @MethodSubstitution(isStatic=false)
    public static Class<?> getSuperclass(Class<?> thisObj) {
        KlassPointer klassNonNull;
        int accessFlags;
        KlassPointer klass = ClassGetHubNode.readClass(thisObj);
        if (!klass.isNull() && ((accessFlags = (klassNonNull = ClassGetHubNode.piCastNonNull(klass, SnippetAnchorNode.anchor())).readInt(HotSpotReplacementsUtil.klassAccessFlagsOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_ACCESS_FLAGS_LOCATION)) & 0x200) == 0) {
            if (HotSpotReplacementsUtil.klassIsArray(klassNonNull)) {
                return ConstantNode.forClass(HotSpotClassSubstitutions.getObjectType(GraalHotSpotVMConfig.INJECTED_METAACCESS));
            }
            KlassPointer superKlass = klassNonNull.readKlassPointer(HotSpotReplacementsUtil.klassSuperKlassOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_SUPER_KLASS_LOCATION);
            if (superKlass.isNull()) {
                return null;
            }
            KlassPointer superKlassNonNull = ClassGetHubNode.piCastNonNull(superKlass, SnippetAnchorNode.anchor());
            return HubGetClassNode.readClass(superKlassNonNull);
        }
        return null;
    }

    @MethodSubstitution(isStatic=false)
    public static Class<?> getComponentType(Class<?> thisObj) {
        KlassPointer klassNonNull;
        KlassPointer klass = ClassGetHubNode.readClass(thisObj);
        if (!klass.isNull() && HotSpotReplacementsUtil.klassIsArray(klassNonNull = ClassGetHubNode.piCastNonNull(klass, SnippetAnchorNode.anchor()))) {
            return PiNode.asNonNullClass(klassNonNull.readObject(HotSpotReplacementsUtil.arrayKlassComponentMirrorOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.ARRAY_KLASS_COMPONENT_MIRROR));
        }
        return null;
    }
}

