/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.aot;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.nodes.DeoptimizingStubCall;
import org.graalvm.compiler.hotspot.nodes.type.MethodCountersPointerStamp;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.hotspot.word.MethodCountersPointer;
import org.graalvm.compiler.hotspot.word.MethodPointer;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.word.Word;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public class ResolveMethodAndLoadCountersStubCall
extends DeoptimizingStubCall
implements Canonicalizable,
LIRLowerable {
    public static final NodeClass<ResolveMethodAndLoadCountersStubCall> TYPE = NodeClass.create(ResolveMethodAndLoadCountersStubCall.class);
    @Node.OptionalInput
    protected ValueNode method;
    @Node.Input
    protected ValueNode klassHint;
    @Node.Input
    protected ValueNode methodDescription;
    protected Constant methodConstant;

    public ResolveMethodAndLoadCountersStubCall(ValueNode method, ValueNode klassHint, ValueNode methodDescription) {
        super((NodeClass<? extends DeoptimizingStubCall>)TYPE, (Stamp)MethodCountersPointerStamp.methodCountersNonNull());
        this.klassHint = klassHint;
        this.method = method;
        this.methodDescription = methodDescription;
    }

    @Node.NodeIntrinsic
    public static native MethodCountersPointer resolveMethodAndLoadCounters(MethodPointer var0, KlassPointer var1, Word var2);

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.method != null) {
            this.methodConstant = GraphUtil.foldIfConstantAndRemove(this, this.method);
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.methodConstant != null) : "Expected method to fold: " + this.method;
        Value methodDescriptionValue = gen.operand(this.methodDescription);
        Value klassHintValue = gen.operand(this.klassHint);
        LIRFrameState fs = gen.state(this);
        assert (fs != null) : "The stateAfter is null";
        Value result = ((HotSpotLIRGenerator)gen.getLIRGeneratorTool()).emitResolveMethodAndLoadCounters(this.methodConstant, klassHintValue, methodDescriptionValue, fs);
        gen.setResult(this, result);
    }
}

