/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
@Node.NodeIntrinsicFactory
public class GraalHotSpotVMConfigNode
extends FloatingNode
implements LIRLowerable,
Canonicalizable {
    public static final NodeClass<GraalHotSpotVMConfigNode> TYPE = NodeClass.create(GraalHotSpotVMConfigNode.class);
    private final GraalHotSpotVMConfig config;
    protected final HotSpotMarkId markId;

    public GraalHotSpotVMConfigNode(@Node.InjectedNodeParameter Stamp stamp, @Node.InjectedNodeParameter GraalHotSpotVMConfig config, HotSpotMarkId markId) {
        super((NodeClass<? extends FloatingNode>)TYPE, stamp);
        this.config = config;
        this.markId = markId;
    }

    public GraalHotSpotVMConfigNode(GraalHotSpotVMConfig config, HotSpotMarkId markId, JavaKind kind) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forKind(kind));
        this.config = config;
        this.markId = markId;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        Value res = ((HotSpotLIRGenerator)generator.getLIRGeneratorTool()).emitLoadConfigValue(this.markId, generator.getLIRGeneratorTool().getLIRKind(this.stamp));
        generator.setResult(this, res);
    }

    @Node.NodeIntrinsic
    private static native long loadLongConfigValue(@Node.ConstantNodeParameter HotSpotMarkId var0);

    @Node.NodeIntrinsic
    private static native int loadIntConfigValue(@Node.ConstantNodeParameter HotSpotMarkId var0);

    public static long cardTableAddress() {
        return GraalHotSpotVMConfigNode.loadLongConfigValue(HotSpotMarkId.CARD_TABLE_ADDRESS);
    }

    public static long crcTableAddress() {
        return GraalHotSpotVMConfigNode.loadLongConfigValue(HotSpotMarkId.CRC_TABLE_ADDRESS);
    }

    public static int logOfHeapRegionGrainBytes() {
        return GraalHotSpotVMConfigNode.loadIntConfigValue(HotSpotMarkId.LOG_OF_HEAP_REGION_GRAIN_BYTES);
    }

    public static boolean intrinsify(GraphBuilderContext b, @Node.InjectedNodeParameter Stamp returnStamp, @Node.InjectedNodeParameter GraalHotSpotVMConfig config, HotSpotMarkId mark) {
        if (b.getReplacements().isEncodingSnippets()) {
            return false;
        }
        b.addPush(returnStamp.getStackKind(), new GraalHotSpotVMConfigNode(returnStamp, config, mark));
        return true;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        Boolean generatePIC = GraalOptions.GeneratePIC.getValue(tool.getOptions());
        if (this.markId == null) {
            return ConstantNode.forBoolean(generatePIC == false);
        }
        if (!generatePIC.booleanValue()) {
            if (this.markId == HotSpotMarkId.CARD_TABLE_ADDRESS) {
                return ConstantNode.forLong(this.config.cardtableStartAddress);
            }
            if (this.markId == HotSpotMarkId.CRC_TABLE_ADDRESS) {
                return ConstantNode.forLong(this.config.crcTableAddress);
            }
            if (this.markId == HotSpotMarkId.LOG_OF_HEAP_REGION_GRAIN_BYTES) {
                return ConstantNode.forInt(this.config.logOfHRGrainBytes);
            }
            throw GraalError.shouldNotReachHere(this.markId.toString());
        }
        return this;
    }
}

