/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.function.Supplier;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotCompilationIdentifier;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.TypePlugin;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.util.ConstantFoldUtil;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.compiler.word.WordOperationPlugin;
import org.graalvm.word.LocationIdentity;
import sun.misc.Unsafe;

public final class HotSpotNodePlugin
implements NodePlugin,
TypePlugin {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    protected final WordOperationPlugin wordOperationPlugin;
    private final GraalHotSpotVMConfig config;
    private final HotSpotWordTypes wordTypes;
    private static final LocationIdentity JAVA_THREAD_SHOULD_POST_ON_EXCEPTIONS_FLAG_LOCATION = NamedLocationIdentity.mutable("JavaThread::_should_post_on_exceptions_flag");

    public HotSpotNodePlugin(WordOperationPlugin wordOperationPlugin, GraalHotSpotVMConfig config, HotSpotWordTypes wordTypes) {
        this.wordOperationPlugin = wordOperationPlugin;
        this.config = config;
        this.wordTypes = wordTypes;
    }

    @Override
    public boolean canChangeStackKind(GraphBuilderContext b) {
        if (b.parsingIntrinsic()) {
            return this.wordOperationPlugin.canChangeStackKind(b);
        }
        return false;
    }

    @Override
    public StampPair interceptType(GraphBuilderTool b, JavaType declaredType, boolean nonNull) {
        if (b.parsingIntrinsic()) {
            return this.wordOperationPlugin.interceptType(b, declaredType, nonNull);
        }
        return null;
    }

    @Override
    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        return b.parsingIntrinsic() && this.wordOperationPlugin.handleInvoke(b, method, args);
    }

    @Override
    public boolean handleLoadField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field) {
        JavaConstant asJavaConstant;
        if ((!GraalOptions.ImmutableCode.getValue(b.getOptions()).booleanValue() || b.parsingIntrinsic()) && object.isConstant() && HotSpotNodePlugin.tryReadField(b, field, asJavaConstant = object.asJavaConstant())) {
            return true;
        }
        return b.parsingIntrinsic() && this.wordOperationPlugin.handleLoadField(b, object, field);
    }

    @Override
    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField field) {
        if ((!GraalOptions.ImmutableCode.getValue(b.getOptions()).booleanValue() || b.parsingIntrinsic()) && HotSpotNodePlugin.tryReadField(b, field, null)) {
            return true;
        }
        return b.parsingIntrinsic() && this.wordOperationPlugin.handleLoadStaticField(b, field);
    }

    private static boolean tryReadField(GraphBuilderContext b, ResolvedJavaField field, JavaConstant object) {
        return HotSpotNodePlugin.tryConstantFold(b, field, object);
    }

    private static boolean tryConstantFold(GraphBuilderContext b, ResolvedJavaField field, JavaConstant object) {
        ConstantNode result = ConstantFoldUtil.tryConstantFold(b.getConstantFieldProvider(), b.getConstantReflection(), b.getMetaAccess(), field, object, b.getOptions());
        if (result != null) {
            result = b.getGraph().unique(result);
            b.push(field.getJavaKind(), result);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleStoreField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field, ValueNode value) {
        return b.parsingIntrinsic() && this.wordOperationPlugin.handleStoreField(b, object, field, value);
    }

    @Override
    public boolean handleStoreStaticField(GraphBuilderContext b, ResolvedJavaField field, ValueNode value) {
        return b.parsingIntrinsic() && this.wordOperationPlugin.handleStoreStaticField(b, field, value);
    }

    @Override
    public boolean handleLoadIndexed(GraphBuilderContext b, ValueNode array, ValueNode index, GuardingNode boundsCheck, JavaKind elementKind) {
        return b.parsingIntrinsic() && this.wordOperationPlugin.handleLoadIndexed(b, array, index, boundsCheck, elementKind);
    }

    @Override
    public boolean handleStoreIndexed(GraphBuilderContext b, ValueNode array, ValueNode index, GuardingNode boundsCheck, GuardingNode storeCheck, JavaKind elementKind, ValueNode value) {
        return b.parsingIntrinsic() && this.wordOperationPlugin.handleStoreIndexed(b, array, index, boundsCheck, storeCheck, elementKind, value);
    }

    @Override
    public boolean handleCheckCast(GraphBuilderContext b, ValueNode object, ResolvedJavaType type, JavaTypeProfile profile) {
        return b.parsingIntrinsic() && this.wordOperationPlugin.handleCheckCast(b, object, type, profile);
    }

    @Override
    public boolean handleInstanceOf(GraphBuilderContext b, ValueNode object, ResolvedJavaType type, JavaTypeProfile profile) {
        return b.parsingIntrinsic() && this.wordOperationPlugin.handleInstanceOf(b, object, type, profile);
    }

    @Override
    public FixedWithNextNode instrumentExceptionDispatch(StructuredGraph graph, FixedWithNextNode afterExceptionLoaded, Supplier<FrameState> frameStateFunction) {
        CompilationIdentifier id = graph.compilationId();
        if (id instanceof HotSpotCompilationIdentifier && this.config.jvmciCompileStateCanPostOnExceptionsOffset != Integer.MIN_VALUE && this.config.javaThreadShouldPostOnExceptionsFlagOffset != Integer.MIN_VALUE) {
            long compileState;
            boolean canPostOnExceptions = Options.HotSpotPostOnExceptions.getValue(graph.getOptions());
            HotSpotCompilationRequest request = ((HotSpotCompilationIdentifier)id).getRequest();
            if (request != null && (compileState = request.getJvmciEnv()) != 0L) {
                long canPostOnExceptionsOffset = compileState + (long)this.config.jvmciCompileStateCanPostOnExceptionsOffset;
                boolean bl = canPostOnExceptions = UNSAFE.getByte(canPostOnExceptionsOffset) != 0;
            }
            if (canPostOnExceptions) {
                CurrentJavaThreadNode thread = graph.unique(new CurrentJavaThreadNode(this.wordTypes.getWordKind()));
                ValueNode offset = graph.unique(ConstantNode.forLong(this.config.javaThreadShouldPostOnExceptionsFlagOffset));
                AddressNode address = graph.unique(new OffsetAddressNode(thread, offset));
                ReadNode shouldPostException = graph.add(new ReadNode(address, JAVA_THREAD_SHOULD_POST_ON_EXCEPTIONS_FLAG_LOCATION, StampFactory.intValue(), OnHeapMemoryAccess.BarrierType.NONE));
                afterExceptionLoaded.setNext(shouldPostException);
                ValueNode zero = graph.unique(ConstantNode.forInt(0));
                LogicNode cond = graph.unique(new IntegerEqualsNode(shouldPostException, zero));
                FixedGuardNode check = graph.add(new FixedGuardNode(cond, DeoptimizationReason.TransferToInterpreter, DeoptimizationAction.None, false));
                FrameState fs = frameStateFunction.get();
                assert (fs.stackSize() == 1 && fs.rethrowException()) : "expected rethrow exception FrameState";
                check.setStateBefore(fs);
                shouldPostException.setNext(check);
                return check;
            }
        }
        return afterExceptionLoaded;
    }

    public static class Options {
        @Option(help={"Testing only option that forces deopts for exception throws"}, type=OptionType.Expert)
        public static final OptionKey<Boolean> HotSpotPostOnExceptions = new OptionKey<Boolean>(false);
    }
}

