/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.EnumMap;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.nodes.BeginLockScopeNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotCompressionNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotDirectCallTargetNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotIndirectCallTargetNode;
import org.graalvm.compiler.hotspot.nodes.KlassBeingInitializedCheckNode;
import org.graalvm.compiler.hotspot.nodes.aot.InitializeKlassNode;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveConstantNode;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveDynamicConstantNode;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveMethodAndLoadCountersNode;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileNode;
import org.graalvm.compiler.hotspot.nodes.type.HotSpotNarrowOopStamp;
import org.graalvm.compiler.hotspot.nodes.type.KlassPointerStamp;
import org.graalvm.compiler.hotspot.nodes.type.MethodPointerStamp;
import org.graalvm.compiler.hotspot.replacements.AssertionSnippets;
import org.graalvm.compiler.hotspot.replacements.ClassGetHubNode;
import org.graalvm.compiler.hotspot.replacements.FastNotifyNode;
import org.graalvm.compiler.hotspot.replacements.HashCodeSnippets;
import org.graalvm.compiler.hotspot.replacements.HotSpotAllocationSnippets;
import org.graalvm.compiler.hotspot.replacements.HotSpotG1WriteBarrierSnippets;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.HotSpotSerialWriteBarrierSnippets;
import org.graalvm.compiler.hotspot.replacements.HubGetClassNode;
import org.graalvm.compiler.hotspot.replacements.IdentityHashCodeNode;
import org.graalvm.compiler.hotspot.replacements.InstanceOfSnippets;
import org.graalvm.compiler.hotspot.replacements.KlassLayoutHelperNode;
import org.graalvm.compiler.hotspot.replacements.LoadExceptionObjectSnippets;
import org.graalvm.compiler.hotspot.replacements.MonitorSnippets;
import org.graalvm.compiler.hotspot.replacements.ObjectCloneSnippets;
import org.graalvm.compiler.hotspot.replacements.ObjectSnippets;
import org.graalvm.compiler.hotspot.replacements.StringToBytesSnippets;
import org.graalvm.compiler.hotspot.replacements.UnsafeCopyMemoryNode;
import org.graalvm.compiler.hotspot.replacements.UnsafeSnippets;
import org.graalvm.compiler.hotspot.replacements.aot.ResolveConstantSnippets;
import org.graalvm.compiler.hotspot.replacements.arraycopy.HotSpotArraycopySnippets;
import org.graalvm.compiler.hotspot.replacements.profiling.ProfileSnippets;
import org.graalvm.compiler.hotspot.stubs.ForeignCallSnippets;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractDeoptimizeNode;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.GetObjectAddressNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.IntegerDivRemNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.RemNode;
import org.graalvm.compiler.nodes.debug.StringToBytesNode;
import org.graalvm.compiler.nodes.debug.VerifyHeapNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.LoadMethodNode;
import org.graalvm.compiler.nodes.extended.OSRLocalNode;
import org.graalvm.compiler.nodes.extended.OSRLockNode;
import org.graalvm.compiler.nodes.extended.OSRMonitorEnterNode;
import org.graalvm.compiler.nodes.extended.OSRStartNode;
import org.graalvm.compiler.nodes.extended.StoreHubNode;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ReferentFieldReadBarrier;
import org.graalvm.compiler.nodes.gc.SerialArrayRangeWriteBarrier;
import org.graalvm.compiler.nodes.gc.SerialWriteBarrier;
import org.graalvm.compiler.nodes.java.ClassIsAssignableFromNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadExceptionObjectNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.DefaultJavaLoweringProvider;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyNode;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopySnippets;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyWithDelayedLoweringNode;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.word.LocationIdentity;

public abstract class DefaultHotSpotLoweringProvider
extends DefaultJavaLoweringProvider
implements HotSpotLoweringProvider {
    protected final HotSpotGraalRuntimeProvider runtime;
    protected final HotSpotRegistersProvider registers;
    protected final HotSpotConstantReflectionProvider constantReflection;
    protected InstanceOfSnippets.Templates instanceofSnippets;
    protected HotSpotAllocationSnippets.Templates allocationSnippets;
    protected MonitorSnippets.Templates monitorSnippets;
    protected HotSpotSerialWriteBarrierSnippets.Templates serialWriteBarrierSnippets;
    protected HotSpotG1WriteBarrierSnippets.Templates g1WriteBarrierSnippets;
    protected LoadExceptionObjectSnippets.Templates exceptionObjectSnippets;
    protected AssertionSnippets.Templates assertionSnippets;
    protected ArrayCopySnippets.Templates arraycopySnippets;
    protected StringToBytesSnippets.Templates stringToBytesSnippets;
    protected HashCodeSnippets.Templates hashCodeSnippets;
    protected ResolveConstantSnippets.Templates resolveConstantSnippets;
    protected ProfileSnippets.Templates profileSnippets;
    protected ObjectSnippets.Templates objectSnippets;
    protected UnsafeSnippets.Templates unsafeSnippets;
    protected ObjectCloneSnippets.Templates objectCloneSnippets;
    protected ForeignCallSnippets.Templates foreignCallSnippets;

    public DefaultHotSpotLoweringProvider(HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, HotSpotRegistersProvider registers, HotSpotConstantReflectionProvider constantReflection, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        super(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, target, runtime.getVMConfig().useCompressedOops);
        this.runtime = runtime;
        this.registers = registers;
        this.constantReflection = constantReflection;
    }

    @Override
    public void initialize(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, GraalHotSpotVMConfig config) {
        super.initialize(options, factories, this.runtime, providers, providers.getSnippetReflection());
        assert (this.target == providers.getCodeCache().getTarget());
        this.instanceofSnippets = new InstanceOfSnippets.Templates(options, factories, this.runtime, providers, this.target);
        this.allocationSnippets = new HotSpotAllocationSnippets.Templates(options, factories, this.runtime, providers, this.target, config);
        this.monitorSnippets = new MonitorSnippets.Templates(options, factories, this.runtime, providers, this.target, config.useFastLocking);
        this.g1WriteBarrierSnippets = new HotSpotG1WriteBarrierSnippets.Templates(options, factories, this.runtime, providers, this.target, config);
        this.serialWriteBarrierSnippets = new HotSpotSerialWriteBarrierSnippets.Templates(options, factories, this.runtime, providers, this.target);
        this.exceptionObjectSnippets = new LoadExceptionObjectSnippets.Templates(options, factories, providers, this.target);
        this.assertionSnippets = new AssertionSnippets.Templates(options, factories, providers, this.target);
        this.arraycopySnippets = new ArrayCopySnippets.Templates(new HotSpotArraycopySnippets(), options, factories, this.runtime, providers, providers.getSnippetReflection(), this.target);
        this.stringToBytesSnippets = new StringToBytesSnippets.Templates(options, factories, providers, this.target);
        this.hashCodeSnippets = new HashCodeSnippets.Templates(options, factories, providers, this.target);
        this.resolveConstantSnippets = new ResolveConstantSnippets.Templates(options, factories, providers, this.target);
        this.objectCloneSnippets = new ObjectCloneSnippets.Templates(options, factories, providers, this.target);
        this.foreignCallSnippets = new ForeignCallSnippets.Templates(options, factories, providers, this.target);
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            this.objectSnippets = new ObjectSnippets.Templates(options, factories, providers, this.target);
        }
        this.unsafeSnippets = new UnsafeSnippets.Templates(options, factories, providers, this.target);
        if (JavaVersionUtil.JAVA_SPEC >= 11 && GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
            this.profileSnippets = new ProfileSnippets.Templates(options, factories, providers, this.target);
        }
    }

    public ArrayCopySnippets.Templates getArraycopySnippets() {
        return this.arraycopySnippets;
    }

    public MonitorSnippets.Templates getMonitorSnippets() {
        return this.monitorSnippets;
    }

    @Override
    public void lower(Node n, LoweringTool tool) {
        StructuredGraph graph = (StructuredGraph)n.graph();
        try (DebugCloseable context = n.withNodeSourcePosition();){
            if (n instanceof Invoke) {
                this.lowerInvoke((Invoke)((Object)n), tool, graph);
            } else if (n instanceof LoadMethodNode) {
                this.lowerLoadMethodNode((LoadMethodNode)n);
            } else if (n instanceof GetClassNode) {
                DefaultHotSpotLoweringProvider.lowerGetClassNode((GetClassNode)n, tool, graph);
            } else if (n instanceof StoreHubNode) {
                this.lowerStoreHubNode((StoreHubNode)n, graph);
            } else if (n instanceof OSRStartNode) {
                this.lowerOSRStartNode((OSRStartNode)n);
            } else if (n instanceof BytecodeExceptionNode) {
                this.lowerBytecodeExceptionNode((BytecodeExceptionNode)n);
            } else if (n instanceof InstanceOfNode) {
                InstanceOfNode instanceOfNode = (InstanceOfNode)n;
                if (graph.getGuardsStage().areDeoptsFixed()) {
                    this.instanceofSnippets.lower(instanceOfNode, tool);
                } else if (instanceOfNode.allowsNull()) {
                    ValueNode object = instanceOfNode.getValue();
                    LogicNode newTypeCheck = graph.addOrUniqueWithInputs(InstanceOfNode.create(instanceOfNode.type(), object, instanceOfNode.profile(), instanceOfNode.getAnchor()));
                    LogicNode newNode = LogicNode.or(graph.unique(IsNullNode.create(object)), newTypeCheck, 0.25);
                    instanceOfNode.replaceAndDelete(newNode);
                }
            } else if (n instanceof InstanceOfDynamicNode) {
                InstanceOfDynamicNode instanceOfDynamicNode = (InstanceOfDynamicNode)n;
                if (graph.getGuardsStage().areDeoptsFixed()) {
                    this.instanceofSnippets.lower(instanceOfDynamicNode, tool);
                } else {
                    ValueNode mirror = instanceOfDynamicNode.getMirrorOrHub();
                    if (mirror.stamp(NodeView.DEFAULT).getStackKind() == JavaKind.Object) {
                        ClassGetHubNode classGetHub = graph.unique(new ClassGetHubNode(mirror));
                        instanceOfDynamicNode.setMirror(classGetHub);
                    }
                    if (instanceOfDynamicNode.allowsNull()) {
                        ValueNode object = instanceOfDynamicNode.getObject();
                        LogicNode newTypeCheck = graph.addOrUniqueWithInputs(InstanceOfDynamicNode.create(graph.getAssumptions(), tool.getConstantReflection(), instanceOfDynamicNode.getMirrorOrHub(), object, false, instanceOfDynamicNode.isExact()));
                        LogicNode newNode = LogicNode.or(graph.unique(IsNullNode.create(object)), newTypeCheck, 0.25);
                        instanceOfDynamicNode.replaceAndDelete(newNode);
                    }
                }
            } else if (n instanceof ClassIsAssignableFromNode) {
                if (graph.getGuardsStage().areDeoptsFixed()) {
                    this.instanceofSnippets.lower((ClassIsAssignableFromNode)n, tool);
                }
            } else if (n instanceof NewInstanceNode) {
                if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                    this.allocationSnippets.lower((NewInstanceNode)n, tool);
                }
            } else if (n instanceof DynamicNewInstanceNode) {
                DynamicNewInstanceNode newInstanceNode = (DynamicNewInstanceNode)n;
                if (newInstanceNode.getClassClass() == null) {
                    JavaConstant classClassMirror = this.constantReflection.asJavaClass(this.metaAccess.lookupJavaType(Class.class));
                    ConstantNode classClass = ConstantNode.forConstant(classClassMirror, tool.getMetaAccess(), graph);
                    newInstanceNode.setClassClass(classClass);
                }
                if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                    this.allocationSnippets.lower(newInstanceNode, tool);
                }
            } else if (n instanceof NewArrayNode) {
                if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                    this.allocationSnippets.lower((NewArrayNode)n, tool);
                }
            } else if (n instanceof DynamicNewArrayNode) {
                DynamicNewArrayNode dynamicNewArrayNode = (DynamicNewArrayNode)n;
                if (dynamicNewArrayNode.getVoidClass() == null) {
                    JavaConstant voidClassMirror = this.constantReflection.asJavaClass(this.metaAccess.lookupJavaType(Void.TYPE));
                    ConstantNode voidClass = ConstantNode.forConstant(voidClassMirror, tool.getMetaAccess(), graph);
                    dynamicNewArrayNode.setVoidClass(voidClass);
                }
                if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                    this.allocationSnippets.lower(dynamicNewArrayNode, tool);
                }
            } else if (n instanceof VerifyHeapNode) {
                if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                    this.allocationSnippets.lower((VerifyHeapNode)n, tool);
                }
            } else if (n instanceof MonitorEnterNode) {
                if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                    this.monitorSnippets.lower((MonitorEnterNode)n, this.registers, tool);
                } else {
                    this.loadHubForMonitorEnterNode((MonitorEnterNode)n, tool, graph);
                }
            } else if (n instanceof MonitorExitNode) {
                if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                    this.monitorSnippets.lower((MonitorExitNode)n, this.registers, tool);
                }
            } else if (n instanceof ArrayCopyNode) {
                this.arraycopySnippets.lower((ArrayCopyNode)n, tool);
            } else if (n instanceof ArrayCopyWithDelayedLoweringNode) {
                this.arraycopySnippets.lower((ArrayCopyWithDelayedLoweringNode)n, tool);
            } else if (n instanceof G1PreWriteBarrier) {
                this.g1WriteBarrierSnippets.lower((G1PreWriteBarrier)n, tool);
            } else if (n instanceof G1PostWriteBarrier) {
                this.g1WriteBarrierSnippets.lower((G1PostWriteBarrier)n, tool);
            } else if (n instanceof G1ReferentFieldReadBarrier) {
                this.g1WriteBarrierSnippets.lower((G1ReferentFieldReadBarrier)n, tool);
            } else if (n instanceof SerialWriteBarrier) {
                this.serialWriteBarrierSnippets.lower((SerialWriteBarrier)n, tool);
            } else if (n instanceof SerialArrayRangeWriteBarrier) {
                this.serialWriteBarrierSnippets.lower((SerialArrayRangeWriteBarrier)n, tool);
            } else if (n instanceof G1ArrayRangePreWriteBarrier) {
                this.g1WriteBarrierSnippets.lower((G1ArrayRangePreWriteBarrier)n, tool);
            } else if (n instanceof G1ArrayRangePostWriteBarrier) {
                this.g1WriteBarrierSnippets.lower((G1ArrayRangePostWriteBarrier)n, tool);
            } else if (n instanceof NewMultiArrayNode) {
                if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                    this.allocationSnippets.lower((NewMultiArrayNode)n, tool);
                }
            } else if (n instanceof LoadExceptionObjectNode) {
                this.exceptionObjectSnippets.lower((LoadExceptionObjectNode)n, this.registers, tool);
            } else if (n instanceof AssertionNode) {
                this.assertionSnippets.lower((AssertionNode)n, tool);
            } else if (n instanceof StringToBytesNode) {
                if (graph.getGuardsStage().areDeoptsFixed()) {
                    this.stringToBytesSnippets.lower((StringToBytesNode)n, tool);
                }
            } else if (n instanceof IntegerDivRemNode) {
            } else if (!(n instanceof AbstractDeoptimizeNode || n instanceof UnwindNode || n instanceof RemNode)) {
                if (n instanceof SafepointNode) {
                } else if (n instanceof ClassGetHubNode) {
                    this.lowerClassGetHubNode((ClassGetHubNode)n, tool);
                } else if (n instanceof HubGetClassNode) {
                    this.lowerHubGetClassNode((HubGetClassNode)n, tool);
                } else if (n instanceof KlassLayoutHelperNode) {
                    this.lowerKlassLayoutHelperNode((KlassLayoutHelperNode)n, tool);
                } else if (n instanceof ComputeObjectAddressNode) {
                    if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                        DefaultHotSpotLoweringProvider.lowerComputeObjectAddressNode((ComputeObjectAddressNode)n);
                    }
                } else if (n instanceof IdentityHashCodeNode) {
                    this.hashCodeSnippets.lower((IdentityHashCodeNode)n, tool);
                } else if (n instanceof ResolveDynamicConstantNode) {
                    if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                        this.resolveConstantSnippets.lower((ResolveDynamicConstantNode)n, tool);
                    }
                } else if (n instanceof ResolveConstantNode) {
                    if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                        this.resolveConstantSnippets.lower((ResolveConstantNode)n, tool);
                    }
                } else if (n instanceof ResolveMethodAndLoadCountersNode) {
                    if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                        this.resolveConstantSnippets.lower((ResolveMethodAndLoadCountersNode)n, tool);
                    }
                } else if (n instanceof InitializeKlassNode) {
                    if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                        this.resolveConstantSnippets.lower((InitializeKlassNode)n, tool);
                    }
                } else if (n instanceof ProfileNode) {
                    this.profileSnippets.lower((ProfileNode)n, tool);
                } else if (n instanceof KlassBeingInitializedCheckNode) {
                    this.allocationSnippets.lower((KlassBeingInitializedCheckNode)n, tool);
                } else if (n instanceof FastNotifyNode) {
                    if (JavaVersionUtil.JAVA_SPEC < 11) {
                        throw GraalError.shouldNotReachHere("FastNotify is not support prior to 11");
                    }
                    if (graph.getGuardsStage() == StructuredGraph.GuardsStage.AFTER_FSA) {
                        this.objectSnippets.lower(n, tool);
                    }
                } else if (n instanceof UnsafeCopyMemoryNode) {
                    if (graph.getGuardsStage() == StructuredGraph.GuardsStage.AFTER_FSA) {
                        this.unsafeSnippets.lower((UnsafeCopyMemoryNode)n, tool);
                    }
                } else {
                    super.lower(n, tool);
                }
            }
        }
    }

    protected void loadHubForMonitorEnterNode(MonitorEnterNode monitor, LoweringTool tool, StructuredGraph graph) {
        if (monitor.getObjectData() == null) {
            ValueNode objectNonNull = this.createNullCheckedValue(monitor.object(), monitor, tool);
            monitor.setObject(objectNonNull);
            monitor.setObjectData(graph.addOrUnique(LoadHubNode.create(objectNonNull, tool.getStampProvider(), tool.getMetaAccess(), tool.getConstantReflection())));
        }
    }

    private static void lowerComputeObjectAddressNode(ComputeObjectAddressNode n) {
        for (Node use : n.usages().snapshot()) {
            if (use instanceof FixedNode) {
                FixedNode fixed = (FixedNode)use;
                StructuredGraph graph = n.graph();
                GetObjectAddressNode address = graph.add(new GetObjectAddressNode(n.getObject()));
                graph.addBeforeFixed(fixed, address);
                AddNode add = graph.addOrUnique(new AddNode(address, n.getOffset()));
                use.replaceFirstInput(n, add);
                continue;
            }
            throw GraalError.shouldNotReachHere("Unexpected floating use of ComputeObjectAddressNode " + n);
        }
        GraphUtil.unlinkFixedNode(n);
        n.safeDelete();
    }

    private void lowerKlassLayoutHelperNode(KlassLayoutHelperNode n, LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
            return;
        }
        StructuredGraph graph = n.graph();
        assert (!n.getHub().isConstant());
        AddressNode address = this.createOffsetAddress(graph, n.getHub(), this.runtime.getVMConfig().klassLayoutHelperOffset);
        n.replaceAtUsagesAndDelete(graph.unique(new FloatingReadNode(address, HotSpotReplacementsUtil.KLASS_LAYOUT_HELPER_LOCATION, null, n.stamp(NodeView.DEFAULT), null, OnHeapMemoryAccess.BarrierType.NONE)));
    }

    private void lowerHubGetClassNode(HubGetClassNode n, LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
            return;
        }
        ValueNode hub = n.getHub();
        GraalHotSpotVMConfig vmConfig = this.runtime.getVMConfig();
        StructuredGraph graph = n.graph();
        assert (!hub.isConstant() || GraalOptions.ImmutableCode.getValue(graph.getOptions()).booleanValue());
        AddressNode mirrorAddress = this.createOffsetAddress(graph, hub, vmConfig.classMirrorOffset);
        FloatingReadNode read = graph.unique(new FloatingReadNode(mirrorAddress, HotSpotReplacementsUtil.CLASS_MIRROR_LOCATION, null, vmConfig.classMirrorIsHandle ? StampFactory.forKind(this.target.wordJavaKind) : n.stamp(NodeView.DEFAULT), null, OnHeapMemoryAccess.BarrierType.NONE));
        if (vmConfig.classMirrorIsHandle) {
            AddressNode address = this.createOffsetAddress(graph, read, 0L);
            read = graph.unique(new FloatingReadNode(address, HotSpotReplacementsUtil.CLASS_MIRROR_HANDLE_LOCATION, null, n.stamp(NodeView.DEFAULT), null, OnHeapMemoryAccess.BarrierType.NONE));
        }
        n.replaceAtUsagesAndDelete(read);
    }

    private void lowerClassGetHubNode(ClassGetHubNode n, LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
            return;
        }
        StructuredGraph graph = n.graph();
        assert (!n.getValue().isConstant());
        AddressNode address = this.createOffsetAddress(graph, n.getValue(), this.runtime.getVMConfig().klassOffset);
        FloatingReadNode read = graph.unique(new FloatingReadNode(address, HotSpotReplacementsUtil.CLASS_KLASS_LOCATION, null, n.stamp(NodeView.DEFAULT), null, OnHeapMemoryAccess.BarrierType.NONE));
        n.replaceAtUsagesAndDelete(read);
    }

    private void lowerInvoke(Invoke invoke, LoweringTool tool, StructuredGraph graph) {
        if (invoke.callTarget() instanceof MethodCallTargetNode) {
            ResolvedJavaType receiverType;
            HotSpotResolvedJavaMethod hsMethod;
            ValueNode receiver;
            MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
            NodeInputList<ValueNode> parameters = callTarget.arguments();
            ValueNode valueNode = receiver = parameters.isEmpty() ? null : (ValueNode)parameters.get(0);
            if (!callTarget.isStatic()) {
                assert (receiver != null) : "non-static call must have a receiver";
                if (receiver.stamp(NodeView.DEFAULT) instanceof ObjectStamp && !StampTool.isPointerNonNull(receiver)) {
                    ValueNode nonNullReceiver = this.createNullCheckedValue(receiver, invoke.asNode(), tool);
                    parameters.set(0, (Object)nonNullReceiver);
                    receiver = nonNullReceiver;
                }
            }
            JavaType[] signature = callTarget.targetMethod().getSignature().toParameterTypes(callTarget.isStatic() ? null : callTarget.targetMethod().getDeclaringClass());
            LoweredCallTargetNode loweredCallTarget = null;
            OptionValues options = graph.getOptions();
            if (GraalOptions.InlineVTableStubs.getValue(options).booleanValue() && callTarget.invokeKind().isIndirect() && (GraalOptions.AlwaysInlineVTableStubs.getValue(options).booleanValue() || invoke.isPolymorphic()) && (hsMethod = (HotSpotResolvedJavaMethod)callTarget.targetMethod()).isInVirtualMethodTable(receiverType = invoke.getReceiverType())) {
                JavaKind wordKind = this.runtime.getTarget().wordJavaKind;
                ValueNode hub = this.createReadHub(graph, receiver, tool);
                ReadNode metaspaceMethod = this.createReadVirtualMethod(graph, hub, hsMethod, receiverType);
                int methodCompiledEntryOffset = this.runtime.getVMConfig().methodCompiledEntryOffset;
                AddressNode address = this.createOffsetAddress(graph, metaspaceMethod, methodCompiledEntryOffset);
                ReadNode compiledEntry = graph.add(new ReadNode(address, LocationIdentity.any(), StampFactory.forKind(wordKind), OnHeapMemoryAccess.BarrierType.NONE));
                loweredCallTarget = graph.add(new HotSpotIndirectCallTargetNode(metaspaceMethod, (ValueNode)compiledEntry, parameters.toArray((A[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, callTarget.targetMethod(), (CallingConvention.Type)HotSpotCallingConventionType.JavaCall, callTarget.invokeKind()));
                graph.addBeforeFixed(invoke.asNode(), metaspaceMethod);
                graph.addAfterFixed(metaspaceMethod, compiledEntry);
            }
            if (loweredCallTarget == null) {
                loweredCallTarget = graph.add(new HotSpotDirectCallTargetNode(parameters.toArray((A[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, callTarget.targetMethod(), (CallingConvention.Type)HotSpotCallingConventionType.JavaCall, callTarget.invokeKind()));
            }
            callTarget.replaceAndDelete(loweredCallTarget);
        }
    }

    private CompressEncoding getOopEncoding() {
        return this.runtime.getVMConfig().getOopEncoding();
    }

    @Override
    protected Stamp loadCompressedStamp(ObjectStamp stamp) {
        return HotSpotNarrowOopStamp.compressed(stamp, this.getOopEncoding());
    }

    @Override
    protected ValueNode newCompressionNode(CompressionNode.CompressionOp op, ValueNode value) {
        return new HotSpotCompressionNode(op, value, this.getOopEncoding());
    }

    @Override
    public ValueNode staticFieldBase(StructuredGraph graph, ResolvedJavaField f) {
        HotSpotResolvedJavaField field = (HotSpotResolvedJavaField)f;
        JavaConstant base = this.constantReflection.asJavaClass(field.getDeclaringClass());
        return ConstantNode.forConstant(base, this.metaAccess, graph);
    }

    @Override
    protected ValueNode createReadArrayComponentHub(StructuredGraph graph, ValueNode arrayHub, FixedNode anchor) {
        AddressNode address = this.createOffsetAddress(graph, arrayHub, this.runtime.getVMConfig().arrayClassElementOffset);
        return graph.unique(new FloatingReadNode(address, HotSpotReplacementsUtil.OBJ_ARRAY_KLASS_ELEMENT_KLASS_LOCATION, null, KlassPointerStamp.klassNonNull(), AbstractBeginNode.prevBegin(anchor)));
    }

    private void lowerLoadMethodNode(LoadMethodNode loadMethodNode) {
        StructuredGraph graph = loadMethodNode.graph();
        HotSpotResolvedJavaMethod method = (HotSpotResolvedJavaMethod)loadMethodNode.getMethod();
        ReadNode metaspaceMethod = this.createReadVirtualMethod(graph, loadMethodNode.getHub(), method, loadMethodNode.getReceiverType());
        graph.replaceFixed(loadMethodNode, metaspaceMethod);
    }

    private static void lowerGetClassNode(GetClassNode getClass, LoweringTool tool, StructuredGraph graph) {
        StampProvider stampProvider = tool.getStampProvider();
        LoadHubNode hub = graph.unique(new LoadHubNode(stampProvider, getClass.getObject()));
        HubGetClassNode hubGetClass = graph.unique(new HubGetClassNode(tool.getMetaAccess(), hub));
        getClass.replaceAtUsagesAndDelete(hubGetClass);
        hub.lower(tool);
        hubGetClass.lower(tool);
    }

    private void lowerStoreHubNode(StoreHubNode storeHub, StructuredGraph graph) {
        WriteNode hub = this.createWriteHub(graph, storeHub.getObject(), storeHub.getValue());
        hub.setStateAfter(storeHub.stateAfter());
        graph.replaceFixed(storeHub, hub);
    }

    private void lowerOSRStartNode(OSRStartNode osrStart) {
        StructuredGraph graph = osrStart.graph();
        if (graph.getGuardsStage() == StructuredGraph.GuardsStage.FIXED_DEOPTS) {
            StartNode newStart = graph.add(new StartNode());
            ParameterNode buffer = graph.addWithoutUnique(new ParameterNode(0, StampPair.createSingle(StampFactory.forKind(this.runtime.getTarget().wordJavaKind))));
            ForeignCallNode migrationEnd = graph.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotForeignCallsProviderImpl.OSR_MIGRATION_END, buffer));
            migrationEnd.setStateAfter(osrStart.stateAfter());
            newStart.setNext(migrationEnd);
            FixedNode next = osrStart.next();
            osrStart.setNext(null);
            migrationEnd.setNext(next);
            graph.setStart(newStart);
            int wordSize = this.target.wordSize;
            int localsOffset = (graph.method().getMaxLocals() - 1) * wordSize;
            for (OSRLocalNode osrLocal : graph.getNodes(OSRLocalNode.TYPE)) {
                int size = osrLocal.getStackKind().getSlotCount();
                int offset = localsOffset - (osrLocal.index() + size - 1) * wordSize;
                AddressNode address = this.createOffsetAddress(graph, buffer, offset);
                ReadNode load = graph.add(new ReadNode(address, LocationIdentity.any(), osrLocal.stamp(NodeView.DEFAULT), OnHeapMemoryAccess.BarrierType.NONE));
                osrLocal.replaceAndDelete(load);
                graph.addBeforeFixed(migrationEnd, load);
            }
            int lockCount = osrStart.stateAfter().locksSize();
            int locksOffset = (graph.method().getMaxLocals() + lockCount * 2 - 1) * wordSize;
            for (OSRMonitorEnterNode osrMonitorEnter : graph.getNodes(OSRMonitorEnterNode.TYPE)) {
                MonitorIdNode monitorID = osrMonitorEnter.getMonitorId();
                OSRLockNode lock = (OSRLockNode)osrMonitorEnter.object();
                int index = lock.index();
                int offsetDisplacedHeader = locksOffset - (index * 2 + 1) * wordSize;
                int offsetLockObject = locksOffset - index * 2 * wordSize;
                AddressNode addressDisplacedHeader = this.createOffsetAddress(graph, buffer, offsetDisplacedHeader);
                ReadNode loadDisplacedHeader = graph.add(new ReadNode(addressDisplacedHeader, LocationIdentity.any(), lock.stamp(NodeView.DEFAULT), OnHeapMemoryAccess.BarrierType.NONE));
                graph.addBeforeFixed(migrationEnd, loadDisplacedHeader);
                BeginLockScopeNode beginLockScope = graph.add(new BeginLockScopeNode(lock.getStackKind(), monitorID.getLockDepth()));
                graph.addBeforeFixed(migrationEnd, beginLockScope);
                AddressNode addressDisplacedMark = this.createOffsetAddress(graph, beginLockScope, this.runtime.getVMConfig().basicLockDisplacedHeaderOffset);
                WriteNode writeStackSlot = graph.add(new WriteNode(addressDisplacedMark, HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION, loadDisplacedHeader, OnHeapMemoryAccess.BarrierType.NONE));
                graph.addBeforeFixed(migrationEnd, writeStackSlot);
                AddressNode addressLockObject = this.createOffsetAddress(graph, buffer, offsetLockObject);
                ReadNode loadObject = graph.add(new ReadNode(addressLockObject, LocationIdentity.any(), lock.stamp(NodeView.DEFAULT), OnHeapMemoryAccess.BarrierType.NONE));
                lock.replaceAndDelete(loadObject);
                graph.addBeforeFixed(migrationEnd, loadObject);
            }
            osrStart.replaceAtUsagesAndDelete(newStart);
        }
    }

    private void throwCachedException(BytecodeExceptionNode node) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            throw new InternalError("Can't throw exception from SVM object");
        }
        Throwable exception = Exceptions.cachedExceptions.get((Object)node.getExceptionKind());
        assert (exception != null);
        StructuredGraph graph = node.graph();
        ConstantNode exceptionNode = ConstantNode.forConstant(this.constantReflection.forObject((Object)exception), this.metaAccess, graph);
        graph.replaceFixedWithFloating(node, exceptionNode);
    }

    private void lowerBytecodeExceptionNode(BytecodeExceptionNode node) {
        if (GraalOptions.OmitHotExceptionStacktrace.getValue(node.getOptions()).booleanValue()) {
            this.throwCachedException(node);
            return;
        }
        ForeignCallDescriptor descriptor = this.foreignCalls.getDescriptor(RuntimeCalls.runtimeCalls.get((Object)node.getExceptionKind()));
        assert (descriptor != null);
        StructuredGraph graph = node.graph();
        ForeignCallNode foreignCallNode = graph.add(new ForeignCallNode(descriptor, node.stamp(NodeView.DEFAULT), node.getArguments()));
        foreignCallNode.setStateDuring(node.createStateDuring());
        foreignCallNode.setStateAfter(node.stateAfter());
        graph.replaceFixedWithFixed(node, foreignCallNode);
    }

    private ReadNode createReadVirtualMethod(StructuredGraph graph, ValueNode hub, HotSpotResolvedJavaMethod method, ResolvedJavaType receiverType) {
        return this.createReadVirtualMethod(graph, hub, method.vtableEntryOffset(receiverType));
    }

    private ReadNode createReadVirtualMethod(StructuredGraph graph, ValueNode hub, int vtableEntryOffset) {
        assert (vtableEntryOffset > 0);
        MethodPointerStamp methodStamp = MethodPointerStamp.methodNonNull();
        AddressNode address = this.createOffsetAddress(graph, hub, vtableEntryOffset);
        ReadNode metaspaceMethod = graph.add(new ReadNode(address, LocationIdentity.any(), methodStamp, OnHeapMemoryAccess.BarrierType.NONE));
        return metaspaceMethod;
    }

    @Override
    protected ValueNode createReadHub(StructuredGraph graph, ValueNode object, LoweringTool tool) {
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return graph.unique(new LoadHubNode(tool.getStampProvider(), object));
        }
        assert (!object.isConstant() || object.isNullConstant());
        KlassPointerStamp hubStamp = KlassPointerStamp.klassNonNull();
        if (this.runtime.getVMConfig().useCompressedClassPointers) {
            hubStamp = hubStamp.compressed(this.runtime.getVMConfig().getKlassEncoding());
        }
        AddressNode address = this.createOffsetAddress(graph, object, this.runtime.getVMConfig().hubOffset);
        LocationIdentity hubLocation = this.runtime.getVMConfig().useCompressedClassPointers ? HotSpotReplacementsUtil.COMPRESSED_HUB_LOCATION : HotSpotReplacementsUtil.HUB_LOCATION;
        FloatingReadNode memoryRead = graph.unique(new FloatingReadNode(address, hubLocation, null, (Stamp)hubStamp, null, OnHeapMemoryAccess.BarrierType.NONE));
        if (this.runtime.getVMConfig().useCompressedClassPointers) {
            return HotSpotCompressionNode.uncompress(memoryRead, this.runtime.getVMConfig().getKlassEncoding());
        }
        return memoryRead;
    }

    private WriteNode createWriteHub(StructuredGraph graph, ValueNode object, ValueNode value) {
        assert (!object.isConstant() || object.asConstant().isDefaultForKind());
        ValueNode writeValue = value;
        if (this.runtime.getVMConfig().useCompressedClassPointers) {
            writeValue = HotSpotCompressionNode.compress(value, this.runtime.getVMConfig().getKlassEncoding());
        }
        AddressNode address = this.createOffsetAddress(graph, object, this.runtime.getVMConfig().hubOffset);
        return graph.add(new WriteNode(address, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, writeValue, OnHeapMemoryAccess.BarrierType.NONE));
    }

    @Override
    public int fieldOffset(ResolvedJavaField f) {
        return f.getOffset();
    }

    @Override
    public int arrayLengthOffset() {
        return this.runtime.getVMConfig().arrayOopDescLengthOffset();
    }

    @Override
    public ObjectCloneSnippets.Templates getObjectCloneSnippets() {
        return this.objectCloneSnippets;
    }

    @Override
    public ForeignCallSnippets.Templates getForeignCallSnippets() {
        return this.foreignCallSnippets;
    }

    public static final class RuntimeCalls {
        public static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallSignature> runtimeCalls = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);

        static {
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, new ForeignCallSignature("createArrayStoreException", ArrayStoreException.class, Object.class));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, new ForeignCallSignature("createClassCastException", ClassCastException.class, Object.class, KlassPointer.class));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, new ForeignCallSignature("createNullPointerException", NullPointerException.class, new Class[0]));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, new ForeignCallSignature("createOutOfBoundsException", ArrayIndexOutOfBoundsException.class, Integer.TYPE, Integer.TYPE));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, new ForeignCallSignature("createDivisionByZeroException", ArithmeticException.class, new Class[0]));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW, new ForeignCallSignature("createIntegerExactOverflowException", ArithmeticException.class, new Class[0]));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW, new ForeignCallSignature("createLongExactOverflowException", ArithmeticException.class, new Class[0]));
        }
    }

    static final class Exceptions {
        protected static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, RuntimeException> cachedExceptions = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);

        Exceptions() {
        }

        private static RuntimeException clearStackTrace(RuntimeException ex) {
            ex.setStackTrace(new StackTraceElement[0]);
            return ex;
        }

        static {
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, Exceptions.clearStackTrace(new NullPointerException()));
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, Exceptions.clearStackTrace(new ArrayIndexOutOfBoundsException()));
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, Exceptions.clearStackTrace(new ClassCastException()));
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, Exceptions.clearStackTrace(new ArrayStoreException()));
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, Exceptions.clearStackTrace(new ArithmeticException()));
        }
    }
}

