/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import java.util.ArrayList;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaAccessProvider;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.runtime.JVMCIBackend;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotBackendFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotReplacementsImpl;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotAddressLowering;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotBackend;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotSuitesCreator;
import org.graalvm.compiler.hotspot.meta.AddressLoweringHotSpotSuitesProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotGraalConstantFieldProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotGraphBuilderPlugins;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotMetaAccessExtensionProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotPlatformConfigurationProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegisters;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotSnippetReflectionProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotStampProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotSuitesProvider;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.AddressLoweringPhase;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.replacements.amd64.AMD64GraphBuilderPlugins;
import org.graalvm.compiler.replacements.classfile.ClassfileBytecodeProvider;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.serviceprovider.ServiceProvider;
import org.graalvm.compiler.word.WordTypes;

@ServiceProvider(value=HotSpotBackendFactory.class)
public class AMD64HotSpotBackendFactory
extends HotSpotBackendFactory {
    @Override
    public String getName() {
        return "community";
    }

    @Override
    public Class<? extends Architecture> getArchitecture() {
        return AMD64.class;
    }

    @Override
    public HotSpotBackend createBackend(HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, HotSpotJVMCIRuntime jvmciRuntime, HotSpotBackend host) {
        HotSpotProviders providers;
        assert (host == null);
        OptionValues options = graalRuntime.getOptions();
        JVMCIBackend jvmci = jvmciRuntime.getHostJVMCIBackend();
        GraalHotSpotVMConfig config = graalRuntime.getVMConfig();
        HotSpotCodeCacheProvider codeCache = (HotSpotCodeCacheProvider)jvmci.getCodeCache();
        TargetDescription target = codeCache.getTarget();
        HotSpotMetaAccessProvider metaAccess = (HotSpotMetaAccessProvider)jvmci.getMetaAccess();
        HotSpotConstantReflectionProvider constantReflection = (HotSpotConstantReflectionProvider)jvmci.getConstantReflection();
        HotSpotGraalConstantFieldProvider constantFieldProvider = new HotSpotGraalConstantFieldProvider(config, (MetaAccessProvider)metaAccess);
        try (InitTimer t = InitTimer.timer((String)"create providers");){
            HotSpotSuitesProvider suites;
            GraphBuilderConfiguration.Plugins plugins;
            HotSpotReplacementsImpl replacements;
            ClassfileBytecodeProvider bytecodeProvider;
            HotSpotSnippetReflectionProvider snippetReflection;
            HotSpotLoweringProvider lowerer;
            HotSpotStampProvider stampProvider;
            HotSpotMetaAccessExtensionProvider metaAccessExtensionProvider;
            HotSpotPlatformConfigurationProvider platformConfigurationProvider;
            AMD64HotSpotForeignCallsProvider foreignCalls;
            HotSpotWordTypes wordTypes;
            Value[] nativeABICallerSaveRegisters;
            HotSpotRegistersProvider registers;
            try (InitTimer rt = InitTimer.timer((String)"create HotSpotRegisters provider");){
                registers = this.createRegisters();
            }
            rt = InitTimer.timer((String)"create NativeABICallerSaveRegisters");
            var30_19 = null;
            try {
                nativeABICallerSaveRegisters = this.createNativeABICallerSaveRegisters(config, codeCache.getRegisterConfig());
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create WordTypes");
            var30_19 = null;
            try {
                wordTypes = this.createWordTypes(metaAccess, target);
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create ForeignCalls provider");
            var30_19 = null;
            try {
                foreignCalls = this.createForeignCalls(jvmciRuntime, graalRuntime, metaAccess, codeCache, wordTypes, nativeABICallerSaveRegisters);
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create platform configuration provider");
            var30_19 = null;
            try {
                platformConfigurationProvider = this.createConfigInfoProvider(config, (MetaAccessProvider)metaAccess);
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create MetaAccessExtensionProvider");
            var30_19 = null;
            try {
                metaAccessExtensionProvider = this.createMetaAccessExtensionProvider();
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create stamp provider");
            var30_19 = null;
            try {
                stampProvider = this.createStampProvider();
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create Lowerer provider");
            var30_19 = null;
            try {
                lowerer = this.createLowerer(graalRuntime, metaAccess, foreignCalls, registers, constantReflection, platformConfigurationProvider, metaAccessExtensionProvider, target);
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            HotSpotProviders p = new HotSpotProviders((MetaAccessProvider)metaAccess, (CodeCacheProvider)codeCache, (ConstantReflectionProvider)constantReflection, constantFieldProvider, foreignCalls, lowerer, null, stampProvider, platformConfigurationProvider, metaAccessExtensionProvider);
            try (InitTimer rt = InitTimer.timer((String)"create SnippetReflection provider");){
                snippetReflection = this.createSnippetReflection(graalRuntime, constantReflection, wordTypes);
            }
            rt = InitTimer.timer((String)"create Bytecode provider");
            var31_26 = null;
            try {
                bytecodeProvider = this.createBytecodeProvider(metaAccess, snippetReflection);
            }
            catch (Throwable throwable) {
                var31_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create Replacements provider");
            var31_26 = null;
            try {
                replacements = this.createReplacements(target, p, snippetReflection, bytecodeProvider);
            }
            catch (Throwable throwable) {
                var31_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create GraphBuilderPhase plugins");
            var31_26 = null;
            try {
                plugins = this.createGraphBuilderPlugins(graalRuntime, compilerConfiguration, config, target, constantReflection, foreignCalls, metaAccess, snippetReflection, replacements, wordTypes, options);
                replacements.setGraphBuilderPlugins(plugins);
            }
            catch (Throwable throwable) {
                var31_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create Suites provider");
            var31_26 = null;
            try {
                suites = this.createSuites(config, graalRuntime, compilerConfiguration, plugins, registers, replacements, options);
            }
            catch (Throwable throwable) {
                var31_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            providers = new HotSpotProviders((MetaAccessProvider)metaAccess, codeCache, (ConstantReflectionProvider)constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, suites, registers, snippetReflection, wordTypes, plugins, platformConfigurationProvider, metaAccessExtensionProvider, config);
            replacements.setProviders(providers);
            replacements.maybeInitializeEncoder(options);
        }
        var28_14 = null;
        try (InitTimer rt = InitTimer.timer((String)"instantiate backend");){
            AMD64HotSpotBackend aMD64HotSpotBackend = this.createBackend(config, graalRuntime, providers);
            return aMD64HotSpotBackend;
        }
        catch (Throwable throwable) {
            var28_14 = throwable;
            throw throwable;
        }
    }

    protected GraphBuilderConfiguration.Plugins createGraphBuilderPlugins(HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, GraalHotSpotVMConfig config, TargetDescription target, HotSpotConstantReflectionProvider constantReflection, HotSpotHostForeignCallsProvider foreignCalls, HotSpotMetaAccessProvider metaAccess, HotSpotSnippetReflectionProvider snippetReflection, HotSpotReplacementsImpl replacements, HotSpotWordTypes wordTypes, OptionValues options) {
        GraphBuilderConfiguration.Plugins plugins = HotSpotGraphBuilderPlugins.create(graalRuntime, compilerConfiguration, config, wordTypes, (MetaAccessProvider)metaAccess, (ConstantReflectionProvider)constantReflection, snippetReflection, foreignCalls, replacements, options, target);
        AMD64GraphBuilderPlugins.register(plugins, replacements, (AMD64)target.arch, false, JavaVersionUtil.JAVA_SPEC >= 9, config.useFMAIntrinsics);
        return plugins;
    }

    protected AMD64HotSpotBackend createBackend(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, HotSpotProviders providers) {
        return new AMD64HotSpotBackend(config, runtime, providers);
    }

    protected HotSpotRegistersProvider createRegisters() {
        return new HotSpotRegisters(AMD64.r15, AMD64.r12, AMD64.rsp);
    }

    protected AMD64HotSpotForeignCallsProvider createForeignCalls(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider runtime, HotSpotMetaAccessProvider metaAccess, HotSpotCodeCacheProvider codeCache, WordTypes wordTypes, Value[] nativeABICallerSaveRegisters) {
        return new AMD64HotSpotForeignCallsProvider(jvmciRuntime, runtime, (MetaAccessProvider)metaAccess, (CodeCacheProvider)codeCache, wordTypes, nativeABICallerSaveRegisters);
    }

    protected HotSpotSuitesProvider createSuites(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, CompilerConfiguration compilerConfiguration, GraphBuilderConfiguration.Plugins plugins, HotSpotRegistersProvider registers, Replacements replacements, OptionValues options) {
        return new AddressLoweringHotSpotSuitesProvider(new AMD64HotSpotSuitesCreator(compilerConfiguration, plugins), config, runtime, new AddressLoweringPhase(new AMD64HotSpotAddressLowering(config, registers.getHeapBaseRegister(), options)));
    }

    protected HotSpotLoweringProvider createLowerer(HotSpotGraalRuntimeProvider runtime, HotSpotMetaAccessProvider metaAccess, HotSpotForeignCallsProvider foreignCalls, HotSpotRegistersProvider registers, HotSpotConstantReflectionProvider constantReflection, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        return new AMD64HotSpotLoweringProvider(runtime, (MetaAccessProvider)metaAccess, foreignCalls, registers, constantReflection, platformConfig, metaAccessExtensionProvider, target);
    }

    protected Value[] createNativeABICallerSaveRegisters(GraalHotSpotVMConfig config, RegisterConfig regConfig) {
        ArrayList callerSave = new ArrayList(regConfig.getAllocatableRegisters().asList());
        if (config.osName.equals("windows")) {
            callerSave.remove(AMD64.rdi);
            callerSave.remove(AMD64.rsi);
            callerSave.remove(AMD64.rbx);
            callerSave.remove(AMD64.rbp);
            callerSave.remove(AMD64.rsp);
            callerSave.remove(AMD64.r12);
            callerSave.remove(AMD64.r13);
            callerSave.remove(AMD64.r14);
            callerSave.remove(AMD64.r15);
            callerSave.remove(AMD64.xmm6);
            callerSave.remove(AMD64.xmm7);
            callerSave.remove(AMD64.xmm8);
            callerSave.remove(AMD64.xmm9);
            callerSave.remove(AMD64.xmm10);
            callerSave.remove(AMD64.xmm11);
            callerSave.remove(AMD64.xmm12);
            callerSave.remove(AMD64.xmm13);
            callerSave.remove(AMD64.xmm14);
            callerSave.remove(AMD64.xmm15);
        } else {
            callerSave.remove(AMD64.rbp);
            callerSave.remove(AMD64.rbx);
            callerSave.remove(AMD64.r12);
            callerSave.remove(AMD64.r13);
            callerSave.remove(AMD64.r14);
            callerSave.remove(AMD64.r15);
        }
        Value[] nativeABICallerSaveRegisters = new Value[callerSave.size()];
        for (int i = 0; i < callerSave.size(); ++i) {
            nativeABICallerSaveRegisters[i] = ((Register)callerSave.get(i)).asValue();
        }
        return nativeABICallerSaveRegisters;
    }

    public String toString() {
        return "AMD64";
    }
}

