/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotSentinelConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.amd64.AMD64NodeMatchRules;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.gen.LIRGenerationProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotDataBuilder;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotHostBackend;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerationResult;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotMove;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotNodeLIRBuilder;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotRegisterAllocationConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotConstantLoadAction;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.amd64.AMD64FrameMap;
import org.graalvm.compiler.lir.amd64.AMD64FrameMapBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.options.OptionValues;

public class AMD64HotSpotBackend
extends HotSpotHostBackend
implements LIRGenerationProvider {
    public static final int PATCHED_VERIFIED_ENTRY_POINT_INSTRUCTION_SIZE = 5;

    public AMD64HotSpotBackend(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, HotSpotProviders providers) {
        super(config, runtime, providers);
    }

    @Override
    protected FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        AMD64FrameMap frameMap = new AMD64FrameMap(this.getCodeCache(), registerConfigNonNull, this, this.config.preserveFramePointer);
        return new AMD64FrameMapBuilder(frameMap, this.getCodeCache(), registerConfigNonNull);
    }

    @Override
    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenRes) {
        return new AMD64HotSpotLIRGenerator(this.getProviders(), this.config, lirGenRes);
    }

    @Override
    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        return new AMD64HotSpotNodeLIRBuilder(graph, lirGen, new AMD64NodeMatchRules(lirGen));
    }

    @Override
    protected void bangStackWithOffset(CompilationResultBuilder crb, int bangOffset) {
        AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
        int pos = asm.position();
        asm.movl(new AMD64Address(AMD64.rsp, -bangOffset), AMD64.rax);
        assert (asm.position() - pos >= 5);
    }

    @Override
    public CompilationResultBuilder newCompilationResultBuilder(LIRGenerationResult lirGenRen, FrameMap frameMap, CompilationResult compilationResult, CompilationResultBuilderFactory factory) {
        HotSpotLIRGenerationResult gen = (HotSpotLIRGenerationResult)lirGenRen;
        LIR lir = gen.getLIR();
        assert (gen.getDeoptimizationRescueSlot() == null || frameMap.frameNeedsAllocating()) : "method that can deoptimize must have a frame";
        OptionValues options = lir.getOptions();
        DebugContext debug = lir.getDebug();
        boolean omitFrame = GraalOptions.CanOmitFrame.getValue(options) != false && !frameMap.frameNeedsAllocating() && !lir.hasArgInCallerFrame() && !gen.hasForeignCall() && !((AMD64FrameMap)frameMap).useStandardFrameProlog();
        Stub stub = gen.getStub();
        AMD64MacroAssembler masm = new AMD64MacroAssembler(this.getTarget(), options, this.config.CPU_HAS_INTEL_JCC_ERRATUM);
        masm.setCodePatchShifter(compilationResult::shiftCodePatch);
        HotSpotFrameContext frameContext = new HotSpotFrameContext(stub != null, omitFrame, this.config.preserveFramePointer);
        HotSpotDataBuilder dataBuilder = new HotSpotDataBuilder(this.getCodeCache().getTarget());
        CompilationResultBuilder crb = factory.createBuilder(this.getCodeCache(), this.getForeignCalls(), frameMap, masm, dataBuilder, frameContext, options, debug, compilationResult, Register.None);
        crb.setTotalFrameSize(frameMap.totalFrameSize());
        crb.setMaxInterpreterFrameSize(gen.getMaxInterpreterFrameSize());
        StackSlot deoptimizationRescueSlot = gen.getDeoptimizationRescueSlot();
        if (deoptimizationRescueSlot != null && stub == null) {
            crb.compilationResult.setCustomStackAreaOffset(deoptimizationRescueSlot);
        }
        if (stub != null) {
            this.updateStub(stub, gen, frameMap);
        }
        return crb;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, LIR lir, ResolvedJavaMethod installedCodeOwner) {
        AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
        FrameMap frameMap = crb.frameMap;
        RegisterConfig regConfig = frameMap.getRegisterConfig();
        this.emitCodePrefix(installedCodeOwner, crb, asm, regConfig);
        this.emitCodeBody(installedCodeOwner, crb, lir);
        this.emitCodeSuffix(installedCodeOwner, crb, asm, frameMap);
        this.profileInstructions(lir, crb);
    }

    public void emitCodePrefix(ResolvedJavaMethod installedCodeOwner, CompilationResultBuilder crb, AMD64MacroAssembler asm, RegisterConfig regConfig) {
        HotSpotProviders providers = this.getProviders();
        if (installedCodeOwner != null && !installedCodeOwner.isStatic()) {
            int before;
            crb.recordMark(HotSpotMarkId.UNVERIFIED_ENTRY);
            CallingConvention cc = regConfig.getCallingConvention((CallingConvention.Type)HotSpotCallingConventionType.JavaCallee, null, new JavaType[]{providers.getMetaAccess().lookupJavaType(Object.class)}, (ValueKindFactory)this);
            Register inlineCacheKlass = AMD64.rax;
            Register receiver = ValueUtil.asRegister((Value)cc.getArgument(0));
            AMD64Address src = new AMD64Address(receiver, this.config.hubOffset);
            if (this.config.useCompressedClassPointers) {
                Register register = AMD64.r10;
                Register heapBase = providers.getRegisters().getHeapBaseRegister();
                AMD64HotSpotMove.decodeKlassPointer(crb, asm, register, heapBase, src, this.config);
                if (GraalOptions.GeneratePIC.getValue(crb.getOptions()).booleanValue()) {
                    asm.movq(heapBase, asm.getPlaceholder(-1));
                    crb.recordMark(HotSpotMarkId.NARROW_OOP_BASE_ADDRESS);
                } else if (this.config.narrowKlassBase != 0L) {
                    if (this.config.narrowOopBase == 0L) {
                        asm.xorq(heapBase, heapBase);
                    } else {
                        asm.movq(heapBase, this.config.narrowOopBase);
                    }
                }
                before = asm.cmpqAndJcc(inlineCacheKlass, register, AMD64Assembler.ConditionFlag.NotEqual, null, false);
            } else {
                before = asm.cmpqAndJcc(inlineCacheKlass, src, AMD64Assembler.ConditionFlag.NotEqual, null, false);
            }
            AMD64Call.recordDirectCall(crb, asm, this.getForeignCalls().lookupForeignCall(IC_MISS_HANDLER), before);
        }
        asm.align(this.config.codeEntryAlignment);
        crb.recordMark(crb.compilationResult.getEntryBCI() != -1 ? HotSpotMarkId.OSR_ENTRY : HotSpotMarkId.VERIFIED_ENTRY);
        if (GraalOptions.GeneratePIC.getValue(crb.getOptions()).booleanValue()) {
            HotSpotFrameContext frameContext = (HotSpotFrameContext)crb.frameContext;
            if (!frameContext.isStub) {
                crb.recordInlineDataInCodeWithNote((Constant)new HotSpotSentinelConstant((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.QWORD), JavaKind.Long), (Object)HotSpotConstantLoadAction.MAKE_NOT_ENTRANT);
                asm.movq(AMD64.rax, asm.getPlaceholder(-1));
                int before = asm.testqAndJcc(AMD64.rax, AMD64.rax, AMD64Assembler.ConditionFlag.NotZero, null, false);
                AMD64Call.recordDirectCall(crb, asm, this.getForeignCalls().lookupForeignCall(WRONG_METHOD_HANDLER), before);
            }
        }
    }

    public void emitCodeBody(ResolvedJavaMethod installedCodeOwner, CompilationResultBuilder crb, LIR lir) {
        crb.emit(lir);
    }

    public void emitCodeSuffix(ResolvedJavaMethod installedCodeOwner, CompilationResultBuilder crb, AMD64MacroAssembler asm, FrameMap frameMap) {
        HotSpotProviders providers = this.getProviders();
        HotSpotFrameContext frameContext = (HotSpotFrameContext)crb.frameContext;
        if (!frameContext.isStub) {
            HotSpotHostForeignCallsProvider foreignCalls = providers.getForeignCalls();
            crb.recordMark(HotSpotMarkId.EXCEPTION_HANDLER_ENTRY);
            AMD64Call.directCall(crb, asm, foreignCalls.lookupForeignCall(EXCEPTION_HANDLER), null, false, null);
            crb.recordMark(HotSpotMarkId.DEOPT_HANDLER_ENTRY);
            AMD64Call.directCall(crb, asm, foreignCalls.lookupForeignCall(DEOPT_BLOB_UNPACK), null, false, null);
            if (this.config.supportsMethodHandleDeoptimizationEntry() && crb.needsMHDeoptHandler()) {
                crb.recordMark(HotSpotMarkId.DEOPT_MH_HANDLER_ENTRY);
                AMD64Call.directCall(crb, asm, foreignCalls.lookupForeignCall(DEOPT_BLOB_UNPACK), null, false, null);
            }
        } else if (frameContext.omitFrame) assert (!frameMap.accessesCallerFrame());
    }

    @Override
    public RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new AMD64HotSpotRegisterAllocationConfig(registerConfigNonNull, allocationRestrictedTo, this.config.preserveFramePointer);
    }

    @Override
    public EconomicSet<Register> translateToCallerRegisters(EconomicSet<Register> calleeRegisters) {
        return calleeRegisters;
    }

    class HotSpotFrameContext
    implements FrameContext {
        final boolean isStub;
        final boolean omitFrame;
        final boolean useStandardFrameProlog;

        HotSpotFrameContext(boolean isStub, boolean omitFrame, boolean useStandardFrameProlog) {
            this.isStub = isStub;
            this.omitFrame = omitFrame;
            this.useStandardFrameProlog = useStandardFrameProlog;
        }

        @Override
        public boolean hasFrame() {
            return !this.omitFrame;
        }

        @Override
        public void enter(CompilationResultBuilder crb) {
            FrameMap frameMap = crb.frameMap;
            int frameSize = frameMap.frameSize();
            AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
            if (this.omitFrame) {
                if (!this.isStub) {
                    asm.nop(5);
                }
            } else {
                int verifiedEntryPointOffset = asm.position();
                if (!this.isStub) {
                    AMD64HotSpotBackend.this.emitStackOverflowCheck(crb);
                }
                if (this.useStandardFrameProlog) {
                    asm.push(AMD64.rbp);
                    asm.movq(AMD64.rbp, AMD64.rsp);
                }
                if (!this.isStub && asm.position() == verifiedEntryPointOffset) {
                    asm.subqWide(AMD64.rsp, frameSize);
                    assert (asm.position() - verifiedEntryPointOffset >= 5);
                } else {
                    asm.decrementq(AMD64.rsp, frameSize);
                }
                if (HotSpotMarkId.FRAME_COMPLETE.isAvailable()) {
                    crb.recordMark(HotSpotMarkId.FRAME_COMPLETE);
                }
                if (GraalOptions.ZapStackOnMethodEntry.getValue(crb.getOptions()).booleanValue()) {
                    int intSize = 4;
                    for (int i = 0; i < frameSize / 4; ++i) {
                        asm.movl(new AMD64Address(AMD64.rsp, i * 4), -1044266559);
                    }
                }
                assert (frameMap.getRegisterConfig().getCalleeSaveRegisters() == null);
            }
        }

        @Override
        public void leave(CompilationResultBuilder crb) {
            if (!this.omitFrame) {
                AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
                assert (crb.frameMap.getRegisterConfig().getCalleeSaveRegisters() == null);
                int frameSize = crb.frameMap.frameSize();
                if (this.useStandardFrameProlog) {
                    asm.movq(AMD64.rsp, AMD64.rbp);
                    asm.pop(AMD64.rbp);
                } else {
                    asm.incrementq(AMD64.rsp, frameSize);
                }
            }
        }

        @Override
        public void returned(CompilationResultBuilder crb) {
        }
    }
}

