/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import java.util.ArrayList;
import java.util.Arrays;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaAccessProvider;
import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotRegisterConfig;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.runtime.JVMCIBackend;
import org.graalvm.compiler.core.aarch64.AArch64AddressLoweringByUse;
import org.graalvm.compiler.core.aarch64.AArch64LIRKindTool;
import org.graalvm.compiler.core.aarch64.AArch64SuitesCreator;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotBackendFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotReplacementsImpl;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotBackend;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.AddressLoweringHotSpotSuitesProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotGraalConstantFieldProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotGraphBuilderPlugins;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotMetaAccessExtensionProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotPlatformConfigurationProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegisters;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotSnippetReflectionProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotStampProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotSuitesProvider;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.AddressLoweringByUsePhase;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.replacements.aarch64.AArch64GraphBuilderPlugins;
import org.graalvm.compiler.replacements.classfile.ClassfileBytecodeProvider;
import org.graalvm.compiler.serviceprovider.ServiceProvider;
import org.graalvm.compiler.word.WordTypes;

@ServiceProvider(value=HotSpotBackendFactory.class)
public class AArch64HotSpotBackendFactory
extends HotSpotBackendFactory {
    @Override
    public String getName() {
        return "community";
    }

    @Override
    public Class<? extends Architecture> getArchitecture() {
        return AArch64.class;
    }

    @Override
    public HotSpotBackend createBackend(HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, HotSpotJVMCIRuntime jvmciRuntime, HotSpotBackend host) {
        HotSpotProviders providers;
        assert (host == null);
        OptionValues options = graalRuntime.getOptions();
        JVMCIBackend jvmci = jvmciRuntime.getHostJVMCIBackend();
        GraalHotSpotVMConfig config = graalRuntime.getVMConfig();
        HotSpotCodeCacheProvider codeCache = (HotSpotCodeCacheProvider)jvmci.getCodeCache();
        TargetDescription target = codeCache.getTarget();
        HotSpotMetaAccessProvider metaAccess = (HotSpotMetaAccessProvider)jvmci.getMetaAccess();
        HotSpotConstantReflectionProvider constantReflection = (HotSpotConstantReflectionProvider)jvmci.getConstantReflection();
        HotSpotGraalConstantFieldProvider constantFieldProvider = new HotSpotGraalConstantFieldProvider(config, (MetaAccessProvider)metaAccess);
        try (InitTimer t = InitTimer.timer((String)"create providers");){
            HotSpotSuitesProvider suites;
            GraphBuilderConfiguration.Plugins plugins;
            HotSpotReplacementsImpl replacements;
            ClassfileBytecodeProvider bytecodeProvider;
            HotSpotSnippetReflectionProvider snippetReflection;
            HotSpotLoweringProvider lowerer;
            HotSpotMetaAccessExtensionProvider metaAccessExtensionProvider;
            HotSpotPlatformConfigurationProvider platformConfigurationProvider;
            HotSpotStampProvider stampProvider;
            HotSpotHostForeignCallsProvider foreignCalls;
            HotSpotWordTypes wordTypes;
            Value[] nativeABICallerSaveRegisters;
            HotSpotRegistersProvider registers;
            try (InitTimer rt = InitTimer.timer((String)"create HotSpotRegisters provider");){
                registers = this.createRegisters();
            }
            rt = InitTimer.timer((String)"create NativeABICallerSaveRegisters");
            var30_19 = null;
            try {
                nativeABICallerSaveRegisters = AArch64HotSpotBackendFactory.createNativeABICallerSaveRegisters(config, codeCache.getRegisterConfig());
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create WordTypes");
            var30_19 = null;
            try {
                wordTypes = this.createWordTypes(metaAccess, target);
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create ForeignCalls provider");
            var30_19 = null;
            try {
                foreignCalls = this.createForeignCalls(jvmciRuntime, graalRuntime, metaAccess, codeCache, wordTypes, nativeABICallerSaveRegisters);
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create stamp provider");
            var30_19 = null;
            try {
                stampProvider = this.createStampProvider();
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create platform configuration provider");
            var30_19 = null;
            try {
                platformConfigurationProvider = this.createConfigInfoProvider(config, (MetaAccessProvider)metaAccess);
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create MetaAccessExtensionProvider");
            var30_19 = null;
            try {
                metaAccessExtensionProvider = this.createMetaAccessExtensionProvider();
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create Lowerer provider");
            var30_19 = null;
            try {
                lowerer = this.createLowerer(graalRuntime, metaAccess, foreignCalls, registers, constantReflection, platformConfigurationProvider, metaAccessExtensionProvider, target);
            }
            catch (Throwable throwable) {
                var30_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var30_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var30_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            HotSpotProviders p = new HotSpotProviders((MetaAccessProvider)metaAccess, (CodeCacheProvider)codeCache, (ConstantReflectionProvider)constantReflection, constantFieldProvider, foreignCalls, lowerer, null, stampProvider, platformConfigurationProvider, metaAccessExtensionProvider);
            try (InitTimer rt = InitTimer.timer((String)"create SnippetReflection provider");){
                snippetReflection = this.createSnippetReflection(graalRuntime, constantReflection, wordTypes);
            }
            rt = InitTimer.timer((String)"create Bytecode provider");
            var31_26 = null;
            try {
                bytecodeProvider = this.createBytecodeProvider(metaAccess, snippetReflection);
            }
            catch (Throwable throwable) {
                var31_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create Replacements provider");
            var31_26 = null;
            try {
                replacements = this.createReplacements(target, p, snippetReflection, bytecodeProvider);
            }
            catch (Throwable throwable) {
                var31_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create GraphBuilderPhase plugins");
            var31_26 = null;
            try {
                plugins = this.createGraphBuilderPlugins(graalRuntime, compilerConfiguration, config, constantReflection, foreignCalls, metaAccess, snippetReflection, replacements, wordTypes, graalRuntime.getOptions(), target);
                replacements.setGraphBuilderPlugins(plugins);
            }
            catch (Throwable throwable) {
                var31_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create Suites provider");
            var31_26 = null;
            try {
                suites = this.createSuites(config, graalRuntime, compilerConfiguration, plugins, replacements);
            }
            catch (Throwable throwable) {
                var31_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            providers = new HotSpotProviders((MetaAccessProvider)metaAccess, codeCache, (ConstantReflectionProvider)constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, suites, registers, snippetReflection, wordTypes, plugins, platformConfigurationProvider, metaAccessExtensionProvider, config);
            replacements.setProviders(providers);
            replacements.maybeInitializeEncoder(options);
        }
        var28_14 = null;
        try (InitTimer rt = InitTimer.timer((String)"instantiate backend");){
            AArch64HotSpotBackend aArch64HotSpotBackend = this.createBackend(config, graalRuntime, providers);
            return aArch64HotSpotBackend;
        }
        catch (Throwable throwable) {
            var28_14 = throwable;
            throw throwable;
        }
    }

    protected GraphBuilderConfiguration.Plugins createGraphBuilderPlugins(HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, GraalHotSpotVMConfig config, HotSpotConstantReflectionProvider constantReflection, HotSpotHostForeignCallsProvider foreignCalls, HotSpotMetaAccessProvider metaAccess, HotSpotSnippetReflectionProvider snippetReflection, HotSpotReplacementsImpl replacements, HotSpotWordTypes wordTypes, OptionValues options, TargetDescription target) {
        GraphBuilderConfiguration.Plugins plugins = HotSpotGraphBuilderPlugins.create(graalRuntime, compilerConfiguration, config, wordTypes, (MetaAccessProvider)metaAccess, (ConstantReflectionProvider)constantReflection, snippetReflection, foreignCalls, replacements, options, target);
        AArch64GraphBuilderPlugins.register(plugins, replacements, false, true, true, config.useFMAIntrinsics);
        return plugins;
    }

    protected AArch64HotSpotBackend createBackend(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, HotSpotProviders providers) {
        return new AArch64HotSpotBackend(config, runtime, providers);
    }

    protected HotSpotRegistersProvider createRegisters() {
        return new HotSpotRegisters(AArch64HotSpotRegisterConfig.threadRegister, AArch64HotSpotRegisterConfig.heapBaseRegister, AArch64.sp);
    }

    protected HotSpotHostForeignCallsProvider createForeignCalls(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider runtime, HotSpotMetaAccessProvider metaAccess, HotSpotCodeCacheProvider codeCache, WordTypes wordTypes, Value[] nativeABICallerSaveRegisters) {
        return new AArch64HotSpotForeignCallsProvider(jvmciRuntime, runtime, (MetaAccessProvider)metaAccess, (CodeCacheProvider)codeCache, wordTypes, nativeABICallerSaveRegisters);
    }

    protected HotSpotSuitesProvider createSuites(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, CompilerConfiguration compilerConfiguration, GraphBuilderConfiguration.Plugins plugins, Replacements replacements) {
        AArch64SuitesCreator suitesCreator = new AArch64SuitesCreator(compilerConfiguration, plugins, Arrays.asList(SchedulePhase.class));
        AddressLoweringByUsePhase addressLoweringPhase = new AddressLoweringByUsePhase(new AArch64AddressLoweringByUse(new AArch64LIRKindTool()));
        return new AddressLoweringHotSpotSuitesProvider(suitesCreator, config, runtime, addressLoweringPhase);
    }

    protected HotSpotLoweringProvider createLowerer(HotSpotGraalRuntimeProvider runtime, HotSpotMetaAccessProvider metaAccess, HotSpotForeignCallsProvider foreignCalls, HotSpotRegistersProvider registers, HotSpotConstantReflectionProvider constantReflection, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        return new AArch64HotSpotLoweringProvider(runtime, (MetaAccessProvider)metaAccess, foreignCalls, registers, constantReflection, platformConfig, metaAccessExtensionProvider, target);
    }

    protected static Value[] createNativeABICallerSaveRegisters(GraalHotSpotVMConfig config, RegisterConfig regConfig) {
        ArrayList callerSave = new ArrayList(regConfig.getAllocatableRegisters().asList());
        callerSave.remove(AArch64.r19);
        callerSave.remove(AArch64.r20);
        callerSave.remove(AArch64.r21);
        callerSave.remove(AArch64.r22);
        callerSave.remove(AArch64.r23);
        callerSave.remove(AArch64.r24);
        callerSave.remove(AArch64.r25);
        callerSave.remove(AArch64.r26);
        callerSave.remove(AArch64.r27);
        callerSave.remove(AArch64.r28);
        Value[] nativeABICallerSaveRegisters = new Value[callerSave.size()];
        for (int i = 0; i < callerSave.size(); ++i) {
            nativeABICallerSaveRegisters[i] = ((Register)callerSave.get(i)).asValue();
        }
        return nativeABICallerSaveRegisters;
    }

    public String toString() {
        return "AArch64";
    }
}

