/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.SymbolicJVMCIReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.hotspot.EncodedSnippets;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotReplacementsImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.SnippetParameterInfo;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetIntegerHistogram;

public class SymbolicSnippetEncoder {
    private final HotSpotSnippetReplacementsImpl snippetReplacements;
    private final EconomicMap<String, String> originalMethods = EconomicMap.create();
    private final HotSpotReplacementsImpl originalReplacements;
    private int encodedGraphs = 0;
    private EconomicMap<String, StructuredGraph> preparedSnippetGraphs = EconomicMap.create();
    private EconomicMap<String, GraphKey> keyToMethod = EconomicMap.create();
    private EconomicMap<String, SnippetParameterInfo> snippetParameterInfos = EconomicMap.create();
    private EconomicSet<MethodSubstitutionPlugin> knownPlugins = EconomicSet.create();
    private EconomicSet<InvocationPlugin> conditionalPlugins = EconomicSet.create();
    private int preparedPlugins = 0;
    private Set<ResolvedJavaMethod> delayedInvocationPluginMethods = new HashSet<ResolvedJavaMethod>();

    void addDelayedInvocationPluginMethod(ResolvedJavaMethod method) {
        this.delayedInvocationPluginMethods.add(method);
    }

    public void clearSnippetParameterNames() {
        for (SnippetParameterInfo info : this.snippetParameterInfos.getValues()) {
            info.clearNames();
        }
    }

    SymbolicSnippetEncoder(HotSpotReplacementsImpl replacements) {
        this.originalReplacements = replacements;
        GraphBuilderConfiguration.Plugins plugins = replacements.getGraphBuilderPlugins();
        InvocationPlugins invocationPlugins = plugins.getInvocationPlugins();
        GraphBuilderConfiguration.Plugins copy = new GraphBuilderConfiguration.Plugins(plugins, invocationPlugins);
        copy.clearInlineInvokePlugins();
        copy.appendInlineInvokePlugin(new SnippetInlineInvokePlugin());
        copy.appendNodePlugin(new SnippetCounterPlugin());
        HotSpotProviders providers = replacements.getProviders().copyWith(new HotSpotSubstrateConstantReflectionProvider(replacements.getProviders().getConstantReflection()));
        this.snippetReplacements = new HotSpotSnippetReplacementsImpl(replacements, providers.copyWith(copy));
        this.snippetReplacements.setGraphBuilderPlugins(copy);
    }

    synchronized void registerMethodSubstitution(MethodSubstitutionPlugin plugin) {
        this.knownPlugins.add((Object)plugin);
    }

    void registerConditionalPlugin(InvocationPlugin plugin) {
        this.conditionalPlugins.add((Object)plugin);
    }

    synchronized void checkRegistered(MethodSubstitutionPlugin plugin) {
        if (!this.knownPlugins.contains((Object)plugin)) {
            throw new GraalError("missing plugin should have been registered during construction");
        }
    }

    private synchronized void registerMethodSubstitution(MethodSubstitutionPlugin plugin, ResolvedJavaMethod original, IntrinsicContext.CompilationContext context, OptionValues options) {
        ResolvedJavaMethod method = plugin.getSubstitute(this.snippetReplacements.getProviders().getMetaAccess());
        assert (method.getAnnotation(MethodSubstitution.class) != null) : "MethodSubstitution must be annotated with @" + MethodSubstitution.class.getSimpleName();
        String originalMethodString = plugin.originalMethodAsString();
        StructuredGraph subst = this.buildGraph(method, original, originalMethodString, null, true, false, context, options);
        MethodSubstitutionKey key = new MethodSubstitutionKey(method, original, context, plugin);
        this.originalMethods.put((Object)key.keyString(), (Object)originalMethodString);
        this.preparedSnippetGraphs.put((Object)key.keyString(), (Object)subst);
        this.keyToMethod.put((Object)key.keyString(), (Object)key);
    }

    private StructuredGraph buildGraph(ResolvedJavaMethod method, ResolvedJavaMethod original, String originalMethodString, Object receiver, boolean requireInlining, boolean trackNodeSourcePosition, IntrinsicContext.CompilationContext context, OptionValues options) {
        assert (method.hasBytecodes()) : "Snippet must not be abstract or native";
        Object[] args = null;
        if (receiver != null) {
            args = new Object[method.getSignature().getParameterCount(true)];
            args[0] = receiver;
        }
        IntrinsicContext.CompilationContext contextToUse = context;
        if (context == IntrinsicContext.CompilationContext.ROOT_COMPILATION) {
            contextToUse = IntrinsicContext.CompilationContext.ROOT_COMPILATION_ENCODING;
        }
        try (DebugContext debug = this.snippetReplacements.openSnippetDebugContext("SymbolicSnippetEncoder_", method, options);){
            StructuredGraph graph = this.snippetReplacements.makeGraph(debug, this.snippetReplacements.getDefaultReplacementBytecodeProvider(), method, args, original, trackNodeSourcePosition, null, contextToUse);
            for (MethodCallTargetNode callTarget : graph.getNodes(MethodCallTargetNode.TYPE)) {
                ResolvedJavaMethod callee = callTarget.targetMethod();
                if (!requireInlining || this.delayedInvocationPluginMethods.contains(callee) || Objects.equals(callee, original)) continue;
                throw GraalError.shouldNotReachHere("method " + callee.format("%H.%n") + " not inlined in snippet " + method.getName() + " (maybe not final?)");
            }
            assert (this.verifySnippetEncodeDecode(debug, method, original, originalMethodString, args, trackNodeSourcePosition, graph));
            debug.dump(3, graph, "After buildGraph");
            StructuredGraph structuredGraph = graph;
            return structuredGraph;
        }
    }

    private boolean verifySnippetEncodeDecode(DebugContext debug, ResolvedJavaMethod method, ResolvedJavaMethod original, String originalMethodString, Object[] args, boolean trackNodeSourcePosition, StructuredGraph graph) {
        EncodedGraph encodedGraph = GraphEncoder.encodeSingleGraph(graph, HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().arch);
        HotSpotProviders originalProvider = this.snippetReplacements.getProviders();
        SnippetReflectionProvider snippetReflection = originalProvider.getSnippetReflection();
        HotSpotSubstrateConstantReflectionProvider constantReflection = new HotSpotSubstrateConstantReflectionProvider(originalProvider.getConstantReflection());
        HotSpotProviders newProviders = new HotSpotProviders(originalProvider.getMetaAccess(), originalProvider.getCodeCache(), constantReflection, originalProvider.getConstantFieldProvider(), originalProvider.getForeignCalls(), originalProvider.getLowerer(), null, originalProvider.getSuites(), originalProvider.getRegisters(), snippetReflection, originalProvider.getWordTypes(), originalProvider.getGraphBuilderPlugins(), originalProvider.getPlatformConfigurationProvider(), originalProvider.getMetaAccessExtensionProvider(), originalProvider.getConfig());
        HotSpotSnippetReplacementsImpl filteringReplacements = new HotSpotSnippetReplacementsImpl(newProviders, snippetReflection, originalProvider.getReplacements().getDefaultReplacementBytecodeProvider(), originalProvider.getCodeCache().getTarget());
        filteringReplacements.setGraphBuilderPlugins(originalProvider.getReplacements().getGraphBuilderPlugins());
        try (DebugContext.Scope scaope = debug.scope((Object)"VerifySnippetEncodeDecode", graph);){
            String decodedSnippetString;
            for (int i = 0; i < encodedGraph.getNumObjects(); ++i) {
                SymbolicSnippetEncoder.filterSnippetObject(encodedGraph.getObject(i));
            }
            StructuredGraph snippet = filteringReplacements.makeGraph(debug, filteringReplacements.getDefaultReplacementBytecodeProvider(), method, args, original, trackNodeSourcePosition, null);
            EncodedSnippets.SymbolicEncodedGraph symbolicGraph = new EncodedSnippets.SymbolicEncodedGraph(encodedGraph, method.getDeclaringClass(), originalMethodString);
            StructuredGraph decodedSnippet = EncodedSnippets.decodeSnippetGraph(symbolicGraph, original != null ? original : method, this.originalReplacements, null, StructuredGraph.AllowAssumptions.ifNonNull(graph.getAssumptions()), graph.getOptions(), false);
            String snippetString = SymbolicSnippetEncoder.getCanonicalGraphString(snippet, true, false);
            if (snippetString.equals(decodedSnippetString = SymbolicSnippetEncoder.getCanonicalGraphString(decodedSnippet, true, false))) {
                debug.log("Snippet decode for %s produces exactly same graph", method);
                debug.dump(3, (Object)decodedSnippet, "Decoded snippet graph for %s", method);
            } else {
                debug.log("Snippet decode for %s produces different graph", method);
                debug.log("%s", (Object)SymbolicSnippetEncoder.compareGraphStrings(snippet, snippetString, decodedSnippet, decodedSnippetString));
                debug.dump(3, (Object)snippet, "Snippet graph for %s", method);
                debug.dump(3, (Object)graph, "Encoded snippet graph for %s", method);
                debug.dump(3, (Object)decodedSnippet, "Decoded snippet graph for %s", method);
            }
        }
        catch (Throwable t) {
            throw debug.handle(t);
        }
        return true;
    }

    private synchronized EncodedSnippets maybeEncodeSnippets(OptionValues options) {
        EconomicMap<String, StructuredGraph> graphs;
        EconomicSet<MethodSubstitutionPlugin> plugins = this.knownPlugins;
        if (this.preparedPlugins != plugins.size()) {
            for (MethodSubstitutionPlugin plugin : plugins) {
                ResolvedJavaMethod original = plugin.getOriginalMethod(this.originalReplacements.getProviders().getMetaAccess());
                this.registerMethodSubstitution(plugin, original, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING, options);
                if (original.isNative()) continue;
                this.registerMethodSubstitution(plugin, original, IntrinsicContext.CompilationContext.ROOT_COMPILATION_ENCODING, options);
            }
            this.preparedPlugins = plugins.size();
        }
        if (this.encodedGraphs != (graphs = this.preparedSnippetGraphs).size()) {
            DebugContext debug = this.openDebugContext("SnippetEncoder", null, options);
            try (DebugContext.Scope scope = debug.scope("SnippetSupportEncode");){
                this.encodedGraphs = graphs.size();
                for (StructuredGraph graph : graphs.getValues()) {
                    for (Node node : graph.getNodes()) {
                        node.setNodeSourcePosition(null);
                    }
                }
                EncodedSnippets encodedSnippets = this.encodeSnippets(debug);
                return encodedSnippets;
            }
        }
        return null;
    }

    synchronized void registerSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, Object receiver, boolean trackNodeSourcePosition, OptionValues options) {
        if (Services.IS_BUILDING_NATIVE_IMAGE || GraalOptions.UseEncodedGraphs.getValue(options).booleanValue()) {
            assert (method.getAnnotation(Snippet.class) != null) : "Snippet must be annotated with @" + Snippet.class.getSimpleName();
            SnippetKey key = new SnippetKey(method, original);
            String keyString = key.keyString();
            if (!this.preparedSnippetGraphs.containsKey((Object)keyString)) {
                if (original != null) {
                    this.originalMethods.put((Object)keyString, (Object)EncodedSnippets.methodKey(original));
                }
                StructuredGraph snippet = this.buildGraph(method, original, null, receiver, true, trackNodeSourcePosition, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING, options);
                this.preparedSnippetGraphs.put((Object)keyString, (Object)snippet);
                this.snippetParameterInfos.put((Object)keyString, (Object)new SnippetParameterInfo(method));
                this.keyToMethod.put((Object)keyString, (Object)key);
            }
        }
    }

    private synchronized EncodedSnippets encodeSnippets(DebugContext debug) {
        GraphEncoder encoder = new GraphEncoder(HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().arch, debug);
        for (StructuredGraph graph : this.preparedSnippetGraphs.getValues()) {
            encoder.prepare(graph);
        }
        encoder.finishPrepare();
        EconomicMap graphDatas = EconomicMap.create();
        MapCursor cursor = this.preparedSnippetGraphs.getEntries();
        while (cursor.advance()) {
            EncodedSnippets.GraphData data = new EncodedSnippets.GraphData(encoder.encode((StructuredGraph)cursor.getValue()), (String)this.originalMethods.get(cursor.getKey()), (SnippetParameterInfo)this.snippetParameterInfos.get(cursor.getKey()));
            graphDatas.put(cursor.getKey(), (Object)data);
        }
        byte[] snippetEncoding = encoder.getEncoding();
        Object[] snippetObjects = encoder.getObjects();
        for (int i = 0; i < snippetObjects.length; ++i) {
            Object o = SymbolicSnippetEncoder.filterSnippetObject(snippetObjects[i]);
            debug.log("snippetObjects[%d] = %s -> %s", (Object)i, (Object)(o != null ? o.getClass().getSimpleName() : null), o);
            snippetObjects[i] = o;
        }
        debug.log("Encoded %d snippet preparedSnippetGraphs using %d bytes with %d objects", graphDatas.size(), snippetEncoding.length, snippetObjects.length);
        return new EncodedSnippets(snippetEncoding, snippetObjects, encoder.getNodeClasses(), (UnmodifiableEconomicMap<String, EncodedSnippets.GraphData>)graphDatas);
    }

    public boolean encode(OptionValues options) {
        EncodedSnippets encodedSnippets;
        if (!Services.IS_IN_NATIVE_IMAGE && (encodedSnippets = this.maybeEncodeSnippets(options)) != null) {
            HotSpotReplacementsImpl.setEncodedSnippets(encodedSnippets);
            return true;
        }
        return false;
    }

    private DebugContext openDebugContext(String idPrefix, ResolvedJavaMethod method, OptionValues options) {
        return this.snippetReplacements.openDebugContext(idPrefix, method, options);
    }

    private static Object filterSnippetObject(Object o) {
        if (o instanceof HotSpotResolvedJavaMethod) {
            return new EncodedSnippets.SymbolicResolvedJavaMethod((ResolvedJavaMethod)((HotSpotResolvedJavaMethod)o));
        }
        if (o instanceof HotSpotResolvedJavaField) {
            return new EncodedSnippets.SymbolicResolvedJavaField((ResolvedJavaField)((HotSpotResolvedJavaField)o));
        }
        if (o instanceof HotSpotResolvedJavaType) {
            return UnresolvedJavaType.create((String)((ResolvedJavaType)o).getName());
        }
        if (o instanceof NodeSourcePosition) {
            return null;
        }
        if (o instanceof HotSpotForeignCallsProvider || o instanceof GraalHotSpotVMConfig || o instanceof HotSpotWordTypes || o instanceof TargetDescription || o instanceof SnippetReflectionProvider) {
            return new EncodedSnippets.GraalCapability(o.getClass());
        }
        if (o instanceof Stamp) {
            SymbolicJVMCIReference<? extends Stamp> ref = ((Stamp)o).makeSymbolic();
            if (ref != null) {
                return ref;
            }
            return o;
        }
        if (o instanceof StampPair) {
            if (((StampPair)o).getTrustedStamp() instanceof AbstractObjectStamp) {
                return new EncodedSnippets.SymbolicStampPair((StampPair)o);
            }
        } else {
            if (o instanceof ResolvedJavaMethodBytecode) {
                return new EncodedSnippets.SymbolicResolvedJavaMethodBytecode((ResolvedJavaMethodBytecode)o);
            }
            if (o instanceof HotSpotSignature) {
                throw new GraalError(o.toString());
            }
        }
        return o;
    }

    private static String compareGraphStrings(StructuredGraph expectedGraph, String expectedString, StructuredGraph actualGraph, String actualString) {
        if (!expectedString.equals(actualString)) {
            CharSequence[] expectedLines = expectedString.split("\n");
            CharSequence[] actualLines = actualString.split("\n");
            int diffIndex = -1;
            int limit = Math.min(actualLines.length, expectedLines.length);
            String marker = " <<<";
            for (int i = 0; i < limit; ++i) {
                if (expectedLines[i].equals(actualLines[i])) continue;
                diffIndex = i;
                break;
            }
            if (diffIndex == -1) {
                diffIndex = limit;
                if (actualLines.length == limit) {
                    actualLines = Arrays.copyOf(actualLines, limit + 1);
                    actualLines[diffIndex] = "";
                } else {
                    assert (expectedLines.length == limit);
                    expectedLines = Arrays.copyOf(expectedLines, limit + 1);
                    expectedLines[diffIndex] = "";
                }
            }
            expectedLines[diffIndex] = expectedLines[diffIndex] + marker;
            actualLines[diffIndex] = actualLines[diffIndex] + marker;
            String ediff = String.join((CharSequence)"\n", expectedLines);
            String adiff = String.join((CharSequence)"\n", actualLines);
            return "mismatch in preparedSnippetGraphs:\n========= expected (" + expectedGraph + ") =========\n" + ediff + "\n\n========= actual (" + actualGraph + ") =========\n" + adiff;
        }
        return "mismatch in preparedSnippetGraphs";
    }

    private static String getCanonicalGraphString(StructuredGraph graph, boolean excludeVirtual, boolean checkConstants) {
        SchedulePhase schedule = new SchedulePhase(SchedulePhase.SchedulingStrategy.EARLIEST);
        schedule.apply(graph);
        StructuredGraph.ScheduleResult scheduleResult = graph.getLastSchedule();
        NodeMap<Integer> canonicalId = graph.createNodeMap();
        int nextId = 0;
        ArrayList<String> constantsLines = new ArrayList<String>();
        StringBuilder result = new StringBuilder();
        for (Block block : scheduleResult.getCFG().getBlocks()) {
            result.append("Block ").append(block).append(' ');
            if (block == scheduleResult.getCFG().getStartBlock()) {
                result.append("* ");
            }
            result.append("-> ");
            for (Block succ : (Block[])block.getSuccessors()) {
                result.append(succ).append(' ');
            }
            result.append('\n');
            for (Node node : scheduleResult.getBlockToNodesMap().get(block)) {
                int id;
                if (!(node instanceof ValueNode) || !node.isAlive() || excludeVirtual && (node instanceof VirtualObjectNode || node instanceof ProxyNode || node instanceof FullInfopointNode || node instanceof ParameterNode)) continue;
                if (node instanceof ConstantNode) {
                    if (!checkConstants) continue;
                    String name = node.toString(Verbosity.Name);
                    if (excludeVirtual) {
                        constantsLines.add(name);
                        continue;
                    }
                    constantsLines.add(name + "    (" + SymbolicSnippetEncoder.filteredUsageCount(node) + ")");
                    continue;
                }
                if (canonicalId.get(node) != null) {
                    id = (Integer)canonicalId.get(node);
                } else {
                    id = nextId++;
                    canonicalId.set(node, id);
                }
                String name = node.getClass().getSimpleName();
                result.append("  ").append(id).append('|').append(name);
                if (node instanceof AccessFieldNode) {
                    result.append('#');
                    result.append(((AccessFieldNode)node).field());
                }
                if (!excludeVirtual) {
                    result.append("    (");
                    result.append(SymbolicSnippetEncoder.filteredUsageCount(node));
                    result.append(')');
                }
                result.append('\n');
            }
        }
        StringBuilder constantsLinesResult = new StringBuilder();
        if (checkConstants) {
            constantsLinesResult.append(constantsLines.size()).append(" constants:\n");
        }
        Collections.sort(constantsLines);
        for (String s : constantsLines) {
            constantsLinesResult.append(s);
            constantsLinesResult.append('\n');
        }
        return constantsLinesResult.toString() + result.toString();
    }

    private static int filteredUsageCount(Node node) {
        return node.usages().filter(n -> !(n instanceof FrameState)).count();
    }

    class HotSpotSnippetBytecodeParser
    extends BytecodeParser {
        HotSpotSnippetBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
        }

        @Override
        public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
            return plugin.isGeneratedFromFoldOrNodeIntrinsic();
        }

        @Override
        public boolean shouldDeferPlugin(GeneratedInvocationPlugin plugin) {
            return plugin.isGeneratedFromFoldOrNodeIntrinsic();
        }

        @Override
        protected boolean canInlinePartialIntrinsicExit() {
            return false;
        }

        @Override
        protected boolean tryInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
            if (this.intrinsicContext != null && this.intrinsicContext.isCallToOriginal(targetMethod)) {
                return false;
            }
            InvocationPlugin plugin = this.graphBuilderConfig.getPlugins().getInvocationPlugins().lookupInvocation(targetMethod);
            if (plugin != null && SymbolicSnippetEncoder.this.conditionalPlugins.contains((Object)plugin)) {
                throw new GraalError("conditional plugins are unsupported in snippets and method substitutions: " + targetMethod + " " + plugin);
            }
            return super.tryInvocationPlugin(invokeKind, args, targetMethod, resultType);
        }
    }

    class HotSpotSnippetGraphBuilderPhase
    extends GraphBuilderPhase.Instance {
        HotSpotSnippetGraphBuilderPhase(CoreProviders theProviders, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            super(theProviders, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        }

        @Override
        protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            return new HotSpotSnippetBytecodeParser(this, graph, parent, method, entryBCI, intrinsicContext);
        }
    }

    class SnippetGraphMaker
    extends ReplacementsImpl.GraphMaker {
        SnippetGraphMaker(ReplacementsImpl replacements, ResolvedJavaMethod substitute, ResolvedJavaMethod substitutedMethod) {
            super(replacements, substitute, substitutedMethod);
        }

        @Override
        protected GraphBuilderPhase.Instance createGraphBuilder(Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            return new HotSpotSnippetGraphBuilderPhase(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        }
    }

    class HotSpotSnippetReplacementsImpl
    extends HotSpotReplacementsImpl {
        HotSpotSnippetReplacementsImpl(HotSpotReplacementsImpl replacements, HotSpotProviders providers) {
            super(replacements, providers);
        }

        HotSpotSnippetReplacementsImpl(HotSpotProviders providers, SnippetReflectionProvider snippetReflection, BytecodeProvider bytecodeProvider, TargetDescription target) {
            super(providers, snippetReflection, bytecodeProvider, target);
        }

        @Override
        protected ReplacementsImpl.GraphMaker createGraphMaker(ResolvedJavaMethod substitute, ResolvedJavaMethod original) {
            return new SnippetGraphMaker(this, substitute, original);
        }

        @Override
        public boolean isEncodingSnippets() {
            return true;
        }
    }

    public static class HotSpotSubstrateConstantReflectionProvider
    implements ConstantReflectionProvider {
        private final ConstantReflectionProvider constantReflection;
        HashSet<JavaConstant> safeConstants = new HashSet();

        HotSpotSubstrateConstantReflectionProvider(ConstantReflectionProvider constantReflection) {
            this.constantReflection = constantReflection;
        }

        public Boolean constantEquals(Constant x, Constant y) {
            return this.constantReflection.constantEquals(x, y);
        }

        public Integer readArrayLength(JavaConstant array) {
            return this.constantReflection.readArrayLength(array);
        }

        public JavaConstant readArrayElement(JavaConstant array, int index) {
            return this.constantReflection.readArrayElement(array, index);
        }

        public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
            JavaConstant javaConstant = this.constantReflection.readFieldValue(field, receiver);
            if (!(this.safeConstants.contains(receiver) || field.getDeclaringClass().getName().contains("graalvm") || field.getDeclaringClass().getName().contains("jdk/vm/ci/") || field.getDeclaringClass().getName().contains("jdk/internal/vm/compiler") || field.getName().equals("TYPE"))) {
                return null;
            }
            if (javaConstant.getJavaKind() == JavaKind.Object) {
                this.safeConstants.add(javaConstant);
            }
            return javaConstant;
        }

        public JavaConstant boxPrimitive(JavaConstant source) {
            return this.constantReflection.boxPrimitive(source);
        }

        public JavaConstant unboxPrimitive(JavaConstant source) {
            return this.constantReflection.unboxPrimitive(source);
        }

        public JavaConstant forString(String value) {
            return this.constantReflection.forString(value);
        }

        public ResolvedJavaType asJavaType(Constant constant) {
            return this.constantReflection.asJavaType(constant);
        }

        public MethodHandleAccessProvider getMethodHandleAccess() {
            return this.constantReflection.getMethodHandleAccess();
        }

        public MemoryAccessProvider getMemoryAccessProvider() {
            return this.constantReflection.getMemoryAccessProvider();
        }

        public JavaConstant asJavaClass(ResolvedJavaType type) {
            return this.constantReflection.asJavaClass(type);
        }

        public Constant asObjectHub(ResolvedJavaType type) {
            return this.constantReflection.asObjectHub(type);
        }
    }

    private class SnippetCounterPlugin
    implements NodePlugin {
        String snippetCounterName = 'L' + SnippetCounter.class.getName().replace('.', '/') + ';';
        String snippetIntegerHistogramName = 'L' + SnippetIntegerHistogram.class.getName().replace('.', '/') + ';';

        private SnippetCounterPlugin() {
        }

        @Override
        public boolean handleLoadField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field) {
            if (field.getName().equals("group") && field.getDeclaringClass().getName().equals(this.snippetCounterName)) {
                b.addPush(JavaKind.Object, ConstantNode.forConstant(JavaConstant.NULL_POINTER, b.getMetaAccess()));
                return true;
            }
            if (field.getType().getName().equals(this.snippetCounterName)) {
                b.addPush(JavaKind.Object, ConstantNode.forConstant(((SymbolicSnippetEncoder)SymbolicSnippetEncoder.this).snippetReplacements.snippetReflection.forObject(SnippetCounter.DISABLED_COUNTER), b.getMetaAccess()));
                return true;
            }
            if (field.getType().getName().equals(this.snippetIntegerHistogramName)) {
                b.addPush(JavaKind.Object, ConstantNode.forConstant(((SymbolicSnippetEncoder)SymbolicSnippetEncoder.this).snippetReplacements.snippetReflection.forObject(SnippetIntegerHistogram.DISABLED_COUNTER), b.getMetaAccess()));
                return true;
            }
            return false;
        }
    }

    protected class SnippetInlineInvokePlugin
    implements InlineInvokePlugin {
        protected SnippetInlineInvokePlugin() {
        }

        @Override
        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            if (method.getAnnotation(Fold.class) != null) {
                SymbolicSnippetEncoder.this.delayedInvocationPluginMethods.add(method);
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_NO_EXCEPTION;
            }
            return InlineInvokePlugin.InlineInfo.createIntrinsicInlineInfo(method, SymbolicSnippetEncoder.this.snippetReplacements.getDefaultReplacementBytecodeProvider());
        }

        @Override
        public void notifyAfterInline(ResolvedJavaMethod methodToInline) {
            assert (methodToInline.getAnnotation(Fold.class) == null) : methodToInline;
        }
    }

    static class MethodSubstitutionKey
    extends GraphKey {
        final IntrinsicContext.CompilationContext context;
        final MethodSubstitutionPlugin plugin;

        MethodSubstitutionKey(ResolvedJavaMethod method, ResolvedJavaMethod original, IntrinsicContext.CompilationContext context, MethodSubstitutionPlugin plugin) {
            super(method, original);
            this.context = context;
            this.plugin = plugin;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodSubstitutionKey that = (MethodSubstitutionKey)o;
            return Objects.equals(this.original, that.original) && this.context == that.context && Objects.equals(this.plugin, that.plugin);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.original, this.context, this.plugin});
        }

        @Override
        public String keyString() {
            return this.plugin.toString() + (Object)((Object)this.context);
        }

        public String toString() {
            return "MethodSubstitutionKey{method=" + this.method + ", original=" + this.original + ", context=" + (Object)((Object)this.context) + ", plugin=" + this.plugin + '}';
        }
    }

    static class SnippetKey
    extends GraphKey {
        SnippetKey(ResolvedJavaMethod method, ResolvedJavaMethod original) {
            super(method, original);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnippetKey that = (SnippetKey)o;
            return Objects.equals(this.method, that.method) && Objects.equals(this.original, that.original);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.original);
        }

        @Override
        public String keyString() {
            return EncodedSnippets.methodKey(this.method);
        }

        public String toString() {
            return "SnippetKey{method=" + this.method + ", original=" + this.original + '}';
        }
    }

    static abstract class GraphKey {
        final ResolvedJavaMethod method;
        final ResolvedJavaMethod original;

        GraphKey(ResolvedJavaMethod method, ResolvedJavaMethod original) {
            this.method = method;
            this.original = original;
        }

        public abstract String keyString();
    }
}

