/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.hotspot.CompilationContext;
import org.graalvm.compiler.hotspot.EncodedSnippets;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.hotspot.SymbolicSnippetEncoder;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotWordOperationPlugin;
import org.graalvm.compiler.hotspot.word.HotSpotOperation;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.nodes.spi.SnippetParameterInfo;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.replacements.ReplacementsImpl;

public class HotSpotReplacementsImpl
extends ReplacementsImpl {
    @NativeImageReinitialize
    private EconomicSet<ResolvedJavaMethod> registeredSnippets = EconomicSet.create();
    private boolean snippetRegistrationClosed;
    private static volatile EncodedSnippets encodedSnippets;
    @NativeImageReinitialize
    private static SymbolicSnippetEncoder snippetEncoder;

    public HotSpotReplacementsImpl(HotSpotProviders providers, SnippetReflectionProvider snippetReflection, BytecodeProvider bytecodeProvider, TargetDescription target) {
        super(new GraalDebugHandlersFactory(snippetReflection), providers, snippetReflection, bytecodeProvider, target);
    }

    HotSpotReplacementsImpl(HotSpotReplacementsImpl replacements, HotSpotProviders providers) {
        super(new GraalDebugHandlersFactory(replacements.snippetReflection), providers, replacements.snippetReflection, replacements.getDefaultReplacementBytecodeProvider(), replacements.target);
    }

    @Override
    public HotSpotProviders getProviders() {
        return (HotSpotProviders)super.getProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void maybeInitializeEncoder(OptionValues options) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            return;
        }
        if (!Services.IS_BUILDING_NATIVE_IMAGE && !GraalOptions.UseEncodedGraphs.getValue(options).booleanValue()) return;
        Class<HotSpotReplacementsImpl> clazz = HotSpotReplacementsImpl.class;
        synchronized (HotSpotReplacementsImpl.class) {
            if (snippetEncoder != null) return;
            snippetEncoder = new SymbolicSnippetEncoder(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Class<? extends GraphBuilderPlugin> getIntrinsifyingPlugin(ResolvedJavaMethod method) {
        if (!Services.IS_IN_NATIVE_IMAGE && method.getAnnotation(HotSpotOperation.class) != null) {
            return HotSpotWordOperationPlugin.class;
        }
        return super.getIntrinsifyingPlugin(method);
    }

    @Override
    public void registerMethodSubstitution(MethodSubstitutionPlugin plugin) {
        if (!Services.IS_IN_NATIVE_IMAGE && snippetEncoder != null) {
            snippetEncoder.registerMethodSubstitution(plugin);
        }
    }

    @Override
    public void registerConditionalPlugin(InvocationPlugin plugin) {
        if (!Services.IS_IN_NATIVE_IMAGE && snippetEncoder != null) {
            snippetEncoder.registerConditionalPlugin(plugin);
        }
    }

    public void checkRegistered(MethodSubstitutionPlugin plugin) {
        snippetEncoder.checkRegistered(plugin);
    }

    @Override
    public StructuredGraph getIntrinsicGraph(ResolvedJavaMethod method, CompilationIdentifier compilationId, DebugContext debug, StructuredGraph.AllowAssumptions allowAssumptions, Cancellable cancellable) {
        boolean useEncodedGraphs = GraalOptions.UseEncodedGraphs.getValue(debug.getOptions());
        if (Services.IS_IN_NATIVE_IMAGE || useEncodedGraphs) {
            HotSpotReplacementsImpl replacements = (HotSpotReplacementsImpl)this.providers.getReplacements();
            InvocationPlugin plugin = replacements.getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation(method);
            if (plugin instanceof MethodSubstitutionPlugin) {
                MethodSubstitutionPlugin msp = (MethodSubstitutionPlugin)plugin;
                if (!Services.IS_IN_NATIVE_IMAGE && useEncodedGraphs) {
                    replacements.maybeInitializeEncoder(debug.getOptions());
                    replacements.registerMethodSubstitution(msp);
                }
                StructuredGraph methodSubstitution = replacements.getMethodSubstitution(msp, method, IntrinsicContext.CompilationContext.ROOT_COMPILATION, allowAssumptions, cancellable, debug.getOptions());
                methodSubstitution.resetDebug(debug);
                return methodSubstitution;
            }
            return null;
        }
        return super.getIntrinsicGraph(method, compilationId, debug, allowAssumptions, cancellable);
    }

    @Override
    public StructuredGraph getSubstitution(ResolvedJavaMethod targetMethod, int invokeBci, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
        InvocationPlugin plugin;
        boolean useEncodedGraphs = GraalOptions.UseEncodedGraphs.getValue(options);
        if ((Services.IS_IN_NATIVE_IMAGE || useEncodedGraphs) && (plugin = this.getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation(targetMethod)) instanceof MethodSubstitutionPlugin && (!plugin.inlineOnly() || invokeBci >= 0)) {
            MethodSubstitutionPlugin msPlugin = (MethodSubstitutionPlugin)plugin;
            if (!Services.IS_IN_NATIVE_IMAGE && useEncodedGraphs) {
                this.maybeInitializeEncoder(options);
                this.registerMethodSubstitution(msPlugin);
            }
            StructuredGraph subst = this.getMethodSubstitution(msPlugin, targetMethod, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING, allowAssumptions, null, options);
            return subst;
        }
        return super.getSubstitution(targetMethod, invokeBci, trackNodeSourcePosition, replaceePosition, allowAssumptions, options);
    }

    @Override
    public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod method, Invoke invoke) {
        if (!Services.IS_IN_NATIVE_IMAGE && b.parsingIntrinsic() && snippetEncoder != null && this.getIntrinsifyingPlugin(method) != null) {
            snippetEncoder.addDelayedInvocationPluginMethod(method);
            return;
        }
        super.notifyNotInlined(b, method, invoke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, Object receiver, boolean trackNodeSourcePosition, OptionValues options) {
        assert (method.isStatic() || receiver != null) : "must have a constant type for the receiver";
        if (Services.IS_IN_NATIVE_IMAGE) return;
        assert (!this.snippetRegistrationClosed) : "Cannot register snippet after registration is closed: " + method.format("%H.%n(%p)");
        assert (this.registeredSnippets.add((Object)method)) : "Cannot register snippet twice: " + method.format("%H.%n(%p)");
        if (!Services.IS_BUILDING_NATIVE_IMAGE && !GraalOptions.UseEncodedGraphs.getValue(options).booleanValue()) return;
        Class<HotSpotReplacementsImpl> clazz = HotSpotReplacementsImpl.class;
        synchronized (HotSpotReplacementsImpl.class) {
            snippetEncoder.registerSnippet(method, original, receiver, trackNodeSourcePosition, options);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public SnippetParameterInfo getSnippetParameterInfo(ResolvedJavaMethod method) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            OptionValues options = null;
            if (HotSpotReplacementsImpl.getEncodedSnippets(options) == null) {
                throw GraalError.shouldNotReachHere("encoded snippets not found");
            }
            return HotSpotReplacementsImpl.getEncodedSnippets(options).getSnippetParameterInfo(method);
        }
        return super.getSnippetParameterInfo(method);
    }

    @Override
    public boolean isSnippet(ResolvedJavaMethod method) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            if (encodedSnippets == null) {
                throw GraalError.shouldNotReachHere("encoded snippets not found");
            }
            return encodedSnippets.isSnippet(method);
        }
        return super.isSnippet(method);
    }

    @Override
    public void closeSnippetRegistration() {
        this.snippetRegistrationClosed = true;
    }

    public static EncodedSnippets getEncodedSnippets(OptionValues options) {
        if (!Services.IS_IN_NATIVE_IMAGE && snippetEncoder != null) {
            snippetEncoder.encode(options);
        }
        return encodedSnippets;
    }

    public void clearSnippetParameterNames() {
        assert (snippetEncoder != null);
        snippetEncoder.clearSnippetParameterNames();
    }

    static void setEncodedSnippets(EncodedSnippets encodedSnippets) {
        HotSpotReplacementsImpl.encodedSnippets = encodedSnippets;
    }

    public boolean encode(OptionValues options) {
        SymbolicSnippetEncoder encoder = snippetEncoder;
        if (encoder != null) {
            return encoder.encode(options);
        }
        return false;
    }

    @Override
    public StructuredGraph getSnippet(ResolvedJavaMethod method, ResolvedJavaMethod recursiveEntry, Object[] args, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, OptionValues options) {
        StructuredGraph graph = this.getEncodedSnippet(method, args, StructuredGraph.AllowAssumptions.NO, options);
        if (graph != null) {
            return graph;
        }
        assert (!Services.IS_IN_NATIVE_IMAGE) : "should be using encoded snippets";
        return super.getSnippet(method, recursiveEntry, args, trackNodeSourcePosition, replaceePosition, options);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StructuredGraph getEncodedSnippet(ResolvedJavaMethod method, Object[] args, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
        if (Services.IS_IN_NATIVE_IMAGE || GraalOptions.UseEncodedGraphs.getValue(options).booleanValue()) {
            Class<HotSpotReplacementsImpl> clazz = HotSpotReplacementsImpl.class;
            synchronized (HotSpotReplacementsImpl.class) {
                if (HotSpotReplacementsImpl.getEncodedSnippets(options) == null) {
                    throw GraalError.shouldNotReachHere("encoded snippets not found");
                }
                try (CompilationContext scope = HotSpotGraalServices.enterGlobalCompilationContext();){
                    StructuredGraph graph = HotSpotReplacementsImpl.getEncodedSnippets(options).getEncodedSnippet(method, this, args, allowAssumptions, options);
                    if (graph == null) {
                        throw GraalError.shouldNotReachHere("snippet not found: " + method.format("%H.%n(%p)"));
                    }
                    StructuredGraph structuredGraph = graph;
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return structuredGraph;
                }
            }
        }
        assert (this.registeredSnippets == null || this.registeredSnippets.contains((Object)method)) : "Asking for snippet method that was never registered: " + method.format("%H.%n(%p)");
        return null;
    }

    @Override
    public StructuredGraph getMethodSubstitution(MethodSubstitutionPlugin plugin, ResolvedJavaMethod original, IntrinsicContext.CompilationContext context, StructuredGraph.AllowAssumptions allowAssumptions, Cancellable cancellable, OptionValues options) {
        if (Services.IS_IN_NATIVE_IMAGE || GraalOptions.UseEncodedGraphs.getValue(options).booleanValue()) {
            if (HotSpotReplacementsImpl.getEncodedSnippets(options) == null) {
                throw GraalError.shouldNotReachHere("encoded snippets not found");
            }
            return HotSpotReplacementsImpl.getEncodedSnippets(options).getMethodSubstitutionGraph(plugin, original, this, context, allowAssumptions, cancellable, options);
        }
        return null;
    }

    @Override
    public <T> T getInjectedArgument(Class<T> capability) {
        if (capability.equals(GraalHotSpotVMConfig.class)) {
            return (T)this.getProviders().getConfig();
        }
        return super.getInjectedArgument(capability);
    }
}

