/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.debug.GraalError;

public final class HotSpotMarkId
extends Enum<HotSpotMarkId>
implements CompilationResult.MarkId {
    public static final /* enum */ HotSpotMarkId VERIFIED_ENTRY = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId UNVERIFIED_ENTRY = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId OSR_ENTRY = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId EXCEPTION_HANDLER_ENTRY = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId DEOPT_HANDLER_ENTRY = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId DEOPT_MH_HANDLER_ENTRY = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId FRAME_COMPLETE = new HotSpotMarkId(true, true);
    public static final /* enum */ HotSpotMarkId INVOKEINTERFACE = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId INVOKEVIRTUAL = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId INVOKESTATIC = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId INVOKESPECIAL = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId INLINE_INVOKE = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId POLL_NEAR = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId POLL_RETURN_NEAR = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId POLL_FAR = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId POLL_RETURN_FAR = new HotSpotMarkId(false);
    public static final /* enum */ HotSpotMarkId CARD_TABLE_ADDRESS = new HotSpotMarkId(true);
    public static final /* enum */ HotSpotMarkId NARROW_KLASS_BASE_ADDRESS = new HotSpotMarkId(true);
    public static final /* enum */ HotSpotMarkId NARROW_OOP_BASE_ADDRESS = new HotSpotMarkId(true);
    public static final /* enum */ HotSpotMarkId CRC_TABLE_ADDRESS = new HotSpotMarkId(true);
    public static final /* enum */ HotSpotMarkId LOG_OF_HEAP_REGION_GRAIN_BYTES = new HotSpotMarkId(true);
    private final boolean isMarkAfter;
    @NativeImageReinitialize
    private Integer value;
    private final boolean optional;
    private static final /* synthetic */ HotSpotMarkId[] $VALUES;

    public static HotSpotMarkId[] values() {
        return (HotSpotMarkId[])$VALUES.clone();
    }

    public static HotSpotMarkId valueOf(String name) {
        return Enum.valueOf(HotSpotMarkId.class, name);
    }

    private HotSpotMarkId(boolean isMarkAfter) {
        this(isMarkAfter, false);
    }

    private HotSpotMarkId(boolean isMarkAfter, boolean optional) {
        this.isMarkAfter = isMarkAfter;
        this.optional = optional;
    }

    private Integer getValue() {
        if (this.value == null) {
            Long result = (Long)HotSpotJVMCIRuntime.runtime().getConfigStore().getConstants().get("CodeInstaller::" + this.name());
            if (result != null) {
                this.value = result.intValue();
            } else if (!this.optional) {
                throw GraalError.shouldNotReachHere("Unsupported Mark " + this.name());
            }
        }
        return this.value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Object getId() {
        assert (this.isAvailable()) : this;
        return this.getValue();
    }

    @Override
    public boolean isMarkAfter() {
        return this.isMarkAfter;
    }

    public boolean isAvailable() {
        return this.getValue() != null;
    }

    public String toString() {
        return "HotSpotCodeMark{" + this.name() + ", value=" + this.getValue() + ", optional=" + this.optional + '}';
    }

    static {
        $VALUES = new HotSpotMarkId[]{VERIFIED_ENTRY, UNVERIFIED_ENTRY, OSR_ENTRY, EXCEPTION_HANDLER_ENTRY, DEOPT_HANDLER_ENTRY, DEOPT_MH_HANDLER_ENTRY, FRAME_COMPLETE, INVOKEINTERFACE, INVOKEVIRTUAL, INVOKESTATIC, INVOKESPECIAL, INLINE_INVOKE, POLL_NEAR, POLL_RETURN_NEAR, POLL_FAR, POLL_RETURN_FAR, CARD_TABLE_ADDRESS, NARROW_KLASS_BASE_ADDRESS, NARROW_OOP_BASE_ADDRESS, CRC_TABLE_ADDRESS, LOG_OF_HEAP_REGION_GRAIN_BYTES};
    }
}

