/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.runtime.JVMCIBackend;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.CompilationListenerProfiler;
import org.graalvm.compiler.core.common.CompilerProfiler;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.debug.GlobalMetrics;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.AOTGraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.CompilationStatistics;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigAccess;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotBackendFactory;
import org.graalvm.compiler.hotspot.HotSpotCompilationIdentifier;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotGraalManagementRegistration;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.Instrumentation;
import org.graalvm.compiler.hotspot.WeakClassLoaderSet;
import org.graalvm.compiler.hotspot.debug.BenchmarkCounters;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.options.EnumOptionKey;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.runtime.RuntimeProvider;
import org.graalvm.compiler.serviceprovider.GraalServices;

public final class HotSpotGraalRuntime
implements HotSpotGraalRuntimeProvider {
    private static final boolean IS_AOT = Boolean.parseBoolean((String)Services.getSavedProperties().get("com.oracle.graalvm.isaot"));
    private static final Supplier<HotSpotGraalManagementRegistration> AOT_INJECTED_MANAGEMENT = null;
    private final String runtimeName;
    private final String compilerConfigurationName;
    private final HotSpotBackend hostBackend;
    private final GlobalMetrics metricValues = new GlobalMetrics();
    private final List<SnippetCounter.Group> snippetCounterGroups;
    private final HotSpotGC garbageCollector;
    private final EconomicMap<Class<? extends Architecture>, HotSpotBackend> backends = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    private final GraalHotSpotVMConfig config;
    private final Instrumentation instrumentation;
    private AtomicReference<OptionValues> optionsRef = new AtomicReference();
    private final DiagnosticsOutputDirectory outputDirectory;
    private final Map<CompilationWrapper.ExceptionAction, Integer> compilationProblemsPerAction;
    private final CompilerProfiler compilerProfiler;
    private long runtimeStartTime;
    private volatile boolean shutdown;
    private List<Runnable> shutdownHooks = new ArrayList<Runnable>();
    private final boolean bootstrapJVMCI;
    private boolean bootstrapFinished;
    private HotSpotGraalManagementRegistration management;
    private final WeakClassLoaderSet loaders = new WeakClassLoaderSet(ClassLoader.getSystemClassLoader());

    private static boolean checkArrayIndexScaleInvariants(MetaAccessProvider metaAccess) {
        assert (metaAccess.getArrayIndexScale(JavaKind.Byte) == 1);
        assert (metaAccess.getArrayIndexScale(JavaKind.Boolean) == 1);
        assert (metaAccess.getArrayIndexScale(JavaKind.Char) == 2);
        assert (metaAccess.getArrayIndexScale(JavaKind.Short) == 2);
        assert (metaAccess.getArrayIndexScale(JavaKind.Int) == 4);
        assert (metaAccess.getArrayIndexScale(JavaKind.Long) == 8);
        assert (metaAccess.getArrayIndexScale(JavaKind.Float) == 4);
        assert (metaAccess.getArrayIndexScale(JavaKind.Double) == 8);
        return true;
    }

    public GlobalMetrics getMetricValues() {
        return this.metricValues;
    }

    HotSpotGraalRuntime(String nameQualifier, HotSpotJVMCIRuntime jvmciRuntime, CompilerConfigurationFactory compilerConfigurationFactory, OptionValues initialOptions) {
        Object jvmciBackend2;
        this.runtimeName = this.getClass().getSimpleName() + ":" + nameQualifier;
        HotSpotVMConfigStore store = jvmciRuntime.getConfigStore();
        GraalHotSpotVMConfig graalHotSpotVMConfig = this.config = GraalOptions.GeneratePIC.getValue(initialOptions) != false ? new AOTGraalHotSpotVMConfig(store) : new GraalHotSpotVMConfig(store);
        if (!GraalOptions.HotSpotPrintInlining.getValue(initialOptions).booleanValue() && this.config.printInlining) {
            this.optionsRef.set(new OptionValues(initialOptions, GraalOptions.HotSpotPrintInlining, true, new Object[0]));
        } else {
            this.optionsRef.set(initialOptions);
        }
        OptionValues options = this.optionsRef.get();
        this.garbageCollector = this.getSelectedGC();
        this.outputDirectory = new DiagnosticsOutputDirectory(options);
        this.compilationProblemsPerAction = new EnumMap<CompilationWrapper.ExceptionAction, Integer>(CompilationWrapper.ExceptionAction.class);
        this.snippetCounterGroups = GraalOptions.SnippetCounters.getValue(options) != false ? new ArrayList() : null;
        CompilerConfiguration compilerConfiguration = compilerConfigurationFactory.createCompilerConfiguration();
        this.compilerConfigurationName = compilerConfigurationFactory.getName();
        this.instrumentation = compilerConfigurationFactory.createInstrumentation(options);
        this.management = IS_AOT ? (AOT_INJECTED_MANAGEMENT == null ? null : AOT_INJECTED_MANAGEMENT.get()) : GraalServices.loadSingle(HotSpotGraalManagementRegistration.class, false);
        if (this.management != null) {
            try {
                this.management.initialize(this, this.config);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable error) {
                TTY.println("Cannot install GraalVM MBean due to " + error.getMessage());
                this.management = null;
            }
        }
        CompilerConfigurationFactory.BackendMap backendMap = compilerConfigurationFactory.createBackendMap();
        JVMCIBackend hostJvmciBackend = jvmciRuntime.getHostJVMCIBackend();
        Architecture hostArchitecture = hostJvmciBackend.getTarget().arch;
        try (InitTimer t = InitTimer.timer((String)"create backend:", (Object)hostArchitecture);){
            HotSpotBackendFactory factory = backendMap.getBackendFactory(hostArchitecture);
            if (factory == null) {
                throw new GraalError("No backend available for host architecture \"%s\"", hostArchitecture);
            }
            this.hostBackend = this.registerBackend(factory.createBackend(this, compilerConfiguration, jvmciRuntime, null));
        }
        for (Object jvmciBackend2 : jvmciRuntime.getJVMCIBackends().values()) {
            if (jvmciBackend2 == hostJvmciBackend) continue;
            Architecture gpuArchitecture = jvmciBackend2.getTarget().arch;
            HotSpotBackendFactory factory = backendMap.getBackendFactory(gpuArchitecture);
            if (factory == null) {
                throw new GraalError("No backend available for specified GPU architecture \"%s\"", gpuArchitecture);
            }
            InitTimer t = InitTimer.timer((String)"create backend:", (Object)gpuArchitecture);
            Throwable throwable = null;
            try {
                this.registerBackend(factory.createBackend(this, compilerConfiguration, null, this.hostBackend));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (t == null) continue;
                if (throwable != null) {
                    try {
                        t.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                t.close();
            }
        }
        InitTimer st = InitTimer.timer((String)this.hostBackend.getTarget().arch.getName(), (Object)".completeInitialization");
        jvmciBackend2 = null;
        try {
            this.hostBackend.completeInitialization(jvmciRuntime, options);
        }
        catch (Throwable gpuArchitecture) {
            jvmciBackend2 = gpuArchitecture;
            throw gpuArchitecture;
        }
        finally {
            if (st != null) {
                if (jvmciBackend2 != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable gpuArchitecture) {
                        ((Throwable)jvmciBackend2).addSuppressed(gpuArchitecture);
                    }
                } else {
                    st.close();
                }
            }
        }
        for (HotSpotBackend backend : this.backends.getValues()) {
            if (backend == this.hostBackend) continue;
            InitTimer st2 = InitTimer.timer((String)backend.getTarget().arch.getName(), (Object)".completeInitialization");
            Throwable throwable = null;
            try {
                backend.completeInitialization(jvmciRuntime, options);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (st2 == null) continue;
                if (throwable != null) {
                    try {
                        st2.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                st2.close();
            }
        }
        BenchmarkCounters.initialize(jvmciRuntime, options);
        assert (HotSpotGraalRuntime.checkArrayIndexScaleInvariants(hostJvmciBackend.getMetaAccess()));
        this.runtimeStartTime = System.nanoTime();
        this.bootstrapJVMCI = this.config.getFlag("BootstrapJVMCI", Boolean.class);
        this.compilerProfiler = GraalServices.loadSingle(CompilerProfiler.class, false);
    }

    private HotSpotGC getSelectedGC() throws GraalError {
        HotSpotGC selected = null;
        for (HotSpotGC gc : HotSpotGC.values()) {
            if (!gc.isSelected(this.config)) continue;
            if (!gc.supported) {
                throw new GraalError(gc.name() + " garbage collector is not supported by Graal");
            }
            selected = gc;
            if (!Assertions.assertionsEnabled()) break;
        }
        if (selected == null) {
            selected = HotSpotGC.Serial;
        }
        return selected;
    }

    private HotSpotBackend registerBackend(HotSpotBackend backend) {
        Class<?> arch = backend.getTarget().arch.getClass();
        HotSpotBackend oldValue = (HotSpotBackend)this.backends.put(arch, (Object)backend);
        assert (oldValue == null) : "cannot overwrite existing backend for architecture " + arch.getSimpleName();
        return backend;
    }

    @Override
    public HotSpotProviders getHostProviders() {
        return this.getHostBackend().getProviders();
    }

    @Override
    public GraalHotSpotVMConfig getVMConfig() {
        return this.config;
    }

    @Override
    public DebugContext openDebugContext(OptionValues compilationOptions, CompilationIdentifier compilationId, Object compilable, Iterable<DebugHandlersFactory> factories, PrintStream logStream) {
        Class clazz;
        HotSpotResolvedObjectType type;
        if (this.management != null && this.management.poll(false) != null && compilable instanceof HotSpotResolvedJavaMethod && (type = ((HotSpotResolvedJavaMethod)compilable).getDeclaringClass()) instanceof HotSpotResolvedJavaType && (clazz = HotSpotJVMCIRuntime.runtime().getMirror((ResolvedJavaType)type)) != null) {
            try {
                ClassLoader cl = clazz.getClassLoader();
                if (cl != null) {
                    this.loaders.add(cl);
                }
            }
            catch (SecurityException cl) {
                // empty catch block
            }
        }
        DebugContext.Description description = new DebugContext.Description(compilable, compilationId.toString(CompilationIdentifier.Verbosity.ID));
        DebugContext.Builder builder = new DebugContext.Builder(compilationOptions, factories).globalMetrics(this.metricValues).description(description).logStream(logStream);
        if (this.compilerProfiler != null) {
            int compileId = ((HotSpotCompilationIdentifier)compilationId).getRequest().getId();
            builder.compilationListener(new CompilationListenerProfiler(this.compilerProfiler, compileId));
        }
        return builder.build();
    }

    @Override
    public OptionValues getOptions() {
        return this.optionsRef.get();
    }

    @Override
    public SnippetCounter.Group createSnippetCounterGroup(String groupName) {
        if (this.snippetCounterGroups != null) {
            SnippetCounter.Group group = new SnippetCounter.Group(groupName);
            this.snippetCounterGroups.add(group);
            return group;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.runtimeName;
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        if (clazz == RuntimeProvider.class) {
            return (T)this;
        }
        if (clazz == OptionValues.class) {
            return (T)this.optionsRef.get();
        }
        if (clazz == StackIntrospection.class) {
            return (T)this;
        }
        if (clazz == SnippetReflectionProvider.class) {
            return (T)this.getHostProviders().getSnippetReflection();
        }
        if (clazz == GraalHotSpotVMConfig.class) {
            return (T)this.getVMConfig();
        }
        if (clazz == StampProvider.class) {
            return (T)this.getHostProviders().getStampProvider();
        }
        if (ForeignCallsProvider.class.isAssignableFrom(clazz)) {
            return (T)this.getHostProviders().getForeignCalls();
        }
        return null;
    }

    @Override
    public HotSpotGC getGarbageCollector() {
        return this.garbageCollector;
    }

    @Override
    public HotSpotBackend getHostBackend() {
        return this.hostBackend;
    }

    @Override
    public <T extends Architecture> Backend getBackend(Class<T> arch) {
        assert (arch != Architecture.class);
        return (Backend)this.backends.get(arch);
    }

    @Override
    public String getCompilerConfigurationName() {
        return this.compilerConfigurationName;
    }

    @Override
    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    void phaseTransition(String phase) {
        if (CompilationStatistics.Options.UseCompilationStatistics.getValue(this.optionsRef.get()).booleanValue()) {
            CompilationStatistics.clear(phase);
        }
    }

    public synchronized void addShutdownHook(Runnable hook) {
        if (!this.shutdown) {
            this.shutdownHooks.add(hook);
        }
    }

    synchronized void shutdown() {
        this.shutdown = true;
        for (Runnable r : this.shutdownHooks) {
            try {
                r.run();
            }
            catch (Throwable e) {
                e.printStackTrace(TTY.out);
            }
        }
        this.metricValues.print(this.optionsRef.get());
        this.phaseTransition("final");
        if (this.snippetCounterGroups != null) {
            for (SnippetCounter.Group group : this.snippetCounterGroups) {
                TTY.out().out().println(group);
            }
        }
        BenchmarkCounters.shutdown(HotSpotJVMCIRuntime.runtime(), this.optionsRef.get(), this.runtimeStartTime);
        this.outputDirectory.close();
        HotSpotGraalRuntime.shutdownLibGraal();
    }

    private static void shutdownLibGraal() {
    }

    void clearMetrics() {
        this.metricValues.clear();
    }

    public void notifyBootstrapFinished() {
        this.bootstrapFinished = true;
    }

    @Override
    public boolean isBootstrapping() {
        return this.bootstrapJVMCI && !this.bootstrapFinished;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public DiagnosticsOutputDirectory getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction() {
        return this.compilationProblemsPerAction;
    }

    public HotSpotGraalManagementRegistration getManagement() {
        return this.management;
    }

    public String[] setOptionValues(String[] names, String[] values) {
        OptionValues newOptions;
        OptionValues currentOptions;
        EconomicMap<String, OptionDescriptor> optionDescriptors = HotSpotGraalRuntime.getOptionDescriptors();
        EconomicMap newValues = EconomicMap.create((int)names.length);
        EconomicSet resetValues = EconomicSet.create((int)names.length);
        String[] result = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            OptionDescriptor option = (OptionDescriptor)optionDescriptors.get((Object)name);
            if (option != null) {
                String valueToParse;
                String svalue = values[i];
                Class<?> optionValueType = option.getOptionValueType();
                OptionKey<?> optionKey = option.getOptionKey();
                if (svalue == null || svalue.isEmpty() && !(optionKey instanceof EnumOptionKey)) {
                    resetValues.add(optionKey);
                    result[i] = name;
                    continue;
                }
                if (optionValueType == String.class) {
                    if (svalue.length() < 2 || svalue.charAt(0) != '\"' || svalue.charAt(svalue.length() - 1) != '\"') {
                        result[i] = "Invalid value for String option '" + name + "': must be the empty string or be enclosed in double quotes: " + svalue;
                        continue;
                    }
                    valueToParse = svalue.substring(1, svalue.length() - 1);
                } else {
                    valueToParse = svalue;
                }
                try {
                    OptionsParser.parseOption(name, valueToParse, newValues, OptionsParser.getOptionsLoader());
                    result[i] = name;
                }
                catch (IllegalArgumentException e) {
                    result[i] = e.getMessage();
                }
                continue;
            }
            result[i] = null;
        }
        do {
            currentOptions = this.optionsRef.get();
            UnmodifiableMapCursor cursor = currentOptions.getMap().getEntries();
            while (cursor.advance()) {
                OptionKey key = (OptionKey)cursor.getKey();
                if (resetValues.contains((Object)key) || newValues.containsKey((Object)key)) continue;
                newValues.put((Object)key, OptionValues.decodeNull(cursor.getValue()));
            }
        } while (!this.optionsRef.compareAndSet(currentOptions, newOptions = new OptionValues((UnmodifiableEconomicMap<OptionKey<?>, Object>)newValues)));
        return result;
    }

    public String[] getOptionValues(String ... names) {
        String[] values = new String[names.length];
        EconomicMap<String, OptionDescriptor> optionDescriptors = HotSpotGraalRuntime.getOptionDescriptors();
        for (int i = 0; i < names.length; ++i) {
            OptionDescriptor option = (OptionDescriptor)optionDescriptors.get((Object)names[i]);
            if (option != null) {
                OptionKey<?> optionKey = option.getOptionKey();
                Object value = optionKey.getValue(this.getOptions());
                String svalue = option.getOptionValueType() == String.class && value != null ? "\"" + value + "\"" : (value == null ? "" : String.valueOf(value));
                values[i] = svalue;
                continue;
            }
            values[i] = null;
        }
        return values;
    }

    private static EconomicMap<String, OptionDescriptor> getOptionDescriptors() {
        EconomicMap result = EconomicMap.create();
        for (OptionDescriptors set : OptionsParser.getOptionsLoader()) {
            for (OptionDescriptor option : set) {
                result.put((Object)option.getName(), (Object)option);
            }
        }
        return result;
    }

    private void dumpMethod(String className, String methodName, String filter, String host, int port) throws Exception {
        EconomicSet failures = EconomicSet.create();
        EconomicSet<Class<?>> found = this.loaders.resolve(className, (EconomicSet<ClassNotFoundException>)failures);
        if (found.isEmpty()) {
            ClassNotFoundException cause = failures.isEmpty() ? new ClassNotFoundException(className) : (ClassNotFoundException)failures.iterator().next();
            throw new Exception("Cannot find class " + className + " to schedule recompilation", cause);
        }
        for (Class clazz : found) {
            ResolvedJavaType type = JVMCI.getRuntime().getHostJVMCIBackend().getMetaAccess().lookupJavaType(clazz);
            for (ResolvedJavaMethod method : type.getDeclaredMethods()) {
                if (!methodName.equals(method.getName()) || !(method instanceof HotSpotResolvedJavaMethod)) continue;
                HotSpotResolvedJavaMethod hotSpotMethod = (HotSpotResolvedJavaMethod)method;
                this.dumpMethod(hotSpotMethod, filter, host, port);
            }
        }
    }

    private void dumpMethod(HotSpotResolvedJavaMethod hotSpotMethod, String filter, String host, int port) throws Exception {
        EconomicMap extra = EconomicMap.create();
        extra.put(DebugOptions.Dump, (Object)filter);
        extra.put(DebugOptions.PrintGraphHost, (Object)host);
        extra.put(DebugOptions.PrintGraphPort, (Object)port);
        OptionValues compileOptions = new OptionValues(this.getOptions(), (UnmodifiableEconomicMap<OptionKey<?>, Object>)extra);
        HotSpotGraalCompiler compiler = (HotSpotGraalCompiler)HotSpotJVMCIRuntime.runtime().getCompiler();
        compiler.compileMethod((CompilationRequest)new HotSpotCompilationRequest(hotSpotMethod, -1, 0L), false, compileOptions);
    }

    public Object invokeManagementAction(String actionName, Object[] params) throws Exception {
        if ("dumpMethod".equals(actionName)) {
            if (params.length != 0 && params[0] instanceof HotSpotResolvedJavaMethod) {
                HotSpotResolvedJavaMethod method = HotSpotGraalRuntime.param(params, 0, "method", HotSpotResolvedJavaMethod.class, null);
                String filter = HotSpotGraalRuntime.param(params, 1, "filter", String.class, ":3");
                String host = HotSpotGraalRuntime.param(params, 2, "host", String.class, "localhost");
                Number port = HotSpotGraalRuntime.param(params, 3, "port", Number.class, 4445);
                this.dumpMethod(method, filter, host, port.intValue());
            } else {
                String className = HotSpotGraalRuntime.param(params, 0, "className", String.class, null);
                String methodName = HotSpotGraalRuntime.param(params, 1, "methodName", String.class, null);
                String filter = HotSpotGraalRuntime.param(params, 2, "filter", String.class, ":3");
                String host = HotSpotGraalRuntime.param(params, 3, "host", String.class, "localhost");
                Number port = HotSpotGraalRuntime.param(params, 4, "port", Number.class, 4445);
                this.dumpMethod(className, methodName, filter, host, port.intValue());
            }
        }
        return null;
    }

    private static <T> T param(Object[] arr, int index, String name, Class<T> type, T defaultValue) {
        Object value;
        Object object = value = arr.length > index ? arr[index] : null;
        if (value == null || value instanceof String && ((String)value).isEmpty()) {
            if (defaultValue == null) {
                throw new IllegalArgumentException(name + " must be specified");
            }
            value = defaultValue;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw new IllegalArgumentException("Expecting " + type.getName() + " for " + name + " but was " + value);
    }

    public static enum HotSpotGC {
        Serial(true, "UseSerialGC", true),
        Parallel(true, "UseParallelGC", true, "UseParallelOldGC", GraalHotSpotVMConfigAccess.JDK < 15, "UseParNewGC", GraalHotSpotVMConfigAccess.JDK < 10),
        CMS(true, "UseConcMarkSweepGC", GraalHotSpotVMConfigAccess.JDK < 14),
        G1(true, "UseG1GC", true),
        Epsilon(false, "UseEpsilonGC", GraalHotSpotVMConfigAccess.JDK >= 11),
        Z(false, "UseZGC", GraalHotSpotVMConfigAccess.JDK >= 11);

        final boolean supported;
        final boolean[] expectFlagsPresent;
        private final String[] flags;

        private HotSpotGC(boolean supported, String flag1, boolean expectFlagPresent1, String flag2, boolean expectFlagPresent2, String flag3, boolean expectFlagPresent3) {
            this.supported = supported;
            this.expectFlagsPresent = new boolean[]{expectFlagPresent1, expectFlagPresent2, expectFlagPresent3};
            this.flags = new String[]{flag1, flag2, flag3};
        }

        private HotSpotGC(boolean supported, String flag, boolean expectFlagPresent) {
            this.supported = supported;
            this.expectFlagsPresent = new boolean[]{expectFlagPresent};
            this.flags = new String[]{flag};
        }

        public boolean isSelected(GraalHotSpotVMConfig config) {
            boolean selected = false;
            for (int i = 0; i < this.flags.length; ++i) {
                boolean notPresent = false;
                if (!config.getFlag(this.flags[i], Boolean.class, false, this.expectFlagsPresent[i]).booleanValue()) continue;
                selected = true;
                if (!Assertions.assertionsEnabled()) break;
            }
            return selected;
        }
    }
}

