/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.ArrayList;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.StackLockValue;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.Bytecodes;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.gen.DebugInfoBuilder;
import org.graalvm.compiler.graph.GraalGraphError;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.HotSpotLockStack;
import org.graalvm.compiler.hotspot.meta.DefaultHotSpotLoweringProvider;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.NodeValueMap;
import org.graalvm.compiler.nodes.spi.NodeWithState;

public class HotSpotDebugInfoBuilder
extends DebugInfoBuilder {
    private final HotSpotLockStack lockStack;
    private int maxInterpreterFrameSize;
    private HotSpotCodeCacheProvider codeCacheProvider;

    public HotSpotDebugInfoBuilder(NodeValueMap nodeValueMap, HotSpotLockStack lockStack, HotSpotLIRGenerator gen) {
        super(nodeValueMap, gen.getProviders().getMetaAccessExtensionProvider(), gen.getResult().getLIR().getDebug());
        this.lockStack = lockStack;
        this.codeCacheProvider = gen.getProviders().getCodeCache();
    }

    public HotSpotLockStack lockStack() {
        return this.lockStack;
    }

    public int maxInterpreterFrameSize() {
        return this.maxInterpreterFrameSize;
    }

    @Override
    protected JavaValue computeLockValue(FrameState state, int lockIndex) {
        boolean eliminated;
        int lockDepth = lockIndex;
        if (state.outerFrameState() != null) {
            lockDepth += state.outerFrameState().nestedLockDepth();
        }
        VirtualStackSlot slot = this.lockStack.makeLockSlot(lockDepth);
        ValueNode lock = state.lockAt(lockIndex);
        JavaValue object = this.toJavaValue(lock);
        boolean bl = eliminated = object instanceof VirtualObject || state.monitorIdAt(lockIndex).isEliminated();
        assert (state.monitorIdAt(lockIndex).getLockDepth() == lockDepth);
        return new StackLockValue(object, (AllocatableValue)slot, eliminated);
    }

    @Override
    protected boolean verifyFrameState(NodeWithState node, FrameState topState) {
        ForeignCallNode call;
        ForeignCallDescriptor descriptor;
        if (node instanceof FullInfopointNode) {
            return true;
        }
        if (node instanceof ForeignCallNode && DefaultHotSpotLoweringProvider.RuntimeCalls.runtimeCalls.containsValue((descriptor = (call = (ForeignCallNode)node).getDescriptor()).getSignature())) {
            return true;
        }
        if (topState.bci >= 0 && !topState.duringCall() && !topState.rethrowException()) {
            ResolvedJavaMethod m = topState.getMethod();
            int opcode = m.getCode()[topState.bci] & 0xFF;
            if (opcode == 182 || opcode == 185) {
                assert (topState.stackSize() > 0) : "expected non-empty stack: " + topState;
            } else {
                int stackEffect = Bytecodes.stackEffectOf(opcode);
                if (stackEffect < 0) assert (topState.stackSize() >= -stackEffect) : "expected at least " + -stackEffect + " stack depth : " + topState;
            }
        }
        if (node instanceof DeoptimizeNode) assert (!topState.duringCall()) : topState.toString(Verbosity.Debugger);
        return true;
    }

    @Override
    protected BytecodeFrame computeFrameForState(NodeWithState node, FrameState state) {
        if (BytecodeFrame.isPlaceholderBci((int)state.bci) && state.bci != -2) {
            this.raiseInvalidFrameStateError(state);
        }
        BytecodeFrame result = super.computeFrameForState(node, state);
        this.maxInterpreterFrameSize = Math.max(this.maxInterpreterFrameSize, this.codeCacheProvider.interpreterFrameSize(result));
        return result;
    }

    protected void raiseInvalidFrameStateError(FrameState state) throws GraalGraphError {
        NodeSourcePosition sourcePosition = state.getNodeSourcePosition();
        ArrayList<String> context = new ArrayList<String>();
        ResolvedJavaMethod replacementMethodWithProblematicSideEffect = null;
        if (sourcePosition != null) {
            for (NodeSourcePosition pos = sourcePosition; pos != null; pos = pos.getCaller()) {
                StringBuilder sb = new StringBuilder("parsing ");
                ResolvedJavaMethod method = pos.getMethod();
                MetaUtil.appendLocation((StringBuilder)sb, (ResolvedJavaMethod)method, (int)pos.getBCI());
                if (pos.isSubstitution()) {
                    replacementMethodWithProblematicSideEffect = method;
                }
                context.add(sb.toString());
            }
        }
        String message = "Invalid frame state " + state;
        if (replacementMethodWithProblematicSideEffect != null) {
            message = message + " associated with a side effect in " + replacementMethodWithProblematicSideEffect.format("%H.%n(%p)") + " at a position that cannot be deoptimized to";
        }
        GraalGraphError error = new GraalGraphError(message, new Object[0]);
        for (String c : context) {
            error.addContext(c);
        }
        throw error;
    }
}

