/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.EnumSet;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.HotSpotCompilationIdentifier;
import org.graalvm.compiler.hotspot.HotSpotCompiledCodeBuilder;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotInstructionProfiling;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerationResult;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.hotspot.word.MethodCountersPointer;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.ValueConsumer;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.SuitesProvider;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

public abstract class HotSpotBackend
extends Backend
implements FrameMap.ReferenceMapBuilderFactory {
    public static final HotSpotForeignCallDescriptor EXCEPTION_HANDLER = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "exceptionHandler", Void.TYPE, Object.class, Word.class);
    public static final HotSpotForeignCallDescriptor IC_MISS_HANDLER = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "icMissHandler", Void.TYPE, new Class[0]);
    public static final HotSpotForeignCallDescriptor WRONG_METHOD_HANDLER = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "wrongMethodHandler", Void.TYPE, new Class[0]);
    public static final HotSpotForeignCallDescriptor UNWIND_EXCEPTION_TO_CALLER = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "unwindExceptionToCaller", Void.TYPE, Object.class, Word.class);
    public static final HotSpotForeignCallDescriptor EXCEPTION_HANDLER_IN_CALLER = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "exceptionHandlerInCaller", Void.TYPE, Object.class, Word.class);
    private final HotSpotGraalRuntimeProvider runtime;
    public static final HotSpotForeignCallDescriptor ENCRYPT_BLOCK = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte), "encrypt_block", Void.TYPE, Word.class, Word.class, Pointer.class);
    public static final HotSpotForeignCallDescriptor DECRYPT_BLOCK = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte), "decrypt_block", Void.TYPE, Word.class, Word.class, Pointer.class);
    public static final HotSpotForeignCallDescriptor DECRYPT_BLOCK_WITH_ORIGINAL_KEY = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte), "decrypt_block_with_original_key", Void.TYPE, Word.class, Word.class, Pointer.class, Pointer.class);
    public static final HotSpotForeignCallDescriptor ENCRYPT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte), "encrypt", Void.TYPE, Word.class, Word.class, Pointer.class, Pointer.class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor DECRYPT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte), "decrypt", Void.TYPE, Word.class, Word.class, Pointer.class, Pointer.class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor DECRYPT_WITH_ORIGINAL_KEY = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte), "decrypt_with_original_key", Void.TYPE, Word.class, Word.class, Pointer.class, Pointer.class, Integer.TYPE, Pointer.class);
    public static final HotSpotForeignCallDescriptor MULTIPLY_TO_LEN = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Int), "multiplyToLen", Void.TYPE, Word.class, Integer.TYPE, Word.class, Integer.TYPE, Word.class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor MUL_ADD = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Int), "mulAdd", Integer.TYPE, Word.class, Word.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor MONTGOMERY_MULTIPLY = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Int), "implMontgomeryMultiply", Void.TYPE, Word.class, Word.class, Word.class, Integer.TYPE, Long.TYPE, Word.class);
    public static final HotSpotForeignCallDescriptor MONTGOMERY_SQUARE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Int), "implMontgomerySquare", Void.TYPE, Word.class, Word.class, Integer.TYPE, Long.TYPE, Word.class);
    public static final HotSpotForeignCallDescriptor SQUARE_TO_LEN = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Int), "implSquareToLen", Void.TYPE, Word.class, Integer.TYPE, Word.class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor SHA_IMPL_COMPRESS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "shaImplCompress", Void.TYPE, Word.class, Object.class);
    public static final HotSpotForeignCallDescriptor SHA2_IMPL_COMPRESS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "sha2ImplCompress", Void.TYPE, Word.class, Object.class);
    public static final HotSpotForeignCallDescriptor SHA5_IMPL_COMPRESS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "sha5ImplCompress", Void.TYPE, Word.class, Object.class);
    public static final HotSpotForeignCallDescriptor SHA_IMPL_COMPRESS_MB = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "shaImplCompressMB", Integer.TYPE, Word.class, Object.class, Integer.TYPE, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor SHA2_IMPL_COMPRESS_MB = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "sha2ImplCompressMB", Integer.TYPE, Word.class, Object.class, Integer.TYPE, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor SHA5_IMPL_COMPRESS_MB = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "sha5ImplCompressMB", Integer.TYPE, Word.class, Object.class, Integer.TYPE, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor GHASH_PROCESS_BLOCKS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "ghashProcessBlocks", Void.TYPE, Word.class, Word.class, Word.class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor BASE64_ENCODE_BLOCK = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "base64EncodeBlock", Void.TYPE, Word.class, Integer.TYPE, Integer.TYPE, Word.class, Integer.TYPE, Boolean.TYPE);
    public static final HotSpotForeignCallDescriptor COUNTERMODE_IMPL_CRYPT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "counterModeAESCrypt", Integer.TYPE, Word.class, Word.class, Word.class, Word.class, Integer.TYPE, Word.class, Word.class);
    public static final HotSpotForeignCallDescriptor VECTORIZED_MISMATCH = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "vectorizedMismatch", Integer.TYPE, Word.class, Word.class, Integer.TYPE, Integer.TYPE);
    public static final LocationIdentity CRC_TABLE_LOCATION = NamedLocationIdentity.immutable("crc32_table");
    public static final HotSpotForeignCallDescriptor UPDATE_BYTES_CRC32 = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "updateBytesCRC32", Integer.TYPE, Integer.TYPE, WordBase.class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor UPDATE_BYTES_CRC32C = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "updateBytesCRC32C", Integer.TYPE, Integer.TYPE, WordBase.class, Integer.TYPE);
    public static String copyMemoryName = JavaVersionUtil.JAVA_SPEC <= 8 ? "copyMemory" : "copyMemory0";
    public static final HotSpotForeignCallDescriptor VM_ERROR = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "vm_error", Void.TYPE, Object.class, Object.class, Long.TYPE);
    private static final LocationIdentity[] TLAB_LOCATIONS = new LocationIdentity[]{HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION};
    public static final HotSpotForeignCallDescriptor NEW_MULTI_ARRAY = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, TLAB_LOCATIONS, "new_multi_array", Object.class, KlassPointer.class, Integer.TYPE, Word.class);
    public static final HotSpotForeignCallDescriptor NEW_MULTI_ARRAY_OR_NULL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, TLAB_LOCATIONS, "new_multi_array_or_null", Object.class, KlassPointer.class, Integer.TYPE, Word.class);
    public static final HotSpotForeignCallDescriptor NEW_ARRAY = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, TLAB_LOCATIONS, "new_array", Object.class, KlassPointer.class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor NEW_ARRAY_OR_NULL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, TLAB_LOCATIONS, "new_array_or_null", Object.class, KlassPointer.class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor NEW_INSTANCE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, TLAB_LOCATIONS, "new_instance", Object.class, KlassPointer.class);
    public static final HotSpotForeignCallDescriptor NEW_INSTANCE_OR_NULL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, TLAB_LOCATIONS, "new_instance_or_null", Object.class, KlassPointer.class);
    public static final HotSpotForeignCallDescriptor RESOLVE_STRING_BY_SYMBOL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, TLAB_LOCATIONS, "resolve_string_by_symbol", Object.class, Word.class, Word.class);
    public static final HotSpotForeignCallDescriptor RESOLVE_DYNAMIC_INVOKE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, LocationIdentity.any(), "resolve_dynamic_invoke", Object.class, Word.class);
    public static final HotSpotForeignCallDescriptor RESOLVE_KLASS_BY_SYMBOL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, LocationIdentity.any(), "resolve_klass_by_symbol", Word.class, Word.class, Word.class);
    public static final HotSpotForeignCallDescriptor INITIALIZE_KLASS_BY_SYMBOL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "initialize_klass_by_symbol", Word.class, Word.class, Word.class);
    public static final HotSpotForeignCallDescriptor RESOLVE_METHOD_BY_SYMBOL_AND_LOAD_COUNTERS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "resolve_method_by_symbol_and_load_counters", Word.class, Word.class, Word.class, Word.class);
    public static final HotSpotForeignCallDescriptor INVOCATION_EVENT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "invocation_event", Void.TYPE, MethodCountersPointer.class);
    public static final HotSpotForeignCallDescriptor BACKEDGE_EVENT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "backedge_event", Void.TYPE, MethodCountersPointer.class, Integer.TYPE, Integer.TYPE);

    public static void multiplyToLenStub(Word xAddr, int xlen, Word yAddr, int ylen, Word zAddr, int zLen) {
        HotSpotBackend.multiplyToLenStub(MULTIPLY_TO_LEN, xAddr, xlen, yAddr, ylen, zAddr, zLen);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void multiplyToLenStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, int var2, Word var3, int var4, Word var5, int var6);

    public static int shaImplCompressMBStub(Word bufAddr, Object stateAddr, int ofs, int limit) {
        return HotSpotBackend.shaImplCompressMBStub(SHA_IMPL_COMPRESS_MB, bufAddr, stateAddr, ofs, limit);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int shaImplCompressMBStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Object var2, int var3, int var4);

    public static int sha2ImplCompressMBStub(Word bufAddr, Object stateAddr, int ofs, int limit) {
        return HotSpotBackend.sha2ImplCompressMBStub(SHA2_IMPL_COMPRESS_MB, bufAddr, stateAddr, ofs, limit);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int sha2ImplCompressMBStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Object var2, int var3, int var4);

    public static int sha5ImplCompressMBStub(Word bufAddr, Object stateAddr, int ofs, int limit) {
        return HotSpotBackend.sha5ImplCompressMBStub(SHA5_IMPL_COMPRESS_MB, bufAddr, stateAddr, ofs, limit);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int sha5ImplCompressMBStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Object var2, int var3, int var4);

    public static void unsafeArraycopy(Word srcAddr, Word dstAddr, Word size) {
        HotSpotBackend.unsafeArraycopyStub(ArrayCopyForeignCalls.UNSAFE_ARRAYCOPY, srcAddr, dstAddr, size);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void unsafeArraycopyStub(@Node.ConstantNodeParameter ForeignCallSignature var0, Word var1, Word var2, Word var3);

    public static int counterModeAESCrypt(Word srcAddr, Word dstAddr, Word kPtr, Word cntPtr, int len, Word encCntPtr, Word used) {
        return HotSpotBackend.counterModeAESCrypt(COUNTERMODE_IMPL_CRYPT, srcAddr, dstAddr, kPtr, cntPtr, len, encCntPtr, used);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int counterModeAESCrypt(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Word var3, Word var4, int var5, Word var6, Word var7);

    public HotSpotBackend(HotSpotGraalRuntimeProvider runtime, HotSpotProviders providers) {
        super(providers);
        this.runtime = runtime;
    }

    public HotSpotGraalRuntimeProvider getRuntime() {
        return this.runtime;
    }

    public void completeInitialization(HotSpotJVMCIRuntime jvmciRuntime, OptionValues options) {
    }

    private EconomicSet<Register> gatherDestroyedCallerRegisters(HotSpotLIRGenerationResult gen) {
        CallingConvention cc;
        AllocatableValue returnValue;
        LIR lir = gen.getLIR();
        final EconomicSet preservedRegisters = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        final EconomicSet destroyedRegisters = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        ValueConsumer defConsumer = new ValueConsumer(){

            @Override
            public void visitValue(Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
                Register reg;
                if (ValueUtil.isRegister((Value)value) && !preservedRegisters.contains((Object)(reg = ValueUtil.asRegister((Value)value)))) {
                    destroyedRegisters.add((Object)reg);
                }
            }
        };
        boolean sawSaveRegisters = false;
        for (AbstractBlockBase<?> block : lir.codeEmittingOrder()) {
            if (block == null) continue;
            StandardOp.SaveRegistersOp save = null;
            for (LIRInstruction op : lir.getLIRforBlock(block)) {
                if (op instanceof StandardOp.LabelOp) continue;
                if (op instanceof StandardOp.SaveRegistersOp) {
                    save = (StandardOp.SaveRegistersOp)op;
                    sawSaveRegisters = true;
                    preservedRegisters.addAll(save.getSaveableRegisters());
                    continue;
                }
                if (op instanceof StandardOp.RestoreRegistersOp) {
                    save = null;
                    preservedRegisters.clear();
                    continue;
                }
                op.visitEachTemp(defConsumer);
                op.visitEachOutput(defConsumer);
            }
            assert (save == null) : "missing RestoreRegistersOp";
        }
        if (sawSaveRegisters && (returnValue = (cc = gen.getCallingConvention()).getReturn()) != null && ValueUtil.isRegister((Value)returnValue)) {
            destroyedRegisters.add((Object)ValueUtil.asRegister((Value)returnValue));
        }
        return this.translateToCallerRegisters((EconomicSet<Register>)destroyedRegisters);
    }

    protected abstract EconomicSet<Register> translateToCallerRegisters(EconomicSet<Register> var1);

    protected void updateStub(Stub stub, HotSpotLIRGenerationResult gen, FrameMap frameMap) {
        EconomicSet<Register> destroyedRegisters = this.gatherDestroyedCallerRegisters(gen);
        EconomicMap<LIRFrameState, StandardOp.SaveRegistersOp> calleeSaveInfo = gen.getCalleeSaveInfo();
        if (stub.getLinkage().needsDebugInfo() && calleeSaveInfo.isEmpty()) {
            for (Register r : frameMap.getRegisterConfig().getCallerSaveRegisters()) {
                destroyedRegisters.add((Object)r);
            }
        }
        stub.initDestroyedCallerRegisters(destroyedRegisters);
        MapCursor cursor = calleeSaveInfo.getEntries();
        while (cursor.advance()) {
            StandardOp.SaveRegistersOp save = (StandardOp.SaveRegistersOp)cursor.getValue();
            save.remove(destroyedRegisters);
            if (cursor.getKey() == LIRFrameState.NO_STATE) continue;
            ((LIRFrameState)cursor.getKey()).debugInfo().setCalleeSaveInfo(save.getMap(frameMap));
        }
    }

    @Override
    public HotSpotProviders getProviders() {
        return (HotSpotProviders)super.getProviders();
    }

    @Override
    public SuitesProvider getSuites() {
        return this.getProviders().getSuites();
    }

    protected void profileInstructions(LIR lir, CompilationResultBuilder crb) {
        if (Options.ASMInstructionProfiling.getValue(lir.getOptions()) != null) {
            HotSpotInstructionProfiling.countInstructions(lir, crb.asm);
        }
    }

    @Override
    public CompiledCode createCompiledCode(ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compResult, boolean isDefault, OptionValues options) {
        assert (!isDefault || compResult.getName() == null) : "a default nmethod should have a null name since it is associated with a Method*";
        HotSpotCompilationRequest compRequest = compilationRequest instanceof HotSpotCompilationRequest ? (HotSpotCompilationRequest)compilationRequest : null;
        return HotSpotCompiledCodeBuilder.createCompiledCode(this.getCodeCache(), method, compRequest, compResult, options);
    }

    @Override
    public CompilationIdentifier getCompilationIdentifier(ResolvedJavaMethod resolvedJavaMethod) {
        if (resolvedJavaMethod instanceof HotSpotResolvedJavaMethod) {
            HotSpotCompilationRequest request = new HotSpotCompilationRequest((HotSpotResolvedJavaMethod)resolvedJavaMethod, -1, 0L);
            return new HotSpotCompilationIdentifier(request);
        }
        return super.getCompilationIdentifier(resolvedJavaMethod);
    }

    public static class Options {
        @Option(help={"Use Graal arithmetic stubs instead of HotSpot stubs where possible"})
        public static final OptionKey<Boolean> GraalArithmeticStubs = new OptionKey<Boolean>(JavaVersionUtil.JAVA_SPEC >= 9);
        @Option(help={"Enables instruction profiling on assembler level. Valid values are a comma separated list of supported instructions. Compare with subclasses of Assembler.InstructionCounter."}, type=OptionType.Debug)
        public static final OptionKey<String> ASMInstructionProfiling = new OptionKey<Object>(null);
    }
}

