/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.function.Consumer;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaField;
import jdk.vm.ci.meta.UnresolvedJavaMethod;
import jdk.vm.ci.meta.UnresolvedJavaType;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.runtime.GraalJVMCICompiler;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.SymbolicJVMCIReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.HotSpotReplacementsImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.spi.SnippetParameterInfo;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.PEGraphDecoder;

public class EncodedSnippets {
    private final byte[] snippetEncoding;
    private final Object[] snippetObjects;
    private final NodeClass<?>[] snippetNodeClasses;
    private final UnmodifiableEconomicMap<String, GraphData> graphDatas;

    EncodedSnippets(byte[] snippetEncoding, Object[] snippetObjects, NodeClass<?>[] snippetNodeClasses, UnmodifiableEconomicMap<String, GraphData> graphDatas) {
        this.snippetEncoding = snippetEncoding;
        this.snippetObjects = snippetObjects;
        this.snippetNodeClasses = snippetNodeClasses;
        this.graphDatas = graphDatas;
    }

    public NodeClass<?>[] getSnippetNodeClasses() {
        return this.snippetNodeClasses;
    }

    public void visitImmutable(Consumer<Object> visitor) {
        visitor.accept(this.snippetEncoding);
        visitor.accept(this.snippetNodeClasses);
        visitor.accept(this.graphDatas);
    }

    StructuredGraph getMethodSubstitutionGraph(MethodSubstitutionPlugin plugin, ResolvedJavaMethod original, HotSpotReplacementsImpl replacements, IntrinsicContext.CompilationContext context, StructuredGraph.AllowAssumptions allowAssumptions, Cancellable cancellable, OptionValues options) {
        GraphData data;
        IntrinsicContext.CompilationContext contextToUse = context;
        if (context == IntrinsicContext.CompilationContext.ROOT_COMPILATION) {
            contextToUse = IntrinsicContext.CompilationContext.ROOT_COMPILATION_ENCODING;
        }
        if ((data = (GraphData)this.graphDatas.get((Object)(plugin.toString() + (Object)((Object)contextToUse)))) == null) {
            throw GraalError.shouldNotReachHere("plugin graph not found: " + plugin + " with " + (Object)((Object)contextToUse));
        }
        ResolvedJavaType accessingClass = replacements.getProviders().getMetaAccess().lookupJavaType(plugin.getDeclaringClass());
        return this.decodeGraph(original, accessingClass, data.startOffset, replacements, contextToUse, allowAssumptions, cancellable, options);
    }

    public static String methodKey(ResolvedJavaMethod method) {
        return method.format("%H.%n(%P)");
    }

    private StructuredGraph decodeGraph(ResolvedJavaMethod method, ResolvedJavaType accessingClass, int startOffset, HotSpotReplacementsImpl replacements, IntrinsicContext.CompilationContext context, StructuredGraph.AllowAssumptions allowAssumptions, Cancellable cancellable, OptionValues options) {
        HotSpotProviders providers = replacements.getProviders();
        SymbolicEncodedGraph encodedGraph = new SymbolicEncodedGraph(this.snippetEncoding, startOffset, this.snippetObjects, this.snippetNodeClasses, EncodedSnippets.methodKey(method), accessingClass, method.getDeclaringClass());
        try (DebugContext debug = replacements.openSnippetDebugContext("LibgraalSnippet_", method, options);){
            StructuredGraph result = new StructuredGraph.Builder(options, debug, allowAssumptions).cancellable(cancellable).method(method).setIsSubstitution(true).build();
            SubstitutionGraphDecoder graphDecoder = new SubstitutionGraphDecoder(providers, result, replacements, null, method, context, encodedGraph, true);
            graphDecoder.decode(method, result.isSubstitution(), encodedGraph.trackNodeSourcePosition());
            assert (result.verify());
            StructuredGraph structuredGraph = result;
            return structuredGraph;
        }
    }

    StructuredGraph getEncodedSnippet(ResolvedJavaMethod method, HotSpotReplacementsImpl replacements, Object[] args, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
        GraphData data = null;
        if (this.graphDatas != null) {
            data = (GraphData)this.graphDatas.get((Object)EncodedSnippets.methodKey(method));
        }
        if (data == null) {
            if (Services.IS_IN_NATIVE_IMAGE) {
                throw GraalError.shouldNotReachHere("snippet not found: " + method.format("%H.%n(%p)"));
            }
            return null;
        }
        SymbolicEncodedGraph encodedGraph = new SymbolicEncodedGraph(this.snippetEncoding, data.startOffset, this.snippetObjects, this.snippetNodeClasses, data.originalMethod, method.getDeclaringClass());
        return EncodedSnippets.decodeSnippetGraph(encodedGraph, method, replacements, args, allowAssumptions, options, Services.IS_IN_NATIVE_IMAGE);
    }

    public SnippetParameterInfo getSnippetParameterInfo(ResolvedJavaMethod method) {
        GraphData data = null;
        if (this.graphDatas != null) {
            data = (GraphData)this.graphDatas.get((Object)EncodedSnippets.methodKey(method));
        }
        assert (data != null) : method;
        SnippetParameterInfo info = data.info;
        assert (info != null);
        return info;
    }

    public boolean isSnippet(ResolvedJavaMethod method) {
        GraphData data = null;
        if (this.graphDatas != null) {
            data = (GraphData)this.graphDatas.get((Object)EncodedSnippets.methodKey(method));
        }
        return data != null && data.info != null;
    }

    /*
     * Exception decompiling
     */
    static StructuredGraph decodeSnippetGraph(SymbolicEncodedGraph encodedGraph, ResolvedJavaMethod method, HotSpotReplacementsImpl replacements, Object[] args, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options, boolean mustSucceed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Object maybeMakeSymbolic(Stamp trustedStamp) {
        SymbolicJVMCIReference<? extends Stamp> symbolicJVMCIReference;
        if (trustedStamp != null && (symbolicJVMCIReference = trustedStamp.makeSymbolic()) != null) {
            return symbolicJVMCIReference;
        }
        return trustedStamp;
    }

    private static Stamp resolveStamp(ResolvedJavaType accessingClass, Object stamp) {
        if (stamp == null) {
            return null;
        }
        if (stamp instanceof Stamp) {
            return (Stamp)stamp;
        }
        return (Stamp)((SymbolicJVMCIReference)stamp).resolve(accessingClass);
    }

    static class SymbolicStampPair
    implements SymbolicJVMCIReference<StampPair> {
        Object trustedStamp;
        Object uncheckdStamp;

        SymbolicStampPair(StampPair stamp) {
            this.trustedStamp = EncodedSnippets.maybeMakeSymbolic(stamp.getTrustedStamp());
            this.uncheckdStamp = EncodedSnippets.maybeMakeSymbolic(stamp.getUncheckedStamp());
        }

        @Override
        public StampPair resolve(ResolvedJavaType accessingClass) {
            return StampPair.create(EncodedSnippets.resolveStamp(accessingClass, this.trustedStamp), EncodedSnippets.resolveStamp(accessingClass, this.uncheckdStamp));
        }
    }

    static class SymbolicResolvedJavaMethodBytecode
    implements SymbolicJVMCIReference<ResolvedJavaMethodBytecode> {
        SymbolicResolvedJavaMethod method;

        SymbolicResolvedJavaMethodBytecode(ResolvedJavaMethodBytecode bytecode) {
            this.method = new SymbolicResolvedJavaMethod(bytecode.getMethod());
        }

        @Override
        public ResolvedJavaMethodBytecode resolve(ResolvedJavaType accessingClass) {
            return new ResolvedJavaMethodBytecode(this.method.resolve(accessingClass));
        }
    }

    static class SymbolicResolvedJavaField
    implements SymbolicJVMCIReference<ResolvedJavaField> {
        final UnresolvedJavaType declaringType;
        final String name;
        final UnresolvedJavaType signature;
        private final boolean isStatic;

        SymbolicResolvedJavaField(ResolvedJavaField field) {
            this.declaringType = UnresolvedJavaType.create((String)field.getDeclaringClass().getName());
            this.name = field.getName();
            this.signature = UnresolvedJavaType.create((String)field.getType().getName());
            this.isStatic = field.isStatic();
        }

        @Override
        public ResolvedJavaField resolve(ResolvedJavaType accessingClass) {
            ResolvedJavaField[] fields;
            ResolvedJavaType resolvedType = this.declaringType.resolve(accessingClass);
            ResolvedJavaType resolvedFieldType = this.signature.resolve(accessingClass);
            for (ResolvedJavaField field : fields = this.isStatic ? resolvedType.getStaticFields() : resolvedType.getInstanceFields(true)) {
                if (!field.getName().equals(this.name) || !field.getType().equals(resolvedFieldType)) continue;
                return field;
            }
            throw new InternalError("Could not resolve " + this + " in context of " + accessingClass.toJavaName());
        }

        public String toString() {
            return "SymbolicResolvedJavaField{" + this.signature.getName() + ' ' + this.declaringType.getName() + '.' + this.name + '}';
        }
    }

    static class SymbolicResolvedJavaMethod
    implements SymbolicJVMCIReference<ResolvedJavaMethod> {
        final UnresolvedJavaType type;
        final String methodName;
        final String signature;

        SymbolicResolvedJavaMethod(ResolvedJavaMethod method) {
            this.type = UnresolvedJavaType.create((String)method.getDeclaringClass().getName());
            this.methodName = method.getName();
            this.signature = method.getSignature().toMethodDescriptor();
        }

        public String toString() {
            return "SymbolicResolvedJavaMethod{declaringType='" + this.type.getName() + '\'' + ", methodName='" + this.methodName + '\'' + ", signature='" + this.signature + '\'' + '}';
        }

        @Override
        public ResolvedJavaMethod resolve(ResolvedJavaType accessingClass) {
            ResolvedJavaType resolvedType = this.type.resolve(accessingClass);
            if (resolvedType == null) {
                throw new InternalError("Could not resolve " + this + " in context of " + accessingClass.toJavaName());
            }
            for (ResolvedJavaMethod method : this.methodName.equals("<init>") ? resolvedType.getDeclaredConstructors() : resolvedType.getDeclaredMethods()) {
                if (!method.getName().equals(this.methodName) || !method.getSignature().toMethodDescriptor().equals(this.signature)) continue;
                return method;
            }
            throw new InternalError("Could not resolve " + this + " in context of " + accessingClass.toJavaName());
        }
    }

    static class GraalCapability {
        final Class<?> capabilityClass;

        GraalCapability(Class<?> capabilityClass) {
            this.capabilityClass = capabilityClass;
        }

        public Object resolve(GraalRuntime runtime) {
            Object capability = runtime.getCapability(this.capabilityClass);
            if (capability != null) {
                assert (capability.getClass() == this.capabilityClass);
                return capability;
            }
            throw new InternalError(this.capabilityClass.getName());
        }
    }

    static class SymbolicEncodedGraph
    extends EncodedGraph {
        private final ResolvedJavaType[] accessingClasses;
        private final String originalMethod;

        SymbolicEncodedGraph(byte[] encoding, int startOffset, Object[] objects, NodeClass<?>[] types, String originalMethod, ResolvedJavaType ... accessingClasses) {
            super(encoding, startOffset, objects, types, null, null, null, false, false);
            this.accessingClasses = accessingClasses;
            this.originalMethod = originalMethod;
        }

        SymbolicEncodedGraph(EncodedGraph encodedGraph, ResolvedJavaType declaringClass, String originalMethod) {
            this(encodedGraph.getEncoding(), encodedGraph.getStartOffset(), encodedGraph.getObjects(), encodedGraph.getNodeClasses(), originalMethod, declaringClass);
        }

        @Override
        public Object getObject(int i) {
            Object o = this.objects[i];
            Object replacement = null;
            if (o instanceof SymbolicJVMCIReference) {
                for (ResolvedJavaType type : this.accessingClasses) {
                    try {
                        replacement = ((SymbolicJVMCIReference)o).resolve(type);
                        break;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                    }
                }
            } else if (o instanceof UnresolvedJavaType) {
                for (ResolvedJavaType type : this.accessingClasses) {
                    try {
                        replacement = ((UnresolvedJavaType)o).resolve(type);
                        break;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                    }
                }
            } else {
                if (o instanceof UnresolvedJavaMethod) {
                    throw new InternalError(o.toString());
                }
                if (o instanceof UnresolvedJavaField) {
                    for (ResolvedJavaType type : this.accessingClasses) {
                        try {
                            replacement = ((UnresolvedJavaField)o).resolve(type);
                            break;
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                        }
                    }
                } else if (o instanceof GraalCapability) {
                    replacement = ((GraalCapability)o).resolve(((GraalJVMCICompiler)JVMCI.getRuntime().getCompiler()).getGraalRuntime());
                } else {
                    return o;
                }
            }
            if (replacement == null) {
                throw new GraalError("Can't resolve " + o);
            }
            this.objects[i] = o = replacement;
            return o;
        }

        @Override
        public boolean isCallToOriginal(ResolvedJavaMethod callTarget) {
            if (this.originalMethod != null && this.originalMethod.equals(EncodedSnippets.methodKey(callTarget))) {
                return true;
            }
            return super.isCallToOriginal(callTarget);
        }
    }

    static class SubstitutionGraphDecoder
    extends PEGraphDecoder {
        private final ResolvedJavaMethod method;
        private final EncodedGraph encodedGraph;
        private IntrinsicContext intrinsic;
        private final boolean mustSucceed;

        SubstitutionGraphDecoder(Providers providers, StructuredGraph result, HotSpotReplacementsImpl replacements, ParameterPlugin parameterPlugin, ResolvedJavaMethod method, IntrinsicContext.CompilationContext context, EncodedGraph encodedGraph, boolean mustSucceed) {
            super(providers.getCodeCache().getTarget().arch, result, providers, null, replacements.getGraphBuilderPlugins().getInvocationPlugins(), new InlineInvokePlugin[0], parameterPlugin, null, null, null);
            this.method = method;
            this.encodedGraph = encodedGraph;
            this.mustSucceed = mustSucceed;
            this.intrinsic = new IntrinsicContext(method, null, replacements.getDefaultReplacementBytecodeProvider(), context, false);
        }

        @Override
        protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod lookupMethod, MethodSubstitutionPlugin plugin, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution, boolean trackNodeSourcePosition) {
            if (lookupMethod.equals(this.method)) {
                return this.encodedGraph;
            }
            throw GraalError.shouldNotReachHere(this.method.format("%H.%n(%p)"));
        }

        @Override
        public IntrinsicContext getIntrinsic() {
            return this.intrinsic;
        }

        @Override
        protected boolean pluginReplacementMustSucceed() {
            return this.mustSucceed;
        }
    }

    static class GraphData {
        int startOffset;
        String originalMethod;
        SnippetParameterInfo info;

        GraphData(int startOffset, String originalMethod, SnippetParameterInfo info) {
            this.startOffset = startOffset;
            this.originalMethod = originalMethod;
            this.info = info;
        }
    }
}

