/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.IsolateUtil;

public class DiagnosticsOutputDirectory {
    private static final String CLOSED = "\u0000";
    private final OptionValues options;
    private String path;

    public DiagnosticsOutputDirectory(OptionValues options) {
        this.options = options;
    }

    public String getPath() {
        return this.getPath(true);
    }

    private synchronized String getPath(boolean createIfNull) {
        if (this.path == null && createIfNull) {
            this.path = this.createPath();
            File dir = new File(this.path).getAbsoluteFile();
            if (!dir.exists()) {
                dir.mkdirs();
                if (!dir.exists()) {
                    TTY.println("Warning: could not create Graal diagnostic directory " + dir);
                    return null;
                }
            }
        }
        if (CLOSED.equals(this.path)) {
            TTY.println("Warning: Graal diagnostic directory already closed");
            return null;
        }
        return this.path;
    }

    protected String createPath() {
        Path baseDir;
        try {
            baseDir = DebugOptions.getDumpDirectory(this.options);
        }
        catch (IOException e) {
            baseDir = Paths.get(".", new String[0]);
        }
        return baseDir.resolve("graal_diagnostics_" + GraalServices.getExecutionID() + '@' + IsolateUtil.getIsolateID()).toAbsolutePath().toString();
    }

    public void close() {
        this.archiveAndDelete();
    }

    private synchronized void archiveAndDelete() {
        String outDir = this.getPath(false);
        if (outDir != null) {
            this.path = CLOSED;
            final Path dir = Paths.get(outDir, new String[0]);
            if (dir.toFile().exists()) {
                final String prefix = new File(outDir).getName() + "/";
                File zip = new File(outDir + ".zip").getAbsoluteFile();
                final ArrayList toDelete = new ArrayList();
                try {
                    final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));
                    Object object = null;
                    try {
                        zos.setLevel(9);
                        Files.walkFileTree(dir, Collections.emptySet(), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                if (attrs.isRegularFile()) {
                                    String name = prefix + dir.relativize(file).toString();
                                    ZipEntry ze = new ZipEntry(name);
                                    zos.putNextEntry(ze);
                                    Files.copy(file, zos);
                                    zos.closeEntry();
                                }
                                toDelete.add(file);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path d, IOException exc) throws IOException {
                                toDelete.add(d);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                        TTY.println("Graal diagnostic output saved in %s", zip);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (zos != null) {
                            if (object != null) {
                                try {
                                    zos.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                zos.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    TTY.printf("IO error archiving %s:%n%s. The directory will not be deleted and must be manually removed once the VM exits.%n", dir, e);
                    toDelete.clear();
                }
                if (!toDelete.isEmpty()) {
                    IOException lastDeletionError = null;
                    for (Path p : toDelete) {
                        try {
                            Files.delete(p);
                        }
                        catch (IOException e) {
                            lastDeletionError = e;
                        }
                    }
                    if (lastDeletionError != null) {
                        TTY.printf("IO error deleting %s:%n%s. This is most likely due to a compilation on another thread holding a handle to a file within this directory. Please delete the directory manually once the VM exits.%n", dir, lastDeletionError);
                    }
                }
            }
        }
    }
}

