/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.debug.DebugConfigImpl;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.options.EnumOptionKey;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionStability;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class DebugOptions {
    @Option(help={"Comma separated names of timers that are enabled irrespective of the value for Time option. An empty value enables all timers unconditionally."}, type=OptionType.Debug)
    public static final OptionKey<String> Timers = new OptionKey<Object>(null);
    @Option(help={"Comma separated names of counters that are enabled irrespective of the value for Count option. An empty value enables all counters unconditionally."}, type=OptionType.Debug)
    public static final OptionKey<String> Counters = new OptionKey<Object>(null);
    @Option(help={"Comma separated names of memory usage trackers that are enabled irrespective of the value for TrackMemUse option. An empty value enables all memory usage trackers unconditionally."}, type=OptionType.Debug)
    public static final OptionKey<String> MemUseTrackers = new OptionKey<Object>(null);
    @Option(help={"Pattern for specifying scopes in which counters are enabled. See the Dump option for the pattern syntax. An empty value enables all counters unconditionally."}, type=OptionType.Debug)
    public static final OptionKey<String> Count = new OptionKey<Object>(null);
    @Option(help={"Pattern for specifying scopes in which memory use tracking is enabled. See the Dump option for the pattern syntax. An empty value enables all memory use trackers unconditionally."}, type=OptionType.Debug)
    public static final OptionKey<String> TrackMemUse = new OptionKey<Object>(null);
    @Option(help={"Pattern for specifying scopes in which timing is enabled. See the Dump option for the pattern syntax. An empty value enables all timers unconditionally."}, type=OptionType.Debug)
    public static final OptionKey<String> Time = new OptionKey<Object>(null);
    @Option(help={"Pattern for specifying scopes in which logging is enabled. See the Dump option for the pattern syntax."}, type=OptionType.Debug)
    public static final OptionKey<String> Verify = new OptionKey<Object>(null);
    @Option(help={"file:doc-files/DumpHelp.txt"}, type=OptionType.Debug, stability=OptionStability.STABLE)
    public static final OptionKey<String> Dump = new OptionKey<Object>(null);
    @Option(help={"Pattern for specifying scopes in which logging is enabled. See the Dump option for the pattern syntax."}, type=OptionType.Debug)
    public static final OptionKey<String> Log = new OptionKey<Object>(null);
    @Option(help={"file:doc-files/MethodFilterHelp.txt"}, stability=OptionStability.STABLE)
    public static final OptionKey<String> MethodFilter = new OptionKey<Object>(null);
    @Option(help={"Only check MethodFilter against the root method in the context if true, otherwise check all methods"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> MethodFilterRootOnly = new OptionKey<Boolean>(false);
    @Option(help={"Dump a before and after graph if the named phase changes the graph.%nThe argument is substring matched against the simple name of the phase class"}, type=OptionType.Debug)
    public static final OptionKey<String> DumpOnPhaseChange = new OptionKey<Object>(null);
    @Option(help={"Lists on the console at VM shutdown the metric names available to the Timers, Counters and MemUseTrackers options. Note that this only lists the metrics that were initialized during the VM execution and so will not include metrics for compiler code that is not executed."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> ListMetrics = new OptionKey<Boolean>(false);
    @Option(help={"file:doc-files/MetricsFileHelp.txt"}, type=OptionType.Debug)
    public static final OptionKey<String> MetricsFile = new OptionKey<Object>(null);
    @Option(help={"File to which aggregated metrics are dumped at shutdown. A CSV format is used if the file ends with .csv otherwise a more human readable format is used. If not specified, metrics are dumped to the console."}, type=OptionType.Debug)
    public static final OptionKey<String> AggregatedMetricsFile = new OptionKey<Object>(null);
    @Option(help={"Enable debug output for stub code generation and snippet preparation."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> DebugStubsAndSnippets = new OptionKey<Boolean>(false);
    @Option(help={"Send compiler IR to dump handlers on error."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> DumpOnError = new OptionKey<Boolean>(false);
    @Option(help={"Specify the DumpLevel if CompilationFailureAction#Diagnose is used.See CompilationFailureAction for details. file:doc-files/CompilationFailureActionHelp.txt"}, type=OptionType.Debug)
    public static final OptionKey<Integer> DiagnoseDumpLevel = new OptionKey<Integer>(3);
    @Option(help={"Disable intercepting exceptions in debug scopes."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> DisableIntercept = new OptionKey<Boolean>(false);
    @Option(help={"Intercept also bailout exceptions"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> InterceptBailout = new OptionKey<Boolean>(false);
    @Option(help={"Enable more verbose log output when available"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> LogVerbose = new OptionKey<Boolean>(false);
    @Option(help={"The directory where various Graal dump files are written."})
    public static final OptionKey<String> DumpPath = new OptionKey<String>("graal_dumps");
    @Option(help={"Print the name of each dump file path as it's created."})
    public static final OptionKey<Boolean> ShowDumpFiles = new OptionKey<Boolean>(false);
    @Option(help={"Enable dumping to the C1Visualizer. Enabling this option implies PrintBackendCFG."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> PrintCFG = new OptionKey<Boolean>(false);
    @Option(help={"Enable dumping LIR, register allocation and code generation info to the C1Visualizer."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> PrintBackendCFG = new OptionKey<Boolean>(false);
    @Option(help={"Enable dumping CFG built during initial BciBlockMapping"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> PrintBlockMapping = new OptionKey<Boolean>(false);
    @Option(help={"file:doc-files/PrintGraphHelp.txt"}, type=OptionType.Debug)
    public static final EnumOptionKey<PrintGraphTarget> PrintGraph = new EnumOptionKey<PrintGraphTarget>(PrintGraphTarget.File);
    @Option(help={"Setting to true sets PrintGraph=file, setting to false sets PrintGraph=network"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> PrintGraphFile = new OptionKey<Boolean>(Boolean.valueOf(true)){

        @Override
        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            PrintGraphTarget v = (PrintGraphTarget)((Object)PrintGraph.getValueOrDefault((UnmodifiableEconomicMap<OptionKey<?>, Object>)values));
            if (newValue.booleanValue()) {
                if (v != PrintGraphTarget.File) {
                    PrintGraph.update(values, (Object)PrintGraphTarget.File);
                }
            } else if (v != PrintGraphTarget.Network) {
                PrintGraph.update(values, (Object)PrintGraphTarget.Network);
            }
        }
    };
    @Option(help={"Host part of the address to which graphs are dumped."}, type=OptionType.Debug)
    public static final OptionKey<String> PrintGraphHost = new OptionKey<String>("127.0.0.1");
    @Option(help={"Port part of the address to which graphs are dumped in binary format."}, type=OptionType.Debug)
    public static final OptionKey<Integer> PrintGraphPort = new OptionKey<Integer>(4445);
    @Option(help={"Schedule graphs as they are dumped."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> PrintGraphWithSchedule = new OptionKey<Boolean>(false);
    @Option(help={"Treat any exceptions during dumping as fatal."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> DumpingErrorsAreFatal = new OptionKey<Boolean>(false);
    @Option(help={"Enable dumping canonical text from for graphs."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> PrintCanonicalGraphStrings = new OptionKey<Boolean>(false);
    @Option(help={"Choose format used when dumping canonical text for graphs: 0 gives a scheduled graph (better for spotting changes involving the schedule) while 1 gives a CFG containing expressions rooted at fixed nodes (better for spotting small structure differences)"}, type=OptionType.Debug)
    public static final OptionKey<Integer> PrintCanonicalGraphStringFlavor = new OptionKey<Integer>(0);
    @Option(help={"Exclude virtual nodes when dumping canonical text for graphs."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> CanonicalGraphStringsExcludeVirtuals = new OptionKey<Boolean>(true);
    @Option(help={"Exclude virtual nodes when dumping canonical text for graphs."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> CanonicalGraphStringsCheckConstants = new OptionKey<Boolean>(false);
    @Option(help={"Attempts to remove object identity hashes when dumping canonical text for graphs."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> CanonicalGraphStringsRemoveIdentities = new OptionKey<Boolean>(true);
    @Option(help={"Clear the debug metrics after bootstrap."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> ClearMetricsAfterBootstrap = new OptionKey<Boolean>(false);
    @Option(help={"Do not compile anything on bootstrap but just initialize the compiler."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> BootstrapInitializeOnly = new OptionKey<Boolean>(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Path getDumpDirectory(OptionValues options) throws IOException {
        Path dumpDir;
        if (DumpPath.hasBeenSet(options)) {
            dumpDir = Paths.get(DumpPath.getValue(options), new String[0]);
        } else {
            Date date = new Date(GraalServices.getGlobalTimeStamp());
            SimpleDateFormat formatter = new SimpleDateFormat("YYYY.MM.dd.HH.mm.ss.SSS");
            dumpDir = Paths.get(DumpPath.getValue(options), formatter.format(date));
        }
        dumpDir = dumpDir.toAbsolutePath();
        if (Files.exists(dumpDir, new LinkOption[0])) return dumpDir;
        Class<DebugConfigImpl> clazz = DebugConfigImpl.class;
        synchronized (DebugConfigImpl.class) {
            if (Files.exists(dumpDir, new LinkOption[0])) return dumpDir;
            Files.createDirectories(dumpDir, new FileAttribute[0]);
            if (!ShowDumpFiles.getValue(options).booleanValue()) return dumpDir;
            TTY.println("Dumping debug output in %s", dumpDir.toString());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return dumpDir;
        }
    }

    public static enum PrintGraphTarget {
        File,
        Network,
        Disable;

    }
}

