/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Pair;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.debug.AbstractKey;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.CSVUtil;
import org.graalvm.compiler.debug.CloseableCounter;
import org.graalvm.compiler.debug.CompilationListener;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.CounterKeyImpl;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugConfig;
import org.graalvm.compiler.debug.DebugConfigImpl;
import org.graalvm.compiler.debug.DebugDumpHandler;
import org.graalvm.compiler.debug.DebugHandler;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.DebugVerifyHandler;
import org.graalvm.compiler.debug.GlobalMetrics;
import org.graalvm.compiler.debug.IgvDumpChannel;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.debug.KeyRegistry;
import org.graalvm.compiler.debug.MemUseTrackerKey;
import org.graalvm.compiler.debug.MemUseTrackerKeyImpl;
import org.graalvm.compiler.debug.MetricKey;
import org.graalvm.compiler.debug.PathUtilities;
import org.graalvm.compiler.debug.ScopeImpl;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.debug.TimerKeyImpl;
import org.graalvm.compiler.debug.Versions;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.graphio.GraphOutput;

public final class DebugContext
implements AutoCloseable {
    public static final Description NO_DESCRIPTION = new Description(null, "NO_DESCRIPTION");
    public static final GlobalMetrics NO_GLOBAL_METRIC_VALUES = null;
    public static final Iterable<DebugHandlersFactory> NO_CONFIG_CUSTOMIZERS = Collections.emptyList();
    final Immutable immutable;
    boolean metricsEnabled;
    DebugConfigImpl currentConfig;
    ScopeImpl currentScope;
    CloseableCounter currentTimer;
    CloseableCounter currentMemUseTracker;
    Scope lastClosedScope;
    Throwable lastExceptionThrown;
    private IgvDumpChannel sharedChannel;
    private GraphOutput<?, ?> parentOutput;
    private long[] metricValues;
    private static final Activated activated = new Activated();
    private static final DebugContext DISABLED = new DebugContext(NO_DESCRIPTION, null, NO_GLOBAL_METRIC_VALUES, DebugContext.getDefaultLogStream(), new Immutable(), NO_CONFIG_CUSTOMIZERS);
    private final GlobalMetrics globalMetrics;
    private final Description description;
    private final CompilationListener compilationListener;
    private int compilerPhaseNesting = 0;
    public static final int ENABLED_LEVEL = 0;
    public static final int BASIC_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int VERBOSE_LEVEL = 3;
    public static final int DETAILED_LEVEL = 4;
    public static final int VERY_DETAILED_LEVEL = 5;
    @NativeImageReinitialize
    private final Invariants invariants = Assertions.assertionsEnabled() ? new Invariants() : null;
    private static final ClassValue<String> formattedClassName = new ClassValue<String>(){

        @Override
        protected String computeValue(Class<?> c) {
            Class<?> enclosingClass;
            String baseName = DebugContext.getBaseName(c);
            if (Character.isLowerCase(baseName.charAt(0))) {
                baseName = c.getName();
            }
            if ((enclosingClass = c.getEnclosingClass()) != null) {
                String prefix = "";
                while (enclosingClass != null) {
                    prefix = DebugContext.getBaseName(enclosingClass) + "_" + prefix;
                    enclosingClass = enclosingClass.getEnclosingClass();
                }
                return prefix + baseName;
            }
            return baseName;
        }
    };
    private static EconomicMap<Integer, Integer> compilations;
    private static int metricsBufSize;
    private static boolean metricsFileDeleteCheckPerformed;
    private static final Object PRINT_METRICS_LOCK;

    public static PrintStream getDefaultLogStream() {
        return TTY.out;
    }

    public boolean areScopesEnabled() {
        return this.immutable.scopesEnabled;
    }

    public <G, N, M> GraphOutput<G, M> buildOutput(GraphOutput.Builder<G, N, M> builder) throws IOException {
        if (this.parentOutput != null) {
            return builder.build(this.parentOutput);
        }
        if (this.sharedChannel == null) {
            this.sharedChannel = new IgvDumpChannel(() -> this.getDumpPath(".bgv", false), this.immutable.options);
        }
        builder.attr("vm.uuid", GraalServices.getExecutionID());
        GraphOutput<G, M> output = builder.build(this.sharedChannel);
        this.parentOutput = output;
        return output;
    }

    public static Map<Object, Object> addVersionProperties(Map<Object, Object> properties) {
        return Versions.VERSIONS.withVersions(properties);
    }

    public OptionValues getOptions() {
        return this.immutable.options;
    }

    public Activation activate() {
        Activation res = new Activation((DebugContext)activated.get());
        activated.set(this);
        return res;
    }

    public static DebugContext disabled(OptionValues options) {
        if (options == null || options.getMap().isEmpty()) {
            return DISABLED;
        }
        return new DebugContext(NO_DESCRIPTION, null, NO_GLOBAL_METRIC_VALUES, DebugContext.getDefaultLogStream(), Immutable.create(options), NO_CONFIG_CUSTOMIZERS);
    }

    public static DebugContext forCurrentThread() {
        DebugContext current = (DebugContext)activated.get();
        if (current == null) {
            return DISABLED;
        }
        return current;
    }

    public Description getDescription() {
        return this.description;
    }

    public boolean hasCompilationListener() {
        return this.compilationListener != null;
    }

    public CompilerPhaseScope enterCompilerPhase(CharSequence phaseName) {
        if (this.compilationListener != null) {
            return this.enterCompilerPhase(() -> phaseName);
        }
        return null;
    }

    public CompilerPhaseScope enterCompilerPhase(Supplier<CharSequence> phaseName) {
        CompilationListener l = this.compilationListener;
        if (l != null) {
            final CompilerPhaseScope scope = l.enterPhase(phaseName.get(), this.compilerPhaseNesting++);
            return new CompilerPhaseScope(){

                @Override
                public void close() {
                    --DebugContext.this.compilerPhaseNesting;
                    scope.close();
                }
            };
        }
        return null;
    }

    public void notifyInlining(ResolvedJavaMethod caller, ResolvedJavaMethod callee, boolean succeeded, CharSequence message, int bci) {
        if (this.compilationListener != null) {
            this.compilationListener.notifyInlining(caller, callee, succeeded, message, bci);
        }
    }

    public GlobalMetrics getGlobalMetrics() {
        return this.globalMetrics;
    }

    private DebugContext(Description description, CompilationListener compilationListener, GlobalMetrics globalMetrics, PrintStream logStream, Immutable immutable, Iterable<DebugHandlersFactory> factories) {
        this.immutable = immutable;
        this.description = description;
        this.globalMetrics = globalMetrics;
        this.compilationListener = compilationListener;
        if (immutable.scopesEnabled) {
            OptionValues options = immutable.options;
            ArrayList<DebugDumpHandler> dumpHandlers = new ArrayList<DebugDumpHandler>();
            ArrayList<DebugVerifyHandler> verifyHandlers = new ArrayList<DebugVerifyHandler>();
            for (DebugHandlersFactory factory : factories) {
                for (DebugHandler handler : factory.createHandlers(options)) {
                    if (handler instanceof DebugDumpHandler) {
                        dumpHandlers.add((DebugDumpHandler)handler);
                        continue;
                    }
                    assert (handler instanceof DebugVerifyHandler);
                    verifyHandlers.add((DebugVerifyHandler)handler);
                }
            }
            this.currentConfig = new DebugConfigImpl(options, logStream, dumpHandlers, verifyHandlers);
            this.currentScope = new ScopeImpl(this, Thread.currentThread(), DebugOptions.DisableIntercept.getValue(options));
            this.currentScope.updateFlags(this.currentConfig);
            this.metricsEnabled = true;
        } else {
            this.metricsEnabled = immutable.hasUnscopedMetrics() || immutable.listMetrics;
        }
    }

    public Path getDumpPath(String extension, boolean createMissingDirectory) {
        try {
            String id = this.description == null ? null : this.description.identifier;
            String label = this.description == null ? null : this.description.getLabel();
            Path result = PathUtilities.createUnique(this.immutable.options, DebugOptions.DumpPath, id, label, extension, createMissingDirectory);
            if (DebugOptions.ShowDumpFiles.getValue(this.immutable.options).booleanValue()) {
                TTY.println("Dumping debug output to %s", result.toAbsolutePath().toString());
            }
            return result;
        }
        catch (IOException ex) {
            throw DebugContext.rethrowSilently(RuntimeException.class, ex);
        }
    }

    public boolean isDumpEnabled(int dumpLevel) {
        return this.currentScope != null && this.currentScope.isDumpEnabled(dumpLevel);
    }

    public boolean isVerifyEnabledForMethod() {
        if (this.currentScope == null) {
            return false;
        }
        if (this.currentConfig == null) {
            return false;
        }
        return this.currentConfig.isVerifyEnabledForMethod(this.currentScope);
    }

    public boolean isVerifyEnabled() {
        return this.currentScope != null && this.currentScope.isVerifyEnabled();
    }

    public boolean isCountEnabled() {
        return this.currentScope != null && this.currentScope.isCountEnabled();
    }

    public boolean isTimeEnabled() {
        return this.currentScope != null && this.currentScope.isTimeEnabled();
    }

    public boolean isMemUseTrackingEnabled() {
        return this.currentScope != null && this.currentScope.isMemUseTrackingEnabled();
    }

    public boolean isDumpEnabledForMethod() {
        if (this.currentConfig == null) {
            return false;
        }
        return this.currentConfig.isDumpEnabledForMethod(this.currentScope);
    }

    public boolean isLogEnabledForMethod() {
        if (this.currentScope == null) {
            return false;
        }
        if (this.currentConfig == null) {
            return false;
        }
        return this.currentConfig.isLogEnabledForMethod(this.currentScope);
    }

    public boolean isLogEnabled() {
        return this.currentScope != null && this.isLogEnabled(1);
    }

    public boolean isLogEnabled(int logLevel) {
        return this.currentScope != null && this.currentScope.isLogEnabled(logLevel);
    }

    public String getCurrentScopeName() {
        if (this.currentScope != null) {
            return this.currentScope.getQualifiedName();
        }
        return "";
    }

    public Scope scope(Object name, Object[] contextObjects) throws Throwable {
        if (this.currentScope != null) {
            return this.enterScope(DebugContext.convertFormatArg(name).toString(), null, contextObjects);
        }
        return null;
    }

    public Scope scope(Object name) {
        if (this.currentScope != null) {
            return this.enterScope(DebugContext.convertFormatArg(name).toString(), null, new Object[0]);
        }
        return null;
    }

    static StackTraceElement[] getStackTrace(Thread thread) {
        return thread.getStackTrace();
    }

    boolean checkNoConcurrentAccess() {
        assert (this.invariants == null || this.invariants.checkNoConcurrentAccess());
        return true;
    }

    private Scope enterScope(CharSequence name, DebugConfig sandboxConfig, Object ... newContextObjects) {
        assert (this.checkNoConcurrentAccess());
        this.currentScope = this.currentScope.scope(name, sandboxConfig, newContextObjects);
        return this.currentScope;
    }

    public Scope scope(Object name, Object context) throws Throwable {
        if (this.currentScope != null) {
            return this.enterScope(DebugContext.convertFormatArg(name).toString(), null, context);
        }
        return null;
    }

    public Scope scope(Object name, Object context1, Object context2) throws Throwable {
        if (this.currentScope != null) {
            return this.enterScope(DebugContext.convertFormatArg(name).toString(), null, context1, context2);
        }
        return null;
    }

    public Scope scope(Object name, Object context1, Object context2, Object context3) throws Throwable {
        if (this.currentScope != null) {
            return this.enterScope(DebugContext.convertFormatArg(name).toString(), null, context1, context2, context3);
        }
        return null;
    }

    public Scope withContext(Object context) throws Throwable {
        if (this.currentScope != null) {
            return this.enterScope("", null, context);
        }
        return null;
    }

    public Scope sandbox(CharSequence name, DebugConfig config, Object ... context) throws Throwable {
        if (config == null) {
            return this.disable();
        }
        if (this.currentScope != null) {
            return this.enterScope(name, config, context);
        }
        return null;
    }

    public boolean inNestedScope() {
        if (this.immutable.scopesEnabled) {
            if (this.currentScope == null) {
                return true;
            }
            return !this.currentScope.isTopLevel();
        }
        return false;
    }

    public Scope disable() {
        if (this.currentScope != null) {
            return new DisabledScope();
        }
        return null;
    }

    public Scope forceLog() throws Throwable {
        if (this.currentConfig != null) {
            ArrayList<Object> context = new ArrayList<Object>();
            for (Object obj : this.context()) {
                context.add(obj);
            }
            DebugConfigImpl config = new DebugConfigImpl(new OptionValues(this.currentConfig.getOptions(), DebugOptions.Log, ":1000", new Object[0]));
            return this.sandbox("forceLog", config, context.toArray());
        }
        return null;
    }

    public DebugCloseable disableIntercept() {
        if (this.currentScope != null) {
            return this.currentScope.disableIntercept();
        }
        return null;
    }

    public RuntimeException handle(Throwable exception) {
        if (this.currentScope != null) {
            return this.currentScope.handle(exception);
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    public void log(String msg) {
        this.log(1, msg);
    }

    public void log(int logLevel, String msg) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, msg, new Object[0]);
        }
    }

    public void log(String format, Object arg) {
        this.log(1, format, arg);
    }

    public void log(int logLevel, String format, Object arg) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg);
        }
    }

    public void log(String format, int arg) {
        this.log(1, format, arg);
    }

    public void log(int logLevel, String format, int arg) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg);
        }
    }

    public void log(String format, Object arg1, Object arg2) {
        this.log(1, format, arg1, arg2);
    }

    public void log(int logLevel, String format, Object arg1, Object arg2) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2);
        }
    }

    public void log(String format, int arg1, Object arg2) {
        this.log(1, format, arg1, arg2);
    }

    public void log(int logLevel, String format, int arg1, Object arg2) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2);
        }
    }

    public void log(String format, Object arg1, int arg2) {
        this.log(1, format, arg1, arg2);
    }

    public void log(int logLevel, String format, Object arg1, int arg2) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2);
        }
    }

    public void log(String format, int arg1, int arg2) {
        this.log(1, format, arg1, arg2);
    }

    public void log(int logLevel, String format, int arg1, int arg2) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2);
        }
    }

    public void log(String format, Object arg1, Object arg2, Object arg3) {
        this.log(1, format, arg1, arg2, arg3);
    }

    public void log(int logLevel, String format, Object arg1, Object arg2, Object arg3) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2, arg3);
        }
    }

    public void log(String format, int arg1, int arg2, int arg3) {
        this.log(1, format, arg1, arg2, arg3);
    }

    public void log(int logLevel, String format, int arg1, int arg2, int arg3) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2, arg3);
        }
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.log(1, format, arg1, arg2, arg3, arg4);
    }

    public void log(int logLevel, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2, arg3, arg4);
        }
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this.log(1, format, arg1, arg2, arg3, arg4, arg5);
    }

    public void log(int logLevel, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2, arg3, arg4, arg5);
        }
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        this.log(1, format, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public void log(int logLevel, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        this.log(1, format, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        this.log(1, format, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public void log(int logLevel, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }
    }

    public void log(int logLevel, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
        }
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        this.log(1, format, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    public void log(int logLevel, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
        }
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) {
        this.log(1, format, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    public void log(int logLevel, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) {
        if (this.currentScope != null) {
            this.currentScope.log(logLevel, format, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
        }
    }

    public void logv(String format, Object ... args) {
        this.logv(1, format, args);
    }

    public void logv(int logLevel, String format, Object ... args) {
        if (this.currentScope == null) {
            throw new InternalError("Use of Debug.logv() must be guarded by a test of Debug.isEnabled()");
        }
        this.currentScope.log(logLevel, format, args);
    }

    @Deprecated
    public void log(String format, Object[] args) {
        assert (false) : "shouldn't use this";
        this.log(1, format, args);
    }

    @Deprecated
    public void log(int logLevel, String format, Object[] args) {
        assert (false) : "shouldn't use this";
        this.logv(logLevel, format, args);
    }

    public void forceDump(Object object, String format, Object ... args) {
        boolean closeAfterDump;
        Collection<DebugDumpHandler> dumpHandlers;
        DebugConfigImpl config = this.currentConfig;
        if (config != null) {
            dumpHandlers = config.dumpHandlers();
            closeAfterDump = false;
        } else {
            OptionValues options = this.getOptions();
            dumpHandlers = new ArrayList<DebugDumpHandler>();
            for (DebugHandlersFactory factory : DebugHandlersFactory.LOADER) {
                for (DebugHandler handler : factory.createHandlers(options)) {
                    if (!(handler instanceof DebugDumpHandler)) continue;
                    dumpHandlers.add((DebugDumpHandler)handler);
                }
            }
            closeAfterDump = true;
        }
        for (DebugDumpHandler dumpHandler : dumpHandlers) {
            dumpHandler.dump(this, object, format, args);
            if (!closeAfterDump) continue;
            dumpHandler.close();
        }
    }

    public void dump(int dumpLevel, Object object, String msg) {
        if (this.currentScope != null && this.currentScope.isDumpEnabled(dumpLevel)) {
            this.currentScope.dump(dumpLevel, object, msg, new Object[0]);
        }
    }

    public void dump(int dumpLevel, Object object, String format, Object arg) {
        if (this.currentScope != null && this.currentScope.isDumpEnabled(dumpLevel)) {
            this.currentScope.dump(dumpLevel, object, format, arg);
        }
    }

    public void dump(int dumpLevel, Object object, String format, Object arg1, Object arg2) {
        if (this.currentScope != null && this.currentScope.isDumpEnabled(dumpLevel)) {
            this.currentScope.dump(dumpLevel, object, format, arg1, arg2);
        }
    }

    public void dump(int dumpLevel, Object object, String format, Object arg1, Object arg2, Object arg3) {
        if (this.currentScope != null && this.currentScope.isDumpEnabled(dumpLevel)) {
            this.currentScope.dump(dumpLevel, object, format, arg1, arg2, arg3);
        }
    }

    @Deprecated
    public void dump(int dumpLevel, Object object, String format, Object[] args) {
        assert (false) : "shouldn't use this";
        if (this.currentScope != null && this.currentScope.isDumpEnabled(dumpLevel)) {
            this.currentScope.dump(dumpLevel, object, format, args);
        }
    }

    public void verify(Object object, String message) {
        if (this.currentScope != null && this.currentScope.isVerifyEnabled()) {
            this.currentScope.verify(object, message, new Object[0]);
        }
    }

    public void verify(Object object, String format, Object arg) {
        if (this.currentScope != null && this.currentScope.isVerifyEnabled()) {
            this.currentScope.verify(object, format, arg);
        }
    }

    @Deprecated
    public void verify(Object object, String format, Object[] args) {
        assert (false) : "shouldn't use this";
        if (this.currentScope != null && this.currentScope.isVerifyEnabled()) {
            this.currentScope.verify(object, format, args);
        }
    }

    public Indent indent() {
        if (this.currentScope != null) {
            return this.currentScope.pushIndentLogger();
        }
        return null;
    }

    public Indent logAndIndent(String msg) {
        return this.logAndIndent(1, msg);
    }

    public Indent logAndIndent(int logLevel, String msg) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, msg, new Object[0]);
        }
        return null;
    }

    public Indent logAndIndent(String format, Object arg) {
        return this.logAndIndent(1, format, arg);
    }

    public Indent logAndIndent(int logLevel, String format, Object arg) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg);
        }
        return null;
    }

    public Indent logAndIndent(String format, int arg) {
        return this.logAndIndent(1, format, arg);
    }

    public Indent logAndIndent(int logLevel, String format, int arg) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg);
        }
        return null;
    }

    public Indent logAndIndent(String format, int arg1, Object arg2) {
        return this.logAndIndent(1, format, arg1, arg2);
    }

    public Indent logAndIndent(int logLevel, String format, int arg1, Object arg2) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg1, arg2);
        }
        return null;
    }

    public Indent logAndIndent(String format, Object arg1, int arg2) {
        return this.logAndIndent(1, format, arg1, arg2);
    }

    public Indent logAndIndent(int logLevel, String format, Object arg1, int arg2) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg1, arg2);
        }
        return null;
    }

    public Indent logAndIndent(String format, int arg1, int arg2) {
        return this.logAndIndent(1, format, arg1, arg2);
    }

    public Indent logAndIndent(int logLevel, String format, int arg1, int arg2) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg1, arg2);
        }
        return null;
    }

    public Indent logAndIndent(String format, Object arg1, Object arg2) {
        return this.logAndIndent(1, format, arg1, arg2);
    }

    public Indent logAndIndent(int logLevel, String format, Object arg1, Object arg2) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg1, arg2);
        }
        return null;
    }

    public Indent logAndIndent(String format, Object arg1, Object arg2, Object arg3) {
        return this.logAndIndent(1, format, arg1, arg2, arg3);
    }

    public Indent logAndIndent(int logLevel, String format, Object arg1, Object arg2, Object arg3) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg1, arg2, arg3);
        }
        return null;
    }

    public Indent logAndIndent(String format, int arg1, int arg2, int arg3) {
        return this.logAndIndent(1, format, arg1, arg2, arg3);
    }

    public Indent logAndIndent(int logLevel, String format, int arg1, int arg2, int arg3) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg1, arg2, arg3);
        }
        return null;
    }

    public Indent logAndIndent(String format, Object arg1, int arg2, int arg3) {
        return this.logAndIndent(1, format, arg1, arg2, arg3);
    }

    public Indent logAndIndent(int logLevel, String format, Object arg1, int arg2, int arg3) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg1, arg2, arg3);
        }
        return null;
    }

    public Indent logAndIndent(String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.logAndIndent(1, format, arg1, arg2, arg3, arg4);
    }

    public Indent logAndIndent(int logLevel, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg1, arg2, arg3, arg4);
        }
        return null;
    }

    public Indent logAndIndent(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return this.logAndIndent(1, format, arg1, arg2, arg3, arg4, arg5);
    }

    public Indent logAndIndent(int logLevel, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg1, arg2, arg3, arg4, arg5);
        }
        return null;
    }

    public Indent logAndIndent(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        return this.logAndIndent(1, format, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public Indent logAndIndent(int logLevel, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if (this.currentScope != null && this.isLogEnabled(logLevel)) {
            return this.logvAndIndentInternal(logLevel, format, arg1, arg2, arg3, arg4, arg5, arg6);
        }
        return null;
    }

    public Indent logvAndIndent(int logLevel, String format, Object ... args) {
        if (this.currentScope != null) {
            if (this.isLogEnabled(logLevel)) {
                return this.logvAndIndentInternal(logLevel, format, args);
            }
            return null;
        }
        throw new InternalError("Use of Debug.logvAndIndent() must be guarded by a test of Debug.isEnabled()");
    }

    private Indent logvAndIndentInternal(int logLevel, String format, Object ... args) {
        assert (this.currentScope != null && this.isLogEnabled(logLevel)) : "must have checked Debug.isLogEnabled()";
        this.currentScope.log(logLevel, format, args);
        return this.currentScope.pushIndentLogger();
    }

    @Deprecated
    public void logAndIndent(String format, Object[] args) {
        assert (false) : "shouldn't use this";
        this.logAndIndent(1, format, args);
    }

    @Deprecated
    public void logAndIndent(int logLevel, String format, Object[] args) {
        assert (false) : "shouldn't use this";
        this.logvAndIndent(logLevel, format, args);
    }

    public Iterable<Object> context() {
        if (this.currentScope != null) {
            return this.currentScope.getCurrentContext();
        }
        return Collections.emptyList();
    }

    public <T> List<T> contextSnapshot(Class<T> clazz) {
        if (this.currentScope != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : this.context()) {
                if (!clazz.isInstance(o)) continue;
                result.add(o);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public <T> T contextLookup(Class<T> clazz) {
        if (this.currentScope != null) {
            for (Object o : this.context()) {
                if (!clazz.isInstance(o)) continue;
                return (T)o;
            }
        }
        return null;
    }

    public <T> T contextLookupTopdown(Class<T> clazz) {
        if (this.currentScope != null) {
            Object found = null;
            for (Object o : this.context()) {
                if (!clazz.isInstance(o)) continue;
                found = o;
            }
            return (T)found;
        }
        return null;
    }

    public static MemUseTrackerKey memUseTracker(CharSequence name) {
        return DebugContext.createMemUseTracker("%s", name, null);
    }

    public static MemUseTrackerKey memUseTracker(String format, Object arg) {
        return DebugContext.createMemUseTracker(format, arg, null);
    }

    public static MemUseTrackerKey memUseTracker(String format, Object arg1, Object arg2) {
        return DebugContext.createMemUseTracker(format, arg1, arg2);
    }

    private static MemUseTrackerKey createMemUseTracker(String format, Object arg1, Object arg2) {
        return new MemUseTrackerKeyImpl(format, arg1, arg2);
    }

    public static CounterKey counter(CharSequence name) {
        return DebugContext.createCounter("%s", name, null);
    }

    public long[] addValuesTo(long[] tally) {
        if (this.metricValues == null) {
            return tally;
        }
        if (tally == null) {
            return (long[])this.metricValues.clone();
        }
        if (this.metricValues.length >= tally.length) {
            long[] newTally = (long[])this.metricValues.clone();
            for (int i = 0; i < tally.length; ++i) {
                int n = i;
                newTally[n] = newTally[n] + tally[i];
            }
            return newTally;
        }
        for (int i = 0; i < this.metricValues.length; ++i) {
            int n = i;
            tally[n] = tally[n] + this.metricValues[i];
        }
        return tally;
    }

    public static EconomicMap<MetricKey, Long> convertValuesToKeyValueMap(long[] values) {
        List<MetricKey> keys = KeyRegistry.getKeys();
        Collections.sort(keys, MetricKey.NAME_COMPARATOR);
        EconomicMap res = EconomicMap.create((int)keys.size());
        for (MetricKey key : keys) {
            int index = ((AbstractKey)key).getIndex();
            if (index >= values.length) {
                res.put((Object)key, (Object)0L);
                continue;
            }
            res.put((Object)key, (Object)values[index]);
        }
        return res;
    }

    void setMetricValue(int keyIndex, long l) {
        this.ensureMetricValuesSize(keyIndex);
        this.metricValues[keyIndex] = l;
    }

    long getMetricValue(int keyIndex) {
        if (this.metricValues == null || this.metricValues.length <= keyIndex) {
            return 0L;
        }
        return this.metricValues[keyIndex];
    }

    private void ensureMetricValuesSize(int index) {
        if (this.metricValues == null) {
            this.metricValues = new long[index + 1];
        }
        if (this.metricValues.length <= index) {
            this.metricValues = Arrays.copyOf(this.metricValues, index + 1);
        }
    }

    public static String applyFormattingFlagsAndWidth(String s, int flags, int width) {
        if (flags == 0 && width < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        int len = sb.length();
        if (len < width) {
            for (int i = 0; i < width - len; ++i) {
                if ((flags & 1) == 1) {
                    sb.append(' ');
                    continue;
                }
                sb.insert(0, ' ');
            }
        }
        String res = sb.toString();
        if ((flags & 2) == 2) {
            res = res.toUpperCase();
        }
        return res;
    }

    public static CounterKey counter(String format, Object arg) {
        return DebugContext.createCounter(format, arg, null);
    }

    public static CounterKey counter(String format, Object arg1, Object arg2) {
        return DebugContext.createCounter(format, arg1, arg2);
    }

    private static CounterKey createCounter(String format, Object arg1, Object arg2) {
        return new CounterKeyImpl(format, arg1, arg2);
    }

    public DebugConfig getConfig() {
        return this.currentConfig;
    }

    public static TimerKey timer(CharSequence name) {
        return DebugContext.createTimer("%s", name, null);
    }

    public static TimerKey timer(String format, Object arg) {
        return DebugContext.createTimer(format, arg, null);
    }

    public static TimerKey timer(String format, Object arg1, Object arg2) {
        return DebugContext.createTimer(format, arg1, arg2);
    }

    private static String getBaseName(Class<?> c) {
        String simpleName = c.getSimpleName();
        if (simpleName.length() < 6) {
            for (int i = 0; i < simpleName.length(); ++i) {
                if (Character.isLowerCase(simpleName.charAt(0))) continue;
                return simpleName;
            }
            return c.getName();
        }
        return simpleName;
    }

    public static Object convertFormatArg(Object arg) {
        if (arg instanceof Class) {
            return formattedClassName.get((Class)arg);
        }
        return arg;
    }

    static String formatDebugName(String format, Object arg1, Object arg2) {
        return String.format(format, DebugContext.convertFormatArg(arg1), DebugContext.convertFormatArg(arg2));
    }

    private static TimerKey createTimer(String format, Object arg1, Object arg2) {
        return new TimerKeyImpl(format, arg1, arg2);
    }

    boolean isTimerEnabled(TimerKeyImpl key) {
        if (!this.metricsEnabled) {
            return false;
        }
        return this.isTimerEnabledSlow(key);
    }

    private boolean isTimerEnabledSlow(AbstractKey key) {
        if (this.currentScope != null && this.currentScope.isTimeEnabled()) {
            return true;
        }
        if (this.immutable.listMetrics) {
            key.ensureInitialized();
        }
        assert (this.checkNoConcurrentAccess());
        EconomicSet<String> unscoped = this.immutable.unscopedTimers;
        return unscoped != null && (unscoped.isEmpty() || unscoped.contains((Object)key.getName()));
    }

    boolean isCounterEnabled(CounterKeyImpl key) {
        if (!this.metricsEnabled) {
            return false;
        }
        return this.isCounterEnabledSlow(key);
    }

    private boolean isCounterEnabledSlow(AbstractKey key) {
        if (this.currentScope != null && this.currentScope.isCountEnabled()) {
            return true;
        }
        if (this.immutable.listMetrics) {
            key.ensureInitialized();
        }
        assert (this.checkNoConcurrentAccess());
        EconomicSet<String> unscoped = this.immutable.unscopedCounters;
        return unscoped != null && (unscoped.isEmpty() || unscoped.contains((Object)key.getName()));
    }

    boolean isMemUseTrackerEnabled(MemUseTrackerKeyImpl key) {
        if (!this.metricsEnabled) {
            return false;
        }
        return this.isMemUseTrackerEnabledSlow(key);
    }

    private boolean isMemUseTrackerEnabledSlow(AbstractKey key) {
        if (this.currentScope != null && this.currentScope.isMemUseTrackingEnabled()) {
            return true;
        }
        if (this.immutable.listMetrics) {
            key.ensureInitialized();
        }
        assert (this.checkNoConcurrentAccess());
        EconomicSet<String> unscoped = this.immutable.unscopedMemUseTrackers;
        return unscoped != null && (unscoped.isEmpty() || unscoped.contains((Object)key.getName()));
    }

    public boolean areMetricsEnabled() {
        return this.metricsEnabled;
    }

    @Override
    public void close() {
        this.closeDumpHandlers(false);
        if (this.description != null) {
            this.printMetrics(this.description);
        }
        if (this.metricsEnabled && this.metricValues != null && this.globalMetrics != null) {
            this.globalMetrics.add(this);
        }
        this.metricValues = null;
        if (this.sharedChannel != null) {
            try {
                this.sharedChannel.realClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void closeDumpHandlers(boolean ignoreErrors) {
        if (this.currentConfig != null) {
            this.currentConfig.closeDumpHandlers(ignoreErrors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMetrics(Description desc) {
        if (this.metricValues == null) {
            return;
        }
        String metricsFile = DebugOptions.MetricsFile.getValue(this.getOptions());
        if (metricsFile != null) {
            int compilationNr;
            Object compilable = desc.compilable;
            Integer identity = System.identityHashCode(compilable);
            Object object = PRINT_METRICS_LOCK;
            synchronized (object) {
                if (!metricsFileDeleteCheckPerformed) {
                    metricsFileDeleteCheckPerformed = true;
                    File file = new File(metricsFile);
                    if (file.exists()) {
                        file.delete();
                    }
                }
                if (compilations == null) {
                    compilationNr = 0;
                    compilations = EconomicMap.create();
                } else {
                    Integer value = (Integer)compilations.get((Object)identity);
                    compilationNr = value == null ? 0 : value + 1;
                }
                compilations.put((Object)identity, (Object)compilationNr);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(metricsBufSize);
            PrintStream out = new PrintStream(baos);
            if (metricsFile.endsWith(".csv") || metricsFile.endsWith(".CSV")) {
                this.printMetricsCSV(out, compilable, identity, compilationNr, desc.identifier);
            } else {
                this.printMetrics(out, compilable, identity, compilationNr, desc.identifier);
            }
            byte[] content = baos.toByteArray();
            Path path = Paths.get(metricsFile, new String[0]);
            Object object2 = PRINT_METRICS_LOCK;
            synchronized (object2) {
                metricsBufSize = Math.max(metricsBufSize, content.length);
                try {
                    Files.write(path, content, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void printMetricsCSV(PrintStream out, Object compilable, Integer identity, int compilationNr, String compilationId) {
        String compilableName = compilable instanceof JavaMethod ? ((JavaMethod)compilable).format("%H.%n(%p)%R") : String.valueOf(compilable);
        String csvFormat = CSVUtil.buildFormatString("%s", "%s", "%d", "%s");
        String format = String.format(csvFormat, CSVUtil.Escape.escapeArgs(compilableName, identity, compilationNr, compilationId));
        char sep = ';';
        format = format + sep + "%s" + sep + "%s" + sep + "%s";
        for (MetricKey key : KeyRegistry.getKeys()) {
            int index = ((AbstractKey)key).getIndex();
            if (index >= this.metricValues.length) continue;
            Pair<String, String> valueAndUnit = key.toCSVFormat(this.metricValues[index]);
            CSVUtil.Escape.println(out, format, CSVUtil.Escape.escape(key.getName()), valueAndUnit.getLeft(), valueAndUnit.getRight());
        }
    }

    private void printMetrics(PrintStream out, Object compilable, Integer identity, int compilationNr, String compilationId) {
        String compilableName = compilable instanceof JavaMethod ? ((JavaMethod)compilable).format("%H.%n(%p)%R") : String.valueOf(compilable);
        int maxKeyWidth = compilableName.length();
        TreeMap<String, String> res = new TreeMap<String, String>();
        for (MetricKey key : KeyRegistry.getKeys()) {
            String valueString;
            int index = ((AbstractKey)key).getIndex();
            if (index >= this.metricValues.length || this.metricValues[index] == 0L) continue;
            String name = key.getName();
            long value = this.metricValues[index];
            if (key instanceof TimerKey) {
                TimerKey timer = (TimerKey)key;
                long ms = timer.getTimeUnit().toMillis(value);
                if (ms == 0L) continue;
                valueString = ms + "ms";
            } else {
                valueString = String.valueOf(value);
            }
            res.put(name, valueString);
            maxKeyWidth = Math.max(maxKeyWidth, name.length());
        }
        String title = String.format("%s [id:%s compilation:%d compilation_id:%s]", compilableName, identity, compilationNr, compilationId);
        out.println(new String(new char[title.length()]).replace('\u0000', '#'));
        out.printf("%s%n", title);
        out.println(new String(new char[title.length()]).replace('\u0000', '~'));
        for (Map.Entry e : res.entrySet()) {
            out.printf("%-" + String.valueOf(maxKeyWidth) + "s = %20s%n", e.getKey(), e.getValue());
        }
        out.println();
    }

    public Map<MetricKey, Long> getMetricsSnapshot() {
        HashMap<MetricKey, Long> res = new HashMap<MetricKey, Long>();
        for (MetricKey key : KeyRegistry.getKeys()) {
            int index = ((AbstractKey)key).getIndex();
            if (index >= this.metricValues.length || this.metricValues[index] == 0L) continue;
            long value = this.metricValues[index];
            res.put(key, value);
        }
        return res;
    }

    private static <E extends Exception> E rethrowSilently(Class<E> type, Throwable ex) throws E {
        throw (Exception)ex;
    }

    static {
        metricsBufSize = 50000;
        PRINT_METRICS_LOCK = new Object();
    }

    public static interface Scope
    extends AutoCloseable {
        public String getQualifiedName();

        public Iterable<Object> getCurrentContext();

        @Override
        public void close();
    }

    class DisabledScope
    implements Scope {
        final boolean savedMetricsEnabled;
        final ScopeImpl savedScope;
        final DebugConfigImpl savedConfig;

        DisabledScope() {
            this.savedMetricsEnabled = DebugContext.this.metricsEnabled;
            this.savedScope = DebugContext.this.currentScope;
            this.savedConfig = DebugContext.this.currentConfig;
            DebugContext.this.metricsEnabled = false;
            DebugContext.this.currentScope = null;
            DebugContext.this.currentConfig = null;
        }

        @Override
        public String getQualifiedName() {
            return "";
        }

        @Override
        public Iterable<Object> getCurrentContext() {
            return Collections.emptyList();
        }

        @Override
        public void close() {
            DebugContext.this.metricsEnabled = this.savedMetricsEnabled;
            DebugContext.this.currentScope = this.savedScope;
            DebugContext.this.currentConfig = this.savedConfig;
            DebugContext.this.lastClosedScope = this;
        }
    }

    static class Invariants {
        private final Thread thread = Thread.currentThread();
        private final StackTraceElement[] origin = DebugContext.getStackTrace(this.thread);

        Invariants() {
        }

        boolean checkNoConcurrentAccess() {
            Thread currentThread = Thread.currentThread();
            if (currentThread != this.thread) {
                Formatter buf = new Formatter();
                buf.format("Thread local %s object was created on thread %s but is being accessed by thread %s. The most likely cause is that the object is being retrieved from a non-thread-local cache.", DebugContext.class.getName(), this.thread, currentThread);
                int debugContextConstructors = 0;
                boolean addedHeader = false;
                for (StackTraceElement e : this.origin) {
                    if (e.getMethodName().equals("<init>") && e.getClassName().equals(DebugContext.class.getName())) {
                        ++debugContextConstructors;
                        continue;
                    }
                    if (debugContextConstructors == 0) continue;
                    if (!addedHeader) {
                        addedHeader = true;
                        buf.format(" The object was instantiated here:", new Object[0]);
                    }
                    buf.format("%n\t\tin %s", e);
                }
                if (addedHeader) {
                    buf.format("%n", new Object[0]);
                }
                throw new AssertionError((Object)buf.toString());
            }
            return true;
        }
    }

    public static class Builder {
        private final OptionValues options;
        private Description description = NO_DESCRIPTION;
        private CompilationListener compilationListener;
        private GlobalMetrics globalMetrics = NO_GLOBAL_METRIC_VALUES;
        private PrintStream logStream = DebugContext.getDefaultLogStream();
        private final Iterable<DebugHandlersFactory> factories;

        public Builder(OptionValues options) {
            this.options = options;
            this.factories = DebugHandlersFactory.LOADER;
        }

        public Builder(OptionValues options, Iterable<DebugHandlersFactory> factories) {
            this.options = options;
            this.factories = factories;
        }

        public Builder(OptionValues options, DebugHandlersFactory factory) {
            this.options = options;
            this.factories = factory == null ? NO_CONFIG_CUSTOMIZERS : Collections.singletonList(factory);
        }

        public Builder description(Description desc) {
            this.description = desc;
            return this;
        }

        public Builder compilationListener(CompilationListener listener) {
            this.compilationListener = listener;
            return this;
        }

        public Builder globalMetrics(GlobalMetrics metrics) {
            this.globalMetrics = metrics;
            return this;
        }

        public Builder logStream(PrintStream stream) {
            this.logStream = stream;
            return this;
        }

        public DebugContext build() {
            return new DebugContext(this.description, this.compilationListener, this.globalMetrics, this.logStream, Immutable.create(this.options), this.factories);
        }
    }

    public static interface CompilerPhaseScope
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static class Description {
        final Object compilable;
        final String identifier;

        public Description(Object compilable, String identifier) {
            this.compilable = compilable;
            this.identifier = identifier;
        }

        public String toString() {
            String compilableName = this.compilable instanceof JavaMethod ? ((JavaMethod)this.compilable).format("%H.%n(%p)%R") : String.valueOf(this.compilable);
            return this.identifier + ":" + compilableName;
        }

        final String getLabel() {
            if (this.compilable instanceof JavaMethod) {
                JavaMethod method = (JavaMethod)this.compilable;
                return method.format("%h.%n(%p)%r");
            }
            return String.valueOf(this.compilable);
        }
    }

    public static class Activation
    implements AutoCloseable {
        private final DebugContext parent;

        Activation(DebugContext parent) {
            this.parent = parent;
        }

        @Override
        public void close() {
            activated.set(this.parent);
        }
    }

    static class Activated
    extends ThreadLocal<DebugContext> {
        Activated() {
        }
    }

    static final class Immutable {
        private static final Immutable[] CACHE = new Immutable[5];
        final OptionValues options;
        final boolean scopesEnabled;
        final boolean listMetrics;
        final EconomicSet<String> unscopedCounters;
        final EconomicSet<String> unscopedTimers;
        final EconomicSet<String> unscopedMemUseTrackers;

        private static EconomicSet<String> parseUnscopedMetricSpec(String spec, boolean unconditional, boolean accumulatedKey) {
            Object res;
            if (spec == null) {
                res = !unconditional ? null : EconomicSet.create();
            } else {
                res = EconomicSet.create();
                if (!spec.isEmpty()) {
                    if (!accumulatedKey) {
                        res.addAll(Arrays.asList(spec.split(",")));
                    } else {
                        for (String n : spec.split(",")) {
                            res.add((Object)(n + "_Accm"));
                            res.add((Object)(n + "_Flat"));
                        }
                    }
                }
            }
            return res;
        }

        static Immutable create(OptionValues options) {
            Immutable immutable;
            int i;
            for (i = 0; i < CACHE.length && (immutable = CACHE[i]) != null; ++i) {
                if (immutable.options != options) continue;
                return immutable;
            }
            immutable = new Immutable(options);
            if (i < CACHE.length) {
                Immutable.CACHE[i] = immutable;
            }
            return immutable;
        }

        private static boolean isNotEmpty(OptionKey<String> option, OptionValues options) {
            return option.getValue(options) != null && !option.getValue(options).isEmpty();
        }

        private Immutable(OptionValues options) {
            this.options = options;
            String timeValue = DebugOptions.Time.getValue(options);
            String trackMemUseValue = DebugOptions.TrackMemUse.getValue(options);
            this.unscopedCounters = Immutable.parseUnscopedMetricSpec(DebugOptions.Counters.getValue(options), "".equals(DebugOptions.Count.getValue(options)), false);
            this.unscopedTimers = Immutable.parseUnscopedMetricSpec(DebugOptions.Timers.getValue(options), "".equals(timeValue), true);
            this.unscopedMemUseTrackers = Immutable.parseUnscopedMetricSpec(DebugOptions.MemUseTrackers.getValue(options), "".equals(trackMemUseValue), true);
            if (!(this.unscopedMemUseTrackers == null && trackMemUseValue == null || GraalServices.isThreadAllocatedMemorySupported())) {
                TTY.println("WARNING: Missing VM support for MemUseTrackers and TrackMemUse options so all reported memory usage will be 0");
            }
            this.scopesEnabled = DebugOptions.DumpOnError.getValue(options) != false || DebugOptions.Dump.getValue(options) != null || DebugOptions.Log.getValue(options) != null || Immutable.isNotEmpty(DebugOptions.Count, options) || Immutable.isNotEmpty(DebugOptions.Time, options) || Immutable.isNotEmpty(DebugOptions.TrackMemUse, options) || DebugOptions.DumpOnPhaseChange.getValue(options) != null;
            this.listMetrics = DebugOptions.ListMetrics.getValue(options);
        }

        private Immutable() {
            this.options = new OptionValues((UnmodifiableEconomicMap<OptionKey<?>, Object>)EconomicMap.create());
            this.unscopedCounters = null;
            this.unscopedTimers = null;
            this.unscopedMemUseTrackers = null;
            this.scopesEnabled = false;
            this.listMetrics = false;
        }

        public boolean hasUnscopedMetrics() {
            return this.unscopedCounters != null || this.unscopedTimers != null || this.unscopedMemUseTrackers != null;
        }
    }
}

