/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.sparc;

import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.debug.GraalError;

public class SPARCLIRKindTool
implements LIRKindTool {
    @Override
    public LIRKind getIntegerKind(int bits) {
        if (bits <= 8) {
            return LIRKind.value((PlatformKind)SPARCKind.BYTE);
        }
        if (bits <= 16) {
            return LIRKind.value((PlatformKind)SPARCKind.HWORD);
        }
        if (bits <= 32) {
            return LIRKind.value((PlatformKind)SPARCKind.WORD);
        }
        assert (bits <= 64);
        return LIRKind.value((PlatformKind)SPARCKind.XWORD);
    }

    @Override
    public LIRKind getFloatingKind(int bits) {
        switch (bits) {
            case 32: {
                return LIRKind.value((PlatformKind)SPARCKind.SINGLE);
            }
            case 64: {
                return LIRKind.value((PlatformKind)SPARCKind.DOUBLE);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public LIRKind getObjectKind() {
        return LIRKind.reference((PlatformKind)SPARCKind.XWORD);
    }

    @Override
    public LIRKind getWordKind() {
        return LIRKind.value((PlatformKind)SPARCKind.XWORD);
    }

    @Override
    public LIRKind getNarrowOopKind() {
        return LIRKind.compressedReference((PlatformKind)SPARCKind.WORD);
    }

    @Override
    public LIRKind getNarrowPointerKind() {
        return LIRKind.value((PlatformKind)SPARCKind.WORD);
    }
}

